/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.dblayer.trans.TransactionResult;
import net.za.pwnconsulting.dblayer.trans.support.SerialField;
import net.za.pwnconsulting.javaconfig.exceptions.NoMatchFoundException;
import net.za.pwnconsulting.javaconfig.mail.SMTPMail;
import net.za.pwnconsulting.javaconfig.utils.DateUtils;
import net.za.pwnconsulting.javaconfig.utils.ListUtils;
import net.za.pwnconsulting.javaconfig.utils.MapUtils;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import za.co.pwnconsulting.aquatronica.AquatronicaSample;
import za.co.pwnconsulting.aquatronica.DBCase;
import za.co.pwnconsulting.aquatronica.DisconnectedFromEthernetModuleException;
import za.co.pwnconsulting.aquatronica.EventCodes;
import za.co.pwnconsulting.aquatronica.NotificationDetails;
import za.co.pwnconsulting.aquatronica.NotificationModule;
import za.co.pwnconsulting.aquatronica.OverlayGraphPreset;
import za.co.pwnconsulting.aquatronica.Plug;
import za.co.pwnconsulting.aquatronica.PlugData;
import za.co.pwnconsulting.aquatronica.PlugSample;
import za.co.pwnconsulting.aquatronica.PowerUnitPlug;
import za.co.pwnconsulting.aquatronica.PowerUnitSample;
import za.co.pwnconsulting.aquatronica.RawPlug;
import za.co.pwnconsulting.aquatronica.RawPowerunit;
import za.co.pwnconsulting.aquatronica.RawSensor;
import za.co.pwnconsulting.aquatronica.SensorData;
import za.co.pwnconsulting.aquatronica.SensorDefinition;
import za.co.pwnconsulting.aquatronica.Tank;
import za.co.pwnconsulting.aquatronica.TankLogEntry;
import za.co.pwnconsulting.aquatronica.WaterParameter;
import za.co.pwnconsulting.aquatronica.WaterParameterData;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.DBHelper;
import za.co.pwnconsulting.aquatronica.helpers.StatusCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AquatronicaInterface {
    private Configuration mConfiguration;
    private SimpleDateFormat mSimpleDateFormat;

    public AquatronicaInterface(Configuration pConfiguration) {
        this.mConfiguration = pConfiguration;
        this.mSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    }

    public AquatronicaSample sample() throws IOException, DocumentException {
        return this.sample("");
    }

    public AquatronicaSample sample(String pExtra) throws IOException, DocumentException {
        int i;
        int vCnt;
        Date vNow = new Date();
        Document vDoc = this.submitAquatronicaCommand("rtMon.xml?load=" + vNow.getTime() + (Utils.isEmptyString((String)pExtra) ? "" : "&" + pExtra));
        this.parseLogin(vDoc, false);
        AquatronicaSample vAquatronicaSample = new AquatronicaSample();
        if (vDoc.selectSingleNode("/xmlResponse/Monitor/sensorList") != null) {
            vCnt = Utils.getInt((String)vDoc.valueOf("count(/xmlResponse/Monitor/sensorList/sensor)"));
            for (i = 1; i <= vCnt; ++i) {
                String vSensorName = ((Element)vDoc.selectSingleNode("/xmlResponse/Monitor/sensorList/sensor[" + i + "]/name")).getTextTrim();
                String vSensorValue = ((Element)vDoc.selectSingleNode("/xmlResponse/Monitor/sensorList/sensor[" + i + "]/value")).getTextTrim();
                String vSensorStatus = ((Element)vDoc.selectSingleNode("/xmlResponse/Monitor/sensorList/sensor[" + i + "]/status")).getTextTrim();
                vAquatronicaSample.getSensorData().put(vSensorName, new SensorData(vNow, vSensorValue, EventCodes.parseSensorStatus(Utils.getInt((String)vSensorStatus)), Utils.getInt((String)vSensorStatus)));
            }
        }
        if (vDoc.selectSingleNode("/xmlResponse/Monitor/powerList") != null) {
            vCnt = Utils.getInt((String)vDoc.valueOf("count(/xmlResponse/Monitor/powerList/powerUnit)"));
            for (i = 1; i <= vCnt; ++i) {
                String vPowerUnitID = vDoc.valueOf("/xmlResponse/Monitor/powerList/powerUnit[" + i + "]/@id");
                String vPowerUnitName = ((Element)vDoc.selectSingleNode("/xmlResponse/Monitor/powerList/powerUnit[" + i + "]/name")).getTextTrim();
                PowerUnitSample vPowerUnitSample = new PowerUnitSample(Utils.getInt((String)vPowerUnitID), vPowerUnitName);
                vAquatronicaSample.getPowerUnitSample().put(vPowerUnitName, vPowerUnitSample);
                if (vDoc.selectSingleNode("/xmlResponse/Monitor/powerList/powerUnit[" + i + "]/plugList") == null) continue;
                int vCnt2 = Utils.getInt((String)vDoc.valueOf("count(/xmlResponse/Monitor/powerList/powerUnit[" + i + "]/plugList/plug)"));
                for (int j = 1; j <= vCnt2; ++j) {
                    String vPlugID = vDoc.valueOf("/xmlResponse/Monitor/powerList/powerUnit[" + i + "]/plugList/plug[" + j + "]/@id");
                    String vPlugName = ((Element)vDoc.selectSingleNode("/xmlResponse/Monitor/powerList/powerUnit[" + i + "]/plugList/plug[" + j + "]/name")).getTextTrim();
                    String vPlugStatus = ((Element)vDoc.selectSingleNode("/xmlResponse/Monitor/powerList/powerUnit[" + i + "]/plugList/plug[" + j + "]/status")).getTextTrim();
                    vPowerUnitSample.getPlugSample().put(Utils.getInt((String)vPlugID), new PlugSample(Utils.getInt((String)vPlugID), vPlugName, vNow, vPlugStatus));
                }
            }
        }
        return vAquatronicaSample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document submitAquatronicaCommand(String pURL) throws IOException, DocumentException {
        URL vUrl = new URL("http://" + this.mConfiguration.getIP() + ":" + this.mConfiguration.getPort() + "/" + pURL);
        URLConnection vConnection = vUrl.openConnection();
        vConnection.setConnectTimeout(60000);
        vConnection.setReadTimeout(60000);
        BufferedReader vIn = new BufferedReader(new InputStreamReader(vConnection.getInputStream(), "UTF-8"));
        StringBuffer vResponse = new StringBuffer();
        try {
            String vInputLine;
            while ((vInputLine = vIn.readLine()) != null) {
                vResponse.append(vInputLine);
            }
        }
        finally {
            vIn.close();
        }
        return DocumentHelper.parseText(vResponse.toString());
    }

    public SampleThread startSampling(StatusCallback pStatusCallback) {
        SampleThread vThread = new SampleThread(this.mConfiguration, pStatusCallback);
        vThread.start();
        return vThread;
    }

    public SampleThread startSampling() {
        return this.startSampling(null);
    }

    public List<String> getSensorNames(boolean pOnlyActive) {
        String vFilter = "";
        if (pOnlyActive) {
            vFilter = " where sd_archived = 'F' ";
        }
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select sd_sensor_name from sensor_definition " + vFilter + " order by sd_sensor_name", null, "Aquatronica");
        ArrayList<String> vSensorNames = new ArrayList<String>();
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            String vSensorName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_sensor_name"), (boolean)true);
            vSensorNames.add(vSensorName);
        }
        return vSensorNames;
    }

    public List<SensorData> getSensorData(String pSensorName, Date pFrom, Date pTo) {
        ArrayList<SensorData> vResults = new ArrayList<SensorData>();
        List vRes2 = DBHelper.getInstance().getDBLayer().queryDatabase("select sens_value,sens_status,sens_timestamp from sensor, sensor_definition where sens_sd_id = sd_id and sd_sensor_name = ? and sens_timestamp between ? and ? and sens_value not in ('-','?') order by sens_timestamp", new Object[]{pSensorName, pFrom, pTo}, "Aquatronica");
        for (int j = 0; j < vRes2.size(); ++j) {
            Map vRow2 = (Map)vRes2.get(j);
            String vSensorValue = MapUtils.getMapValueAsString((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sens_value"), (boolean)true);
            int vSensorStatus = MapUtils.getMapValueAsInteger((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sens_status"));
            Date vDate = MapUtils.getMapValueAsSQLTimestamp((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sens_timestamp"));
            vResults.add(new SensorData(vDate, this.stripUnits(vSensorValue), EventCodes.parseSensorStatus(vSensorStatus), vSensorStatus));
        }
        return vResults;
    }

    private String stripUnits(String pSensorValue) {
        String vSensorValue = pSensorValue;
        StringBuffer vFormatted = new StringBuffer();
        if (pSensorValue.length() > 0 && (pSensorValue.charAt(0) == '.' || pSensorValue.charAt(0) == '-' || Character.isDigit(pSensorValue.charAt(0)))) {
            for (int k = 0; k < pSensorValue.length(); ++k) {
                if (pSensorValue.charAt(k) != '.' && (pSensorValue.charAt(k) != '-' || k != 0) && !Character.isDigit(pSensorValue.charAt(k))) continue;
                vFormatted.append(pSensorValue.charAt(k));
            }
            vSensorValue = vFormatted.toString();
        }
        return vSensorValue;
    }

    public List<PlugData> getPlugData(PowerUnitPlug pSelectedPlug, Date pFrom, Date pTo) {
        ArrayList<PlugData> vPlugData = new ArrayList<PlugData>();
        List vRes2 = DBHelper.getInstance().getDBLayer().queryDatabase("select pl_status, pl_timestamp from powerunit, plug, powerunit_definition, plug_definition  where pu_id = pl_pu_id and pu_pud_id = pud_id and pl_pld_id = pld_id and pud_powerunit_name = ? and pld_plug_name = ? and pl_timestamp between ? and ? order by pl_timestamp", new Object[]{pSelectedPlug.getPowerUnitName(), pSelectedPlug.getPlugName(), pFrom, pTo}, "Aquatronica");
        for (int j = 0; j < vRes2.size(); ++j) {
            Map vRow2 = (Map)vRes2.get(j);
            int vPlugStatus = MapUtils.getMapValueAsInteger((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pl_status"));
            Date vDate = MapUtils.getMapValueAsSQLTimestamp((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pl_timestamp"));
            vPlugData.add(new PlugData(vDate, EventCodes.isPlugOn(vPlugStatus), EventCodes.parsePlugStatus(vPlugStatus)));
        }
        return vPlugData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportSensorData(String pSelectedSensor, Date pFrom, Date pTo) throws IOException {
        List<SensorData> vSensorData = this.getSensorData(pSelectedSensor, pFrom, pTo);
        if (vSensorData.size() <= 0) {
            return null;
        }
        File vTmpFile = File.createTempFile("export_sensor", ".csv");
        FileOutputStream vFOS = new FileOutputStream(vTmpFile);
        try {
            PrintWriter vPW = new PrintWriter(vFOS);
            try {
                for (SensorData vData : vSensorData) {
                    vPW.println(this.mSimpleDateFormat.format(vData.getTime()) + "," + vData.getValue() + "," + vData.getStatus());
                }
            }
            finally {
                vPW.close();
            }
        }
        finally {
            vFOS.close();
        }
        return vTmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportWaterParameterData(WaterParameterData pWaterParameterData, Date pFrom, Date pTo) throws IOException {
        List<WaterParameter> vWaterParameterData = this.getWaterParameterData(pWaterParameterData, pFrom, pTo);
        if (vWaterParameterData.size() <= 0) {
            return null;
        }
        File vTmpFile = File.createTempFile("export_waterparam", ".csv");
        FileOutputStream vFOS = new FileOutputStream(vTmpFile);
        try {
            PrintWriter vPW = new PrintWriter(vFOS);
            try {
                for (WaterParameter vData : vWaterParameterData) {
                    vPW.println(this.mSimpleDateFormat.format(vData.getTime()) + "," + vData.getValue() + "," + vData.getTank().getName());
                }
            }
            finally {
                vPW.close();
            }
        }
        finally {
            vFOS.close();
        }
        return vTmpFile;
    }

    public List<String> getPowerUnitNames(boolean pOnlyActive) {
        String vFilter = "";
        if (pOnlyActive) {
            vFilter = " where pud_archived = 'F' ";
        }
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select pud_powerunit_name from powerunit_definition " + vFilter + " order by pud_powerunit_name", null, "Aquatronica");
        ArrayList<String> vPowerUnitNames = new ArrayList<String>();
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            String vPowerUnitName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pud_powerunit_name"), (boolean)true);
            if (Utils.isEmptyString((String)vPowerUnitName)) continue;
            vPowerUnitNames.add(vPowerUnitName);
        }
        return vPowerUnitNames;
    }

    public List<String> getPlugNames(String pPowerUnitName) {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select pld_plug_name from plug_definition, powerunit_definition where pud_id = pld_pud_id and pud_powerunit_name = ?", new Object[]{pPowerUnitName}, "Aquatronica");
        ArrayList<String> vPlugNames = new ArrayList<String>();
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            String vPlugName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pld_plug_name"), (boolean)true);
            if (Utils.isEmptyString((String)vPlugName)) continue;
            vPlugNames.add(vPlugName);
        }
        return vPlugNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportPlugData(PowerUnitPlug pSelectedPlug, Date pFrom, Date pTo) throws IOException {
        List<PlugData> vPlugData = this.getPlugData(pSelectedPlug, pFrom, pTo);
        if (vPlugData.size() <= 0) {
            return null;
        }
        File vTmpFile = File.createTempFile("export_plug", ".csv");
        FileOutputStream vFOS = new FileOutputStream(vTmpFile);
        try {
            PrintWriter vPW = new PrintWriter(vFOS);
            try {
                for (PlugData vData : vPlugData) {
                    vPW.println(this.mSimpleDateFormat.format(vData.getTime()) + "," + (vData.isOn() ? "On" : "Off") + "," + vData.getStatus());
                }
            }
            finally {
                vPW.close();
            }
        }
        finally {
            vFOS.close();
        }
        return vTmpFile;
    }

    public void saveTankMaintenanceLog(TankLogEntry pTankLogEntry) {
        SQLStatement vSQLStatement = pTankLogEntry.isNew() ? DBHelper.getInstance().generateSQLStatementInsertTankMaintenanceLog("insert into tank_maintenance_log(tml_title, tml_details, tml_date, tml_tank_id,tml_plot) values (?,?,?,?,?)", new Object[]{pTankLogEntry.getSubject(), pTankLogEntry.getDescription(), pTankLogEntry.getTime(), pTankLogEntry.getTank().getID(), pTankLogEntry.isPlot() ? "T" : "F"}) : new SQLStatement("update tank_maintenance_log set tml_title = ?, tml_details = ?, tml_date = ?, tml_tank_id = ?, tml_plot = ? where tml_id = ?", new Object[]{pTankLogEntry.getSubject(), pTankLogEntry.getDescription(), pTankLogEntry.getTime(), pTankLogEntry.getTank().getID(), pTankLogEntry.isPlot() ? "T" : "F", pTankLogEntry.getID()}, false);
        TransactionResult vTR = DBHelper.getInstance().getDBLayer().submitTransaction(vSQLStatement, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        if (pTankLogEntry.isNew()) {
            pTankLogEntry.setID(vTR.getSerial());
        }
    }

    public List<TankLogEntry> getTankMaintenanceLogEntries() {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from tank_maintenance_log, tank where tml_tank_id = tank_id order by tml_date desc", null, "Aquatronica");
        return this.findTankMaintenanceLogEntries(vRes);
    }

    public List<TankLogEntry> getTankMaintenanceLogEntries(Date pFrom, Date pTo, String pSensorName) {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from tank_maintenance_log inner join tank on tml_tank_id = tank_id inner join tank_sensor on tank_id = ts_tank_id inner join sensor_definition on ts_sd_id = sd_id where sd_sensor_name = ? and tml_date between ? and ?", new Object[]{pSensorName, pFrom, pTo}, "Aquatronica");
        return this.findTankMaintenanceLogEntries(vRes);
    }

    public List<TankLogEntry> getTankMaintenanceLogEntries(Date pFrom, Date pTo, Tank pTank) {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from tank_maintenance_log inner join tank on tml_tank_id = tank_id where tank_id = ? and tml_date between ? and ?", new Object[]{pTank.getID(), pFrom, pTo}, "Aquatronica");
        return this.findTankMaintenanceLogEntries(vRes);
    }

    private List<TankLogEntry> findTankMaintenanceLogEntries(List pRes) {
        ArrayList<TankLogEntry> vEntries = new ArrayList<TankLogEntry>();
        for (int i = 0; i < pRes.size(); ++i) {
            Map vRow = (Map)pRes.get(i);
            int vID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tml_id"));
            String vSubject = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tml_title"), (boolean)true);
            String vDetails = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tml_details"), (boolean)true);
            Date vTime = MapUtils.getMapValueAsSQLTimestamp((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tml_date"));
            int vTankID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tml_tank_id"));
            String vTankName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tank_name"), (boolean)true);
            boolean vPlot = MapUtils.getMapValueAsBooleanFromTF((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tml_plot"), (Boolean)Boolean.TRUE);
            vEntries.add(new TankLogEntry(vID, vSubject, vDetails, vTime, new Tank(vTankID, vTankName), vPlot));
        }
        return vEntries;
    }

    public void deleteTankMaintenanceLog(int pID) {
        SQLStatement vSQLStatement = new SQLStatement("delete from tank_maintenance_log where tml_id = ?", new Object[]{pID}, false);
        DBHelper.getInstance().getDBLayer().submitTransaction(vSQLStatement, "Aquatronica");
    }

    public List<Tank> getTanks() {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from tank order by tank_name", null, "Aquatronica");
        ArrayList<Tank> vEntries = new ArrayList<Tank>();
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            int vID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tank_id"));
            String vName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tank_name"), (boolean)true);
            Tank vTank = new Tank(vID, vName);
            vTank.getAssociatedSensors().addAll(this.getTankSensors(vTank.getID()));
            vEntries.add(vTank);
        }
        return vEntries;
    }

    private List<String> getTankSensors(int pTankID) {
        List vRes2 = DBHelper.getInstance().getDBLayer().queryDatabase("select * from tank_sensor, sensor_definition where ts_sd_id = sd_id and ts_tank_id = ?", new Object[]{pTankID}, "Aquatronica");
        ArrayList<String> vSensors = new ArrayList<String>();
        for (int j = 0; j < vRes2.size(); ++j) {
            Map vRow2 = (Map)vRes2.get(j);
            String vSensorName = MapUtils.getMapValueAsString((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_sensor_name"), (boolean)true);
            vSensors.add(vSensorName);
        }
        return vSensors;
    }

    public void saveTank(Tank pEntry) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        if (pEntry.isNew()) {
            vBatch.addSQLStatement(DBHelper.getInstance().generateSQLStatementInsertTank("insert into tank(tank_name) values (?)", new Object[]{pEntry.getName()}));
        } else {
            vBatch.addSQLStatement(new SQLStatement("update tank set tank_name = ? where tank_id = ?", new Object[]{pEntry.getName(), pEntry.getID()}, false));
            vBatch.addSQLStatement(new SQLStatement("delete from tank_sensor where ts_tank_id = ?", new Object[]{pEntry.getID()}, false));
        }
        for (String vSensor : pEntry.getAssociatedSensors()) {
            vBatch.addSQLStatement(new SQLStatement("insert into tank_sensor(ts_tank_id, ts_sd_id) values (?,(select sd_id from sensor_definition where sd_sensor_name = ?))", new Object[]{pEntry.isNew() ? new SerialField("Tank") : Integer.valueOf(pEntry.getID()), vSensor}, false));
        }
        TransactionResult vTR = DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
        if (pEntry.isNew()) {
            pEntry.setID(vTR.getSerial());
        }
    }

    public void deleteTank(int pID) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        vBatch.addSQLStatement(new SQLStatement("delete from tank_sensor where ts_tank_id = ?", new Object[]{pID}, false));
        vBatch.addSQLStatement(new SQLStatement("delete from tank_plug where tp_tank_id = ?", new Object[]{pID}, false));
        vBatch.addSQLStatement(new SQLStatement("delete from tank where tank_id = ?", new Object[]{pID}, false));
        DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
    }

    public void setPlugStatus(int pPowerUnitID, int pPlugID, PlugData.OverridePlugState pPlugState, StatusCallback pStatusCallback) throws DocumentException, IOException {
        String vSID;
        pStatusCallback.updateStatusText("Authenticating...", false);
        try {
            vSID = this.login();
        }
        catch (RuntimeException e) {
            pStatusCallback.updateStatusText("Could not log in: " + e.getMessage(), true);
            throw e;
        }
        pStatusCallback.updateStatusText("Logged In, Updating Plug Status...", false);
        try {
            this.sample("K=" + vSID + "&U=" + pPowerUnitID + "&P=" + pPlugID + "&S=" + pPlugState.getCode());
            pStatusCallback.updateStatusText("Plug Status Updated", false);
        }
        catch (RuntimeException e) {
            pStatusCallback.updateStatusText("Failed Updating Plug Status", true);
            throw e;
        }
        finally {
            this.logout(vSID);
        }
    }

    private String login() throws DocumentException, IOException {
        String vPassword = new String(new Base64().encode(this.mConfiguration.getPassword().getBytes()));
        Document vDoc = this.submitAquatronicaCommand("login.xml?L=" + vPassword);
        return this.parseLogin(vDoc, true);
    }

    private String logout(String pSID) throws DocumentException, IOException {
        Document vDoc = this.submitAquatronicaCommand("logout.xml?K=" + pSID + "&X");
        return this.parseLogin(vDoc, false);
    }

    private String parseLogin(Document pDoc, boolean pLoginAttempt) {
        int vStatus = Utils.getInt((String)((Element)pDoc.selectSingleNode("/xmlResponse/login/status")).getTextTrim());
        String vSID = null;
        if (pDoc.selectSingleNode("/xmlResponse/login/sid") != null) {
            vSID = ((Element)pDoc.selectSingleNode("/xmlResponse/login/sid")).getTextTrim();
        }
        int vResult = Utils.getInt((String)((Element)pDoc.selectSingleNode("/xmlResponse/result")).getTextTrim());
        if (vStatus == 0 && pLoginAttempt) {
            throw new RuntimeException("Could not log user in");
        }
        if (vStatus == 1 || vStatus == 0) {
            switch (vResult) {
                case 0: {
                    if (Utils.isEmptyString((String)vSID) && pLoginAttempt) {
                        throw new RuntimeException("Logged user in but failed to retrieve session ID");
                    }
                    return vSID;
                }
                case 1: {
                    throw new RuntimeException("Syntax error");
                }
                case 2: {
                    throw new RuntimeException("Login Failed");
                }
                case 3: {
                    throw new RuntimeException("Login Denied - Password invalid?");
                }
                case 4: {
                    throw new RuntimeException("Multiple logins detected");
                }
                case 5: {
                    throw new DisconnectedFromEthernetModuleException("Ethernet module is DISCONNECTED from the Aquatronica Controller.  Is the Aquatronica PC Software running?");
                }
                case 255: {
                    throw new RuntimeException("Internal error");
                }
            }
            throw new RuntimeException("Unknown error");
        }
        return "";
    }

    public List<OverlayGraphPreset> getOverlayGraphPresets() {
        List vRes2 = DBHelper.getInstance().getDBLayer().queryDatabase("select * from overlay_graph_preset order by ogp_name", null, "Aquatronica");
        ArrayList<OverlayGraphPreset> vPresets = new ArrayList<OverlayGraphPreset>();
        for (int j = 0; j < vRes2.size(); ++j) {
            Map vRow;
            int i;
            Map vRow2 = (Map)vRes2.get(j);
            int vID = MapUtils.getMapValueAsInteger((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "ogp_id"));
            String vName = MapUtils.getMapValueAsString((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "ogp_name"), (boolean)true);
            OverlayGraphPreset vPreset = new OverlayGraphPreset(vID, vName);
            List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from overlay_graph_preset_sensor, sensor_definition where ogps_sd_id = sd_id and ogps_ogp_id = ?", new Object[]{vID}, "Aquatronica");
            for (i = 0; i < vRes.size(); ++i) {
                vRow = (Map)vRes.get(i);
                String vSensorName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_sensor_name"), (boolean)true);
                vPreset.getSensorNames().add(vSensorName);
            }
            vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from overlay_graph_preset_plug, plug_definition, powerunit_definition where ogpp_pld_id = pld_id and pld_pud_id = pud_id and ogpp_ogp_id = ?", new Object[]{vID}, "Aquatronica");
            for (i = 0; i < vRes.size(); ++i) {
                vRow = (Map)vRes.get(i);
                int vPowerUnitID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pud_unit_id"));
                int vPlugID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pld_plug_id"));
                vPreset.getPlugs().add(new Plug(vPowerUnitID, vPlugID));
            }
            vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from overlay_graph_preset_water_parameter inner join tank on ogpwp_tank_id = tank_id where ogpwp_ogp_id = ?", new Object[]{vID}, "Aquatronica");
            for (i = 0; i < vRes.size(); ++i) {
                vRow = (Map)vRes.get(i);
                String vType = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "ogpwp_water_parameter_type"), (boolean)true);
                int vTankID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tank_id"));
                String vTankName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tank_name"), (boolean)true);
                vPreset.getWaterParameters().add(new WaterParameterData(Configuration.WaterParameters.WaterParameterType.valueOf(vType), new Tank(vTankID, vTankName)));
            }
            vPresets.add(vPreset);
        }
        return vPresets;
    }

    public int getPowerUnitID(String pPowerUnitName) {
        return (Integer)DBHelper.getInstance().getDBLayer().queryDatabaseScalar("select pud_unit_id from powerunit_definition where pud_powerunit_name = ?", new Object[]{pPowerUnitName}, "Aquatronica");
    }

    public int getPlugID(int pPowerUnitID, String pPlugName) {
        return (Integer)DBHelper.getInstance().getDBLayer().queryDatabaseScalar("select pld_plug_id from plug_definition, powerunit_definition where pld_pud_id = pud_id and pud_unit_id = ? and pld_plug_name = ?", new Object[]{pPowerUnitID, pPlugName}, "Aquatronica");
    }

    public void saveOverlayGraphPreset(OverlayGraphPreset pPreset) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        if (pPreset.isNew()) {
            vBatch.addSQLStatement(DBHelper.getInstance().generateSQLStatementInsertOverlayGraphPreset("insert into overlay_graph_preset(ogp_name) values (?)", new Object[]{pPreset.getName()}));
        } else {
            vBatch.addSQLStatement(new SQLStatement("update overlay_graph_preset set ogp_name = ? where ogp_id = ?", new Object[]{pPreset.getName(), pPreset.getID()}, false));
            vBatch.addSQLStatement(new SQLStatement("delete from overlay_graph_preset_sensor where ogps_ogp_id = ?", new Object[]{pPreset.getID()}, false));
            vBatch.addSQLStatement(new SQLStatement("delete from overlay_graph_preset_plug where ogpp_ogp_id = ?", new Object[]{pPreset.getID()}, false));
            vBatch.addSQLStatement(new SQLStatement("delete from overlay_graph_preset_water_parameter where ogpwp_ogp_id = ?", new Object[]{pPreset.getID()}, false));
        }
        for (String vSensor : pPreset.getSensorNames()) {
            vBatch.addSQLStatement(new SQLStatement("insert into overlay_graph_preset_sensor(ogps_ogp_id, ogps_sd_id) values (?,(select sd_id from sensor_definition where sd_sensor_name = ?))", new Object[]{pPreset.isNew() ? new SerialField("OverlayGraphPreset") : Integer.valueOf(pPreset.getID()), vSensor}, false));
        }
        for (Plug vPlug : pPreset.getPlugs()) {
            vBatch.addSQLStatement(new SQLStatement("insert into overlay_graph_preset_plug(ogpp_ogp_id, ogpp_pld_id) values (?,(select pld_id from plug_definition, powerunit_definition where pld_pud_id = pud_id and pud_unit_id = ? and pld_plug_id = ?))", new Object[]{pPreset.isNew() ? new SerialField("OverlayGraphPreset") : Integer.valueOf(pPreset.getID()), vPlug.getPowerUnitID(), vPlug.getPlugID()}, false));
        }
        for (WaterParameterData vParam : pPreset.getWaterParameters()) {
            vBatch.addSQLStatement(new SQLStatement("insert into overlay_graph_preset_water_parameter(ogpwp_ogp_id, ogpwp_water_parameter_type, ogpwp_tank_id) values (?,?,?)", new Object[]{pPreset.isNew() ? new SerialField("OverlayGraphPreset") : Integer.valueOf(pPreset.getID()), vParam.getWaterParameterType().toString(), vParam.getTank().getID()}, false));
        }
        TransactionResult vTR = DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
        if (pPreset.isNew()) {
            pPreset.setID(vTR.getSerial());
        }
    }

    public void deleteOverlayGraphPreset(int pID) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        vBatch.addSQLStatement(new SQLStatement("delete from overlay_graph_preset_water_parameter where ogpwp_ogp_id = ?", new Object[]{pID}, false));
        vBatch.addSQLStatement(new SQLStatement("delete from overlay_graph_preset_plug where ogpp_ogp_id = ?", new Object[]{pID}, false));
        vBatch.addSQLStatement(new SQLStatement("delete from overlay_graph_preset_sensor where ogps_ogp_id = ?", new Object[]{pID}, false));
        vBatch.addSQLStatement(new SQLStatement("delete from overlay_graph_preset where ogp_id = ?", new Object[]{pID}, false));
        DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
    }

    public String getPowerUnitName(int pPowerUnitID) {
        return (String)DBHelper.getInstance().getDBLayer().queryDatabaseScalar("select pud_powerunit_name from powerunit_definition where pud_unit_id = ?", new Object[]{pPowerUnitID}, "Aquatronica");
    }

    public String getPlugName(int pPowerUnitID, int pPlugID) {
        return (String)DBHelper.getInstance().getDBLayer().queryDatabaseScalar("select pld_plug_name from plug_definition, powerunit_definition where pld_pud_id = pud_id and pud_unit_id = ? and pld_plug_id = ?", new Object[]{pPowerUnitID, pPlugID}, "Aquatronica");
    }

    public void saveWaterParameters(List<WaterParameter> pParams) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        int i = 0;
        for (WaterParameter vParam : pParams) {
            vBatch.addSQLStatement(DBHelper.getInstance().generateSQLStatementInsertWaterParameter("insert into water_parameter (wp_type,wp_value,wp_timestamp,wp_tank_id) values (?,?,?,?)", new Object[]{vParam.getName(), vParam.getValue(), vParam.getTime(), vParam.getTank().getID()}, i++));
        }
        TransactionResult vTR = DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
        i = 0;
        for (Integer vSerial : vTR.getSerials()) {
            pParams.get(i++).setID(vSerial);
        }
    }

    public List<WaterParameter> getWaterParameterData(WaterParameterData pWaterParameterData, Date pFrom, Date pTo) {
        ArrayList<WaterParameter> vParams = new ArrayList<WaterParameter>();
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from water_parameter inner join tank on wp_tank_id = tank_id where wp_timestamp between ? and ? and wp_tank_id = ? and wp_type = ? order by wp_timestamp", new Object[]{pFrom, pTo, pWaterParameterData.getTank().getID(), pWaterParameterData.getWaterParameterType().toString()}, "Aquatronica");
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            vParams.add(this.populateWaterParameter(vRow));
        }
        return vParams;
    }

    private WaterParameter populateWaterParameter(Map pRow) {
        int vID = MapUtils.getMapValueAsInteger((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "wp_id"));
        String vType = MapUtils.getMapValueAsString((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "wp_type"), (boolean)true);
        Double vValue = MapUtils.getMapValueAsDouble((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "wp_value"));
        int vTankID = MapUtils.getMapValueAsInteger((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tank_id"));
        String vTankName = MapUtils.getMapValueAsString((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "tank_name"), (boolean)true);
        Date vTime = MapUtils.getMapValueAsSQLTimestamp((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "wp_timestamp"));
        return new WaterParameter(vID, vTime, vType, vValue, new Tank(vTankID, vTankName));
    }

    public Map<Date, List<WaterParameter>> getWaterParameters() {
        LinkedHashMap<Date, List<WaterParameter>> vResult = new LinkedHashMap<Date, List<WaterParameter>>();
        List vRes2 = DBHelper.getInstance().getDBLayer().queryDatabase("select distinct wp_timestamp, wp_tank_id from water_parameter order by wp_timestamp desc", null, "Aquatronica");
        for (int j = 0; j < vRes2.size(); ++j) {
            Map vRow2 = (Map)vRes2.get(j);
            Date vTime = MapUtils.getMapValueAsSQLTimestamp((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "wp_timestamp"));
            int vUniqueTankID = MapUtils.getMapValueAsInteger((Map)vRow2, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "wp_tank_id"));
            ArrayList<WaterParameter> vParams = new ArrayList<WaterParameter>();
            List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from water_parameter inner join tank on wp_tank_id = tank_id where wp_timestamp = ? and wp_tank_id = ?", new Object[]{vTime, vUniqueTankID}, "Aquatronica");
            for (int i = 0; i < vRes.size(); ++i) {
                Map vRow = (Map)vRes.get(i);
                vParams.add(this.populateWaterParameter(vRow));
            }
            vResult.put(vTime, vParams);
        }
        return vResult;
    }

    public List<String> getWaterParameterTypes() {
        ArrayList<String> vResult = new ArrayList<String>();
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select distinct wp_type from water_parameter order by wp_type", null, "Aquatronica");
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            String vType = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "wp_type"), (boolean)true);
            vResult.add(vType);
        }
        return vResult;
    }

    public void deleteWaterParameters(List<WaterParameter> pWaterParameters) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        boolean i = false;
        for (WaterParameter vParam : pWaterParameters) {
            vBatch.addSQLStatement(new SQLStatement("delete from water_parameter where wp_id = ?", new Object[]{vParam.getID()}, false));
        }
        DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
    }

    public List<SensorDefinition> getSensorDefinitions(boolean pOnlyActive) {
        String vFilter = "";
        if (pOnlyActive) {
            vFilter = " where sd_archived = 'F' ";
        }
        ArrayList<SensorDefinition> vResult = new ArrayList<SensorDefinition>();
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from sensor_definition " + vFilter + " order by sd_sensor_name", null, "Aquatronica");
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            int vID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_id"));
            String vName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_sensor_name"), (boolean)true);
            boolean vDiscrete = MapUtils.getMapValueAsBooleanFromTF((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_discrete"), (Boolean)Boolean.FALSE);
            boolean vNotifyOnAlert = MapUtils.getMapValueAsBooleanFromTF((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_ntfy_on_alert"), (Boolean)Boolean.FALSE);
            vResult.add(new SensorDefinition(vID, vName, vDiscrete, vNotifyOnAlert));
        }
        return vResult;
    }

    public void saveNotificationDetails(NotificationDetails pNotificationDetails) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        vBatch.addSQLStatement(new SQLStatement("delete from notification", null, false));
        vBatch.addSQLStatement(new SQLStatement("insert into notification (not_alarm_enabled, not_receiver_address, not_new_alert_tmpl_subj,not_new_alert_tmpl_body, not_cleared_alert_tmpl_subj, not_cleared_alert_tmpl_body,not_summary_upd_subj,not_summary_upd_enabled,not_summary_upd_freq,not_summary_upd_time, not_dead_time_alarm, not_alarm_disconnect_enabled,not_aquastats_disconnect_enabled,not_aquastats_disconnect_delay_alarm) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{pNotificationDetails.isAlertEnabled() ? "T" : "F", pNotificationDetails.getReceiverEmailAddressesAsCSV(), pNotificationDetails.getNewAlertTemplateSubject(), pNotificationDetails.getNewAlertTemplateBody(), pNotificationDetails.getClearedAlertTemplateSubject(), pNotificationDetails.getClearedAlertTemplateBody(), pNotificationDetails.getSummaryUpdateNotificationSubject(), pNotificationDetails.isSummaryEnabled() ? "T" : "F", pNotificationDetails.getSummaryUpdateFrequency().toString(), pNotificationDetails.getSummaryOfUpdateTime(), pNotificationDetails.getDeadTimeAlertNotification(), pNotificationDetails.isAlertOnMissingDevicesEnabled() ? "T" : "F", pNotificationDetails.isAlertOnAquaStatsDisconnected() ? "T" : "F", pNotificationDetails.getAlertOnAquaStatsDisconnectedDelay()}, false));
        for (SensorDefinition vSensorDefinition : pNotificationDetails.getSensorDefinitions()) {
            vBatch.addSQLStatement(new SQLStatement("update sensor_definition set sd_ntfy_on_alert = ? where sd_id = ?", new Object[]{vSensorDefinition.isNotifyOnAlert() ? "T" : "F", vSensorDefinition.getID()}, false));
        }
        DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
    }

    public NotificationDetails getNotificationDetails() {
        List<SensorDefinition> vSensorDefinitions = this.getSensorDefinitions(true);
        ArrayList<String> vReceiverEmailAddresses = new ArrayList<String>();
        boolean vAlertEnabled = false;
        boolean vAlarmOnMissingDevicesEnabled = false;
        boolean vAlarmOnAquaStatsDisconnected = false;
        String vNewAlertTemplateSubject = "A new alarm was raised for your aquarium";
        String vNewAlertTemplateBody = "The following sensor is currently in alarm: ";
        String vClearedAlertTemplateSubject = "The alarm previously raised for your aquarium has been cleared";
        String vClearedAlertTemplateBody = "The following sensor is NOT in alarm anymore: ";
        String vSummaryUpdateNotificationSubject = "Summary of all aquatronica peripherals";
        boolean vSummaryEnabled = false;
        NotificationDetails.SummaryUpdateFrequency vSummaryUpdateFrequency = NotificationDetails.SummaryUpdateFrequency.Daily;
        Date vSummaryUpdateTime = null;
        Integer vDeadTimeAlertNotification = null;
        Integer vAlertOnAquaStatsDisconnectDelay = null;
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from notification", null, "Aquatronica");
        if (vRes.size() > 0) {
            Map vRow = (Map)vRes.get(0);
            vAlertEnabled = MapUtils.getMapValueAsBooleanFromTF((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_alarm_enabled"), (Boolean)Boolean.FALSE);
            vAlarmOnMissingDevicesEnabled = MapUtils.getMapValueAsBooleanFromTF((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_alarm_disconnect_enabled"), (Boolean)Boolean.FALSE);
            vAlarmOnAquaStatsDisconnected = MapUtils.getMapValueAsBooleanFromTF((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_aquastats_disconnect_enabled"), (Boolean)Boolean.FALSE);
            String vEmailAddresses = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_receiver_address"), (boolean)true);
            String[] vAddresses = vEmailAddresses.split(",");
            for (int i = 0; i < vAddresses.length; ++i) {
                String vAddress = vAddresses[i];
                if (Utils.isEmptyString((String)vAddress)) continue;
                vReceiverEmailAddresses.add(Utils.makeProperString((String)vAddress));
            }
            vNewAlertTemplateSubject = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_new_alert_tmpl_subj"), (boolean)true);
            vNewAlertTemplateBody = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_new_alert_tmpl_body"), (boolean)true);
            vClearedAlertTemplateSubject = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_cleared_alert_tmpl_subj"), (boolean)true);
            vClearedAlertTemplateBody = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_cleared_alert_tmpl_body"), (boolean)true);
            vSummaryUpdateNotificationSubject = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_summary_upd_subj"), (boolean)true);
            vSummaryEnabled = MapUtils.getMapValueAsBooleanFromTF((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_summary_upd_enabled"), (Boolean)Boolean.FALSE);
            vDeadTimeAlertNotification = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_dead_time_alarm"));
            vAlertOnAquaStatsDisconnectDelay = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_aquastats_disconnect_delay_alarm"));
            String vSummaryUpdateFrequencyRaw = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_summary_upd_freq"), (boolean)true);
            if (!Utils.isEmptyString((String)vSummaryUpdateFrequencyRaw)) {
                vSummaryUpdateFrequency = NotificationDetails.SummaryUpdateFrequency.valueOf(vSummaryUpdateFrequencyRaw);
            }
            vSummaryUpdateTime = MapUtils.getMapValueAsSQLTime((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "not_summary_upd_time"));
        }
        return new NotificationDetails(vSensorDefinitions, vReceiverEmailAddresses, vAlertEnabled, vNewAlertTemplateSubject, vNewAlertTemplateBody, vClearedAlertTemplateSubject, vClearedAlertTemplateBody, vSummaryUpdateNotificationSubject, vSummaryEnabled, vSummaryUpdateFrequency, vSummaryUpdateTime, vDeadTimeAlertNotification, vAlarmOnMissingDevicesEnabled, vAlarmOnAquaStatsDisconnected, vAlertOnAquaStatsDisconnectDelay);
    }

    public void sendTestEmail(NotificationDetails pNotificationDetails) {
        this.sendEmail(pNotificationDetails, "Test email from AquaStats", "This is a test email from AquaStats to verify your configuration is working");
    }

    public void sendEmail(NotificationDetails pNotificationDetails, String pSubject, String pBody) {
        SMTPMail vMail = new SMTPMail();
        if (!this.mConfiguration.isSMTPAuthEnabled()) {
            vMail.setMailSettings(this.mConfiguration.getSMTPIP(), this.mConfiguration.getSMTPPort());
        } else {
            vMail.setMailSettings(this.mConfiguration.getSMTPIP(), this.mConfiguration.getSMTPPort(), this.mConfiguration.getSMTPAuthUsername(), this.mConfiguration.getSMTPAuthPassword(), false);
        }
        vMail.setMailData(this.mConfiguration.getMailFromAddress(), pNotificationDetails.getReceiverEmailAddresses().toArray(new String[0]), null, null, pSubject, pBody);
        vMail.sendEMail();
    }

    public String createReport(AquatronicaSample pSample) {
        StringBuffer vReport = new StringBuffer();
        vReport.append("Sensor Data:\n");
        vReport.append("============\n");
        for (String vSensorName : pSample.getSensorData().keySet()) {
            SensorData vSensorData = pSample.getSensorData().get(vSensorName);
            vReport.append(vSensorName + " " + vSensorData.getValue() + " - " + vSensorData.getStatus() + "\n");
        }
        vReport.append("\n");
        vReport.append("Plug Data:\n");
        vReport.append("==========\n");
        for (String vPowerUnitName : pSample.getPowerUnitSample().keySet()) {
            vReport.append(vPowerUnitName + "\n");
            PowerUnitSample vPowerUnitSample = pSample.getPowerUnitSample().get(vPowerUnitName);
            for (Integer vPlugID : vPowerUnitSample.getPlugSample().keySet()) {
                PlugSample vPlugSample = vPowerUnitSample.getPlugSample().get(vPlugID);
                String vPlugStatus = EventCodes.parsePlugStatus(Utils.getInt((String)vPlugSample.getStatus()));
                vReport.append("   " + (Utils.isEmptyString((String)vPlugSample.getName()) ? "<Not Named>" : vPlugSample.getName()) + ", " + "State: " + (EventCodes.isPlugOn(Utils.getInt((String)vPlugSample.getStatus())) ? "On" : "Off") + ", " + (Utils.isEmptyString((String)vPlugStatus) ? "" : "Program: " + vPlugStatus + ", ") + "Plug Override: " + (Object)((Object)EventCodes.getPlugOverride(Utils.getInt((String)vPlugSample.getStatus()))) + "\n");
            }
        }
        vReport.append("End of report.\n");
        return vReport.toString();
    }

    public double calculateTotalOnTime(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        return this.calculateTotalTime(pPowerUnitPlug, pFrom, pTo, true);
    }

    public double calculateTotalOffTime(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        return this.calculateTotalTime(pPowerUnitPlug, pFrom, pTo, false);
    }

    private double calculateTotalTime(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo, boolean pOn) {
        double vTotalTime = 0.0;
        List<PlugData> vPlugData = this.getPlugData(pPowerUnitPlug, pFrom, pTo);
        Date vStart = pFrom;
        Boolean vLastState = null;
        for (PlugData vData : vPlugData) {
            if ((vLastState == null || vLastState.booleanValue()) && (pOn ? vData.isOn() : !vData.isOn())) {
                vTotalTime += (double)((float)(vData.getTime().getTime() - vStart.getTime()) / 1000.0f / 60.0f);
            } else if (vLastState != null && vLastState != (pOn ? vData.isOn() : !vData.isOn())) {
                vTotalTime += (double)((float)(vData.getTime().getTime() - (vData.getTime().getTime() + vStart.getTime()) / 2L) / 1000.0f / 60.0f);
            }
            vLastState = pOn ? vData.isOn() : !vData.isOn();
            vStart = vData.getTime();
        }
        return vTotalTime;
    }

    public double calculateAverageOnTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        return this.calculateAverageTimePerDay(pPowerUnitPlug, pFrom, pTo, true);
    }

    public double calculateAverageOffTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        return this.calculateAverageTimePerDay(pPowerUnitPlug, pFrom, pTo, false);
    }

    private double calculateAverageTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo, boolean pOn) {
        if (DateUtils.getHoursDifference((Date)pFrom, (Date)pTo) < 24L) {
            return 0.0;
        }
        long vTotalHours = DateUtils.getHoursDifference((Date)pFrom, (Date)pTo);
        double vTotalTime = this.calculateTotalTime(pPowerUnitPlug, pFrom, pTo, pOn);
        return vTotalTime / (double)vTotalHours * 24.0;
    }

    public ResultOnDate calculateMaximumOnTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        return this.calculateMaximumTimePerDay(pPowerUnitPlug, pFrom, pTo, true);
    }

    public ResultOnDate calculateMaximumOffTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        return this.calculateMaximumTimePerDay(pPowerUnitPlug, pFrom, pTo, false);
    }

    private ResultOnDate calculateMaximumTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo, boolean pOn) {
        if (DateUtils.getHoursDifference((Date)pFrom, (Date)pTo) < 24L) {
            return new ResultOnDate(0.0, pTo);
        }
        Calendar vStart = Calendar.getInstance();
        vStart.setTime(DateUtils.makeStartOfDay((Date)pFrom));
        double vMaximumTime = 0.0;
        Date vDay = null;
        while (vStart.getTime().before(pTo)) {
            double vTotalTime = this.calculateTotalTime(pPowerUnitPlug, vStart.getTime(), DateUtils.makeEndOfDay((Date)vStart.getTime()), pOn);
            if (vTotalTime > vMaximumTime) {
                vMaximumTime = vTotalTime;
                vDay = vStart.getTime();
            }
            vStart.add(6, 1);
        }
        return new ResultOnDate(vMaximumTime, vDay);
    }

    public ResultOnDate calculateMinimumOnTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        return this.calculateMinimumTimePerDay(pPowerUnitPlug, pFrom, pTo, true);
    }

    public ResultOnDate calculateMinimumOffTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        return this.calculateMinimumTimePerDay(pPowerUnitPlug, pFrom, pTo, false);
    }

    private ResultOnDate calculateMinimumTimePerDay(PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo, boolean pOn) {
        if (DateUtils.getHoursDifference((Date)pFrom, (Date)pTo) < 24L) {
            return new ResultOnDate(0.0, pTo);
        }
        Calendar vStart = Calendar.getInstance();
        vStart.setTime(DateUtils.makeStartOfDay((Date)pFrom));
        double vMinimumTime = Double.MAX_VALUE;
        Date vDay = null;
        while (vStart.getTime().before(pTo)) {
            double vTotalTime = this.calculateTotalTime(pPowerUnitPlug, vStart.getTime(), DateUtils.makeEndOfDay((Date)vStart.getTime()), pOn);
            if (vTotalTime < vMinimumTime) {
                vMinimumTime = vTotalTime;
                vDay = vStart.getTime();
            }
            vStart.add(6, 1);
        }
        return new ResultOnDate(vMinimumTime, vDay);
    }

    public double calculateMeanSensorValue(String pSelectedSensor, Date pFrom, Date pTo) {
        List<SensorData> vSensorData = this.getSensorData(pSelectedSensor, pFrom, pTo);
        double vTotal = 0.0;
        for (SensorData vData : vSensorData) {
            vTotal += Double.parseDouble(vData.getValue());
        }
        return vTotal / (double)vSensorData.size();
    }

    public ResultOnDate calculateMaximumSensorValue(String pSelectedSensor, Date pFrom, Date pTo) {
        List<SensorData> vSensorData = this.getSensorData(pSelectedSensor, pFrom, pTo);
        double vMaximum = 0.0;
        Date vDate = pTo;
        for (SensorData vData : vSensorData) {
            if (!(Double.parseDouble(vData.getValue()) >= vMaximum)) continue;
            vMaximum = Double.parseDouble(vData.getValue());
            vDate = vData.getTime();
        }
        return new ResultOnDate(vMaximum, vDate);
    }

    public ResultOnDate calculateMinimumSensorValue(String pSelectedSensor, Date pFrom, Date pTo) {
        List<SensorData> vSensorData = this.getSensorData(pSelectedSensor, pFrom, pTo);
        double vMinimum = Double.MAX_VALUE;
        Date vDate = pTo;
        for (SensorData vData : vSensorData) {
            if (!(Double.parseDouble(vData.getValue()) <= vMinimum)) continue;
            vMinimum = Double.parseDouble(vData.getValue());
            vDate = vData.getTime();
        }
        return new ResultOnDate(vMinimum, vDate);
    }

    public double calculateVarianceSensorValue(String pSelectedSensor, Date pFrom, Date pTo) {
        double vMean = this.calculateMeanSensorValue(pSelectedSensor, pFrom, pTo);
        double vVariance = 0.0;
        List<SensorData> vSensorData = this.getSensorData(pSelectedSensor, pFrom, pTo);
        for (SensorData vData : vSensorData) {
            vVariance += Math.pow(Double.parseDouble(vData.getValue()) - vMean, 2.0);
        }
        return vVariance / (double)vSensorData.size();
    }

    public double calculateStandardDeviationSensorValue(String pSelectedSensor, Date pFrom, Date pTo) {
        double vVariance = this.calculateVarianceSensorValue(pSelectedSensor, pFrom, pTo);
        if (vVariance <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(vVariance);
    }

    public double calculateInterquartileMeanSensorValue(String pSelectedSensor, Date pFrom, Date pTo) {
        List<SensorData> vSensorData = this.getSensorData(pSelectedSensor, pFrom, pTo);
        Object[] vArray = vSensorData.toArray();
        Arrays.sort(vArray);
        double vTotal = 0.0;
        boolean vWA = vArray.length % 4 != 0;
        double vFactor = 1.0f - (float)(vArray.length % 4) / 4.0f;
        int vLowerLimit = vArray.length / 4 + 1 - 1;
        int vUpperLimit = vWA ? vArray.length - vLowerLimit - 1 : 3 * vArray.length / 4 - 1;
        for (int i = vLowerLimit; i <= vUpperLimit; ++i) {
            if (vWA && (i == vLowerLimit || i == vUpperLimit)) {
                vTotal += vFactor * Double.parseDouble(((SensorData)vArray[i]).getValue());
                continue;
            }
            vTotal += Double.parseDouble(((SensorData)vArray[i]).getValue());
        }
        return (double)(2.0f / (float)vArray.length) * vTotal;
    }

    public List<RawPowerunit> getPowerUnitsFromDB() {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from powerunit_definition order by pud_id", null, "Aquatronica");
        ArrayList<RawPowerunit> vPowerUnits = new ArrayList<RawPowerunit>();
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            int vID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pud_id"));
            int vPowerUnitID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pud_unit_id"));
            String vPowerUnitName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pud_powerunit_name"), (boolean)true);
            boolean vArchived = MapUtils.getMapValueAsBooleanFromTF((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pud_archived"), (Boolean)Boolean.FALSE);
            vPowerUnits.add(new RawPowerunit(vID, vPowerUnitID, vPowerUnitName, vArchived));
        }
        return vPowerUnits;
    }

    public List<RawPowerunit> getPowerUnitsFromAquatronica(AquatronicaSample pSample) {
        ArrayList<RawPowerunit> vPowerUnits = new ArrayList<RawPowerunit>();
        for (String vPowerunitName : pSample.getPowerUnitSample().keySet()) {
            PowerUnitSample vSample = pSample.getPowerUnitSample().get(vPowerunitName);
            vPowerUnits.add(new RawPowerunit(vSample.getPowerUnitID(), vPowerunitName, false));
        }
        return vPowerUnits;
    }

    public List<RawPowerunit> getKnownPowerUnits(List<RawPowerunit> pPowerUnitsFromDB, List<RawPowerunit> pRealtimePowerUnits) {
        return ListUtils.difference((List)ListUtils.intersection(pPowerUnitsFromDB, pRealtimePowerUnits), this.getArchivedPowerUnits(pPowerUnitsFromDB, pRealtimePowerUnits));
    }

    public List<RawPowerunit> getArchivedPowerUnits(List<RawPowerunit> pPowerUnitsFromDB, List<RawPowerunit> pRealtimePowerUnits) {
        ArrayList<RawPowerunit> vList = new ArrayList<RawPowerunit>();
        for (RawPowerunit vRawPowerunit : pPowerUnitsFromDB) {
            if (!vRawPowerunit.isArchived()) continue;
            vList.add(vRawPowerunit);
        }
        return vList;
    }

    public List<RawPowerunit> getNewPowerUnits(List<RawPowerunit> pPowerUnitsFromDB, List<RawPowerunit> pRealtimePowerUnits) {
        return ListUtils.difference(pRealtimePowerUnits, pPowerUnitsFromDB);
    }

    public List<RawPowerunit> getMissingPowerUnits(List<RawPowerunit> pPowerUnitsFromDB, List<RawPowerunit> pRealtimePowerUnits) {
        return ListUtils.difference((List)ListUtils.difference(pPowerUnitsFromDB, pRealtimePowerUnits), this.getArchivedPowerUnits(pPowerUnitsFromDB, pRealtimePowerUnits));
    }

    public void savePowerunitDefinition(List<RawPowerunit> pPowerunitsToUpdate, List<RawPowerunit> pPowerunitsToAdd, List<RawPowerunit> pPowerunitsToDelete, List<RawPowerunit> pPowerunitsToArchive) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        for (RawPowerunit vPowerunit : pPowerunitsToDelete) {
            vBatch.addSQLStatement(new SQLStatement("delete from powerunit_definition where pud_id = ?", new Object[]{vPowerunit.getID()}, false));
        }
        int i = 0;
        for (RawPowerunit vPowerunit : pPowerunitsToAdd) {
            vBatch.addSQLStatement(DBHelper.getInstance().generateSQLStatementInsertPowerunitDefinition("insert into powerunit_definition (pud_unit_id, pud_powerunit_name, pud_archived) values (?,?,'F')", new Object[]{vPowerunit.getPowerunitID(), vPowerunit.getName()}, i));
            for (RawPlug vRawPlug : vPowerunit.getPlugs()) {
                vBatch.addSQLStatement(new SQLStatement("insert into plug_definition (pld_plug_name, pld_plug_id, pld_pud_id) values (?,?,?)", new Object[]{vRawPlug.getName(), vRawPlug.getPlugID(), new SerialField("PowerunitDefinition" + i)}, false));
            }
            ++i;
        }
        for (RawPowerunit vPowerunit : pPowerunitsToUpdate) {
            vBatch.addSQLStatement(new SQLStatement("update powerunit_definition set pud_powerunit_name = ? where pud_id = ?", new Object[]{vPowerunit.getName(), vPowerunit.getID()}, false));
        }
        for (RawPowerunit vPowerunit : pPowerunitsToArchive) {
            vBatch.addSQLStatement(new SQLStatement("update powerunit_definition set pud_archived = 'T' where pud_id = ?", new Object[]{vPowerunit.getID()}, false));
        }
        DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
    }

    public List<RawPlug> getPlugsFromDB(int pRawPowerunitID) {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from plug_definition where pld_pud_id = ? order by pld_id", new Object[]{pRawPowerunitID}, "Aquatronica");
        ArrayList<RawPlug> vPlugs = new ArrayList<RawPlug>();
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            int vID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pld_id"));
            int vRawPowerUnitID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pld_pud_id"));
            int vPlugID = MapUtils.getMapValueAsInteger((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pld_plug_id"));
            String vPlugName = MapUtils.getMapValueAsString((Map)vRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "pld_plug_name"), (boolean)true);
            vPlugs.add(new RawPlug(vID, vPlugID, vRawPowerUnitID, vPlugName));
        }
        return vPlugs;
    }

    public List<RawPlug> getPlugsFromAquatronica(int pPowerunitID, AquatronicaSample pSample) {
        ArrayList<RawPlug> vPlugs = new ArrayList<RawPlug>();
        for (String vPowerunitName : pSample.getPowerUnitSample().keySet()) {
            PowerUnitSample vSample = pSample.getPowerUnitSample().get(vPowerunitName);
            if (vSample.getPowerUnitID() != pPowerunitID) continue;
            for (Integer vPlugID : vSample.getPlugSample().keySet()) {
                vPlugs.add(new RawPlug(vPlugID, -1, vSample.getPlugSampleByPlugID(vPlugID).getName()));
            }
        }
        return vPlugs;
    }

    public void savePlugDefinition(List<RawPlug> pPlugsToUpdate) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        for (RawPlug vPlug : pPlugsToUpdate) {
            vBatch.addSQLStatement(new SQLStatement("update plug_definition set pld_plug_name = ? where pld_id = ?", new Object[]{vPlug.getName(), vPlug.getID()}, false));
        }
        DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
    }

    public List<RawSensor> getSensorsFromDB() {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from sensor_definition order by sd_id", null, "Aquatronica");
        ArrayList<RawSensor> vSensors = new ArrayList<RawSensor>();
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            vSensors.add(this.populateRawSensor(vRow));
        }
        return vSensors;
    }

    private RawSensor populateRawSensor(Map pRow) {
        int vID = MapUtils.getMapValueAsInteger((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_id"));
        String vName = MapUtils.getMapValueAsString((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_sensor_name"), (boolean)true);
        boolean vDiscrete = MapUtils.getMapValueAsBooleanFromTF((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_discrete"), (Boolean)Boolean.FALSE);
        boolean vNotifyOnAlert = MapUtils.getMapValueAsBooleanFromTF((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_ntfy_on_alert"), (Boolean)Boolean.FALSE);
        boolean vArchived = MapUtils.getMapValueAsBooleanFromTF((Map)pRow, (String)DBCase.parse(this.mConfiguration.isEmbedded(), "sd_archived"), (Boolean)Boolean.FALSE);
        return new RawSensor(vID, vName, vDiscrete, vNotifyOnAlert, vArchived);
    }

    public RawSensor getRawSensor(String pSensorName) throws NoMatchFoundException {
        List vRes = DBHelper.getInstance().getDBLayer().queryDatabase("select * from sensor_definition where sd_sensor_name = ?", new Object[]{pSensorName}, "Aquatronica");
        if (vRes.size() <= 0) {
            throw new NoMatchFoundException("Could not locate sensor " + pSensorName);
        }
        return this.populateRawSensor((Map)vRes.get(0));
    }

    public List<RawSensor> getSensorsFromAquatronica(AquatronicaSample pSample) {
        ArrayList<RawSensor> vSensors = new ArrayList<RawSensor>();
        for (String vSensorName : pSample.getSensorData().keySet()) {
            vSensors.add(new RawSensor(vSensorName));
        }
        return vSensors;
    }

    public List<RawSensor> getKnownSensors(List<RawSensor> pSensorsFromDB, List<RawSensor> pRealtimeSensors) {
        return ListUtils.difference((List)ListUtils.intersection(pSensorsFromDB, pRealtimeSensors), this.getArchivedSensors(pSensorsFromDB, pRealtimeSensors));
    }

    public List<RawSensor> getArchivedSensors(List<RawSensor> pSensorsFromDB, List<RawSensor> pRealtimeSensors) {
        ArrayList<RawSensor> vList = new ArrayList<RawSensor>();
        for (RawSensor vRawSensor : pSensorsFromDB) {
            if (!vRawSensor.isArchived()) continue;
            vList.add(vRawSensor);
        }
        return vList;
    }

    public List<RawSensor> getNewSensors(List<RawSensor> pSensorsFromDB, List<RawSensor> pRealtimeSensors) {
        return ListUtils.difference(pRealtimeSensors, pSensorsFromDB);
    }

    public List<RawSensor> getMissingSensors(List<RawSensor> pSensorsFromDB, List<RawSensor> pRealtimeSensors) {
        return ListUtils.difference((List)ListUtils.difference(pSensorsFromDB, pRealtimeSensors), this.getArchivedSensors(pSensorsFromDB, pRealtimeSensors));
    }

    public void saveSensorDefinition(List<RawSensor> pSensorsToUpdate, List<RawSensor> pSensorsToAdd, List<RawSensor> pSensorsToDelete, List<RawSensor> pSensorsToArchive) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
        for (RawSensor vSensor : pSensorsToDelete) {
            vBatch.addSQLStatement(new SQLStatement("delete from sensor_definition where sd_id = ?", new Object[]{vSensor.getID()}, false));
        }
        for (RawSensor vSensor : pSensorsToAdd) {
            vBatch.addSQLStatement(new SQLStatement("insert into sensor_definition (sd_sensor_name, sd_discrete, sd_ntfy_on_alert) values (?,?,?)", new Object[]{vSensor.getName(), vSensor.isDiscrete() ? "T" : "F", vSensor.isNotifyOnAlert() ? "T" : "F"}, false));
        }
        for (RawSensor vSensor : pSensorsToUpdate) {
            vBatch.addSQLStatement(new SQLStatement("update sensor_definition set sd_sensor_name = ?, sd_discrete = ? where sd_id = ?", new Object[]{vSensor.getName(), vSensor.isDiscrete() ? "T" : "F", vSensor.getID()}, false));
        }
        for (RawSensor vSensor : pSensorsToArchive) {
            vBatch.addSQLStatement(new SQLStatement("update sensor_definition set sd_archived = 'T' where sd_id = ?", new Object[]{vSensor.getID()}, false));
        }
        DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
    }

    public boolean isDiscreteSensor(String pSensor) throws NoMatchFoundException {
        return this.getRawSensor(pSensor).isDiscrete();
    }

    public class SampleThread
    extends Thread {
        private Configuration mConfiguration;
        private Thread mThread;
        private volatile boolean mTerminateRequested;
        private StatusCallback mStatusCallback;
        final int PAUSE_DURATION = 5000;
        private AquatronicaSample mLastAquatronicaSample;
        private long mLastAnaloguePollSaved;
        private NotificationModule mNotificationModule;

        public SampleThread(Configuration pConfiguration, StatusCallback pStatusCallback) {
            this.setDaemon(pStatusCallback != null);
            this.mConfiguration = pConfiguration;
            this.mTerminateRequested = false;
            this.mThread = this;
            this.mStatusCallback = pStatusCallback;
            this.mLastAquatronicaSample = null;
            this.mLastAnaloguePollSaved = 0L;
            this.mNotificationModule = new NotificationModule(this.mConfiguration);
        }

        public SampleThread(Configuration pConfiguration) {
            this(pConfiguration, null);
        }

        private void setStatus(String pStatus, boolean pError) {
            if (this.mStatusCallback != null) {
                this.mStatusCallback.updateStatusText(pStatus, pError);
            }
        }

        public void run() {
            System.out.println("Sampling... (Each \".\" represents a sample taken, each \"!\" represents a discrete state change, each \"?\" indicates an superfluous, ignored discrete state change)");
            this.setStatus("Sampling started...", false);
            while (!this.mTerminateRequested) {
                this.takeSample();
                try {
                    SampleThread.sleep(5000L);
                    this.setStatus("", false);
                    SampleThread.sleep((long)DateUtils.convertTime((long)this.mConfiguration.getDiscreteInterval(), (int)2, (int)1) - 5000L);
                }
                catch (InterruptedException e) {
                    this.mTerminateRequested = true;
                }
            }
            System.out.println();
            System.out.println("Stopped.");
            this.setStatus("Sampling stopped.", false);
        }

        private void takeSample() {
            try {
                AquatronicaSample vAquatronicaSample = AquatronicaInterface.this.sample();
                SQLBatch vBatch = new SQLBatch(true, "Aquatronica", DBHelper.getInstance().getXLayerProperties());
                if (System.currentTimeMillis() - this.mLastAnaloguePollSaved >= (long)(this.mConfiguration.getInterval() * 60 * 1000 - 5000)) {
                    Date vTime = new Date();
                    for (String vSensorName : vAquatronicaSample.getSensorData().keySet()) {
                        SensorData vSensorData = vAquatronicaSample.getSensorData().get(vSensorName);
                        vBatch.addSQLStatement(new SQLStatement("insert into sensor (sens_sd_id, sens_value, sens_status, sens_timestamp) values ((select sd_id from sensor_definition where sd_sensor_name = ?),?,?,?)", new Object[]{vSensorName, vSensorData.getValue(), vSensorData.getStatusCode(), vTime}, false));
                    }
                    int i = 0;
                    for (String vPowerUnitName : vAquatronicaSample.getPowerUnitSample().keySet()) {
                        PowerUnitSample vPowerUnitSample = vAquatronicaSample.getPowerUnitSample().get(vPowerUnitName);
                        vBatch.addSQLStatement(DBHelper.getInstance().generateSQLStatementInsertPowerUnit("insert into powerunit (pu_pud_id, pu_timestamp) values ((select pud_id from powerunit_definition where pud_unit_id = ?),?)", new Object[]{vPowerUnitSample.getPowerUnitID(), vTime}, i));
                        for (Integer vPlugID : vPowerUnitSample.getPlugSample().keySet()) {
                            PlugSample vPlugSample = vPowerUnitSample.getPlugSample().get(vPlugID);
                            vBatch.addSQLStatement(new SQLStatement("insert into plug (pl_pu_id, pl_pld_id,pl_status, pl_timestamp) values  (?,(select pld_id from plug_definition, powerunit_definition where pud_id = pld_pud_id and pud_unit_id = ? and pld_plug_id = ?),?,?)", new Object[]{new SerialField("PowerUnit" + i), vPowerUnitSample.getPowerUnitID(), vPlugSample.getPlugID(), Utils.getInt((String)vPlugSample.getStatus()), vTime}, false));
                        }
                        ++i;
                    }
                    this.mLastAnaloguePollSaved = System.currentTimeMillis();
                } else {
                    for (String vSensorName : vAquatronicaSample.getSensorData().keySet()) {
                        SensorData vNewData = vAquatronicaSample.getSensorData().get(vSensorName);
                        SensorData vOldData = this.mLastAquatronicaSample.getSensorData().get(vSensorName);
                        if (!AquatronicaInterface.this.getRawSensor(vSensorName).isDiscrete() || vOldData != null && vOldData.getValue().equals(vNewData.getValue())) continue;
                        if ((vOldData.getValue().equals("-") || vOldData.getValue().equals("?")) && (vNewData.getValue().equals("-") || vNewData.getValue().equals("?"))) {
                            System.out.print("?");
                            continue;
                        }
                        Date vTime = new Date();
                        Date vPreviousTime = new Date(vTime.getTime() - (long)(this.mConfiguration.getDiscreteInterval() * 1000));
                        if (vOldData != null) {
                            vBatch.addSQLStatement(new SQLStatement("insert into sensor (sens_sd_id, sens_value, sens_status, sens_timestamp) values ((select sd_id from sensor_definition where sd_sensor_name = ?),?,?,?)", new Object[]{vSensorName, vOldData.getValue(), vOldData.getStatusCode(), vPreviousTime}, false));
                        }
                        vBatch.addSQLStatement(new SQLStatement("insert into sensor (sens_sd_id, sens_value, sens_status, sens_timestamp) values ((select sd_id from sensor_definition where sd_sensor_name = ?),?,?,?)", new Object[]{vSensorName, vNewData.getValue(), vNewData.getStatusCode(), vTime}, false));
                        System.out.print("!");
                    }
                }
                if (vBatch.getSQLStatementCount() > 0) {
                    DBHelper.getInstance().getDBLayer().submitTransaction(vBatch);
                    System.out.print(".");
                    this.setStatus("Sample Taken Successfully", false);
                }
                this.mNotificationModule.checkStatus(this.mLastAquatronicaSample, vAquatronicaSample);
                this.mLastAquatronicaSample = vAquatronicaSample;
            }
            catch (Exception e) {
                if (e instanceof DisconnectedFromEthernetModuleException) {
                    this.mNotificationModule.disconnectedFromAquatronica();
                }
                System.out.println("");
                System.out.println("Error occurred - skipping this check: " + e.getMessage());
                if (e instanceof NullPointerException) {
                    e.printStackTrace();
                }
                this.setStatus("Error occurred - skipping this check: " + e.getMessage(), true);
            }
        }

        public void terminate() {
            this.mTerminateRequested = true;
            this.mThread.interrupt();
            this.mNotificationModule.terminate();
        }
    }

    public static class ResultOnDate {
        private double mValue;
        private Date mDate;

        public ResultOnDate(double pValue, Date pDate) {
            this.mValue = pValue;
            this.mDate = pDate;
        }

        public double getValue() {
            return this.mValue;
        }

        public Date getDate() {
            return this.mDate;
        }
    }
}

