/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.dom4j.DocumentException;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.AquatronicaSample;
import za.co.pwnconsulting.aquatronica.PleaseWaitDialog;
import za.co.pwnconsulting.aquatronica.RawPlug;
import za.co.pwnconsulting.aquatronica.RawPowerunit;
import za.co.pwnconsulting.aquatronica.RawSensor;
import za.co.pwnconsulting.aquatronica.ValidationFailedException;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;

public class AquatronicaDevicesForm
extends JDialog {
    private Configuration mConfiguration;
    private AquatronicaSample mSample;
    private JTabbedPane mTabbedPane1;
    private JPanel mPanelPowerunit;
    private JComponent mSeparator1;
    private JScrollPane mScrollPane1;
    private JTable mTableKnownPowerunits;
    private JComponent mSeparator8;
    private JScrollPane mScrollPane8;
    private JTable mTableArchivedPowerunits;
    private JComponent mSeparator2;
    private JScrollPane mScrollPane2;
    private JTable mTableNewPowerunits;
    private JComponent mSeparator3;
    private JScrollPane mScrollPane3;
    private JTable mTableMissingPowerunits;
    private JPanel mPanel3;
    private JButton mButtonSavePowerunit;
    private JButton mButtonCancel;
    private JPanel mPanelPlugs;
    private JComponent mSeparator4;
    private JScrollPane mScrollPane4;
    private JTable mTableKnownPlugs;
    private JPanel mPanel4;
    private JButton mButtonSavePlugs;
    private JButton mButtonCancel2;
    private JPanel mPanelSensors;
    private JComponent mSeparator5;
    private JScrollPane mScrollPane5;
    private JTable mTableKnownSensors;
    private JComponent mSeparator9;
    private JScrollPane mScrollPane9;
    private JTable mTableArchivedSensors;
    private JComponent mSeparator6;
    private JScrollPane mScrollPane6;
    private JTable mTableNewSensors;
    private JComponent mSeparator7;
    private JScrollPane mScrollPane7;
    private JTable mTableMissingSensors;
    private JPanel mPanel5;
    private JButton mButtonLink;
    private JButton mButtonDelink;
    private JButton mButtonSaveSensors;
    private JButton mButtonCancel3;

    public AquatronicaDevicesForm(Frame owner, Configuration pConfiguration) throws DocumentException, IOException {
        super(owner);
        this.init(pConfiguration);
    }

    public AquatronicaDevicesForm(Configuration pConfiguration) throws DocumentException, IOException {
        this.init(pConfiguration);
    }

    private void init(Configuration pConfiguration) throws IOException, DocumentException {
        this.mConfiguration = pConfiguration;
        this.mSample = new AquatronicaInterface(this.mConfiguration).sample();
        this.initComponents();
        this.mTableKnownPowerunits.getColumn("-").setMaxWidth(0);
        this.mTableKnownPowerunits.getColumn("-").setMinWidth(0);
        this.mTableKnownPowerunits.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableKnownPowerunits.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableNewPowerunits.getColumn("-").setMaxWidth(0);
        this.mTableNewPowerunits.getColumn("-").setMinWidth(0);
        this.mTableNewPowerunits.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableNewPowerunits.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableArchivedPowerunits.getColumn("-").setMaxWidth(0);
        this.mTableArchivedPowerunits.getColumn("-").setMinWidth(0);
        this.mTableArchivedPowerunits.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableArchivedPowerunits.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableMissingPowerunits.getColumn("-").setMaxWidth(0);
        this.mTableMissingPowerunits.getColumn("-").setMinWidth(0);
        this.mTableMissingPowerunits.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableMissingPowerunits.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableKnownPlugs.getColumn("-").setMaxWidth(0);
        this.mTableKnownPlugs.getColumn("-").setMinWidth(0);
        this.mTableKnownPlugs.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableKnownPlugs.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableKnownSensors.getColumn("-").setMaxWidth(0);
        this.mTableKnownSensors.getColumn("-").setMinWidth(0);
        this.mTableKnownSensors.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableKnownSensors.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableNewSensors.getColumn("-").setMaxWidth(0);
        this.mTableNewSensors.getColumn("-").setMinWidth(0);
        this.mTableNewSensors.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableNewSensors.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableArchivedSensors.getColumn("-").setMaxWidth(0);
        this.mTableArchivedSensors.getColumn("-").setMinWidth(0);
        this.mTableArchivedSensors.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableArchivedSensors.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableMissingSensors.getColumn("-").setMaxWidth(0);
        this.mTableMissingSensors.getColumn("-").setMinWidth(0);
        this.mTableMissingSensors.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableMissingSensors.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
    }

    private void tabbedPane1StateChanged(ChangeEvent e) {
        try {
            AquatronicaInterface vAquatronicaInterface = new AquatronicaInterface(this.mConfiguration);
            if (this.mTabbedPane1.getSelectedComponent() == this.mPanelPowerunit) {
                List<RawPowerunit> vPowerUnits = vAquatronicaInterface.getPowerUnitsFromDB();
                List<RawPowerunit> vRealtimePowerUnits = vAquatronicaInterface.getPowerUnitsFromAquatronica(this.mSample);
                List<RawPowerunit> vKnownPowerUnits = vAquatronicaInterface.getKnownPowerUnits(vPowerUnits, vRealtimePowerUnits);
                List<RawPowerunit> vArchivedPowerUnits = vAquatronicaInterface.getArchivedPowerUnits(vPowerUnits, vRealtimePowerUnits);
                List<RawPowerunit> vNewPowerUnits = vAquatronicaInterface.getNewPowerUnits(vPowerUnits, vRealtimePowerUnits);
                List<RawPowerunit> vMissingPowerUnits = vAquatronicaInterface.getMissingPowerUnits(vPowerUnits, vRealtimePowerUnits);
                DefaultTableModel vModel = (DefaultTableModel)this.mTableKnownPowerunits.getModel();
                vModel.getDataVector().clear();
                for (RawPowerunit vPowerUnit : vKnownPowerUnits) {
                    String vName = vPowerUnit.getName();
                    boolean vUpdate = false;
                    for (RawPowerunit vRealtimePowerUnit : vRealtimePowerUnits) {
                        if (vRealtimePowerUnit.getPowerunitID() != vPowerUnit.getPowerunitID()) continue;
                        if (!vRealtimePowerUnit.getName().equals(vPowerUnit.getName())) {
                            vName = vName + " (renamed to: " + vRealtimePowerUnit.getName() + ")";
                            vUpdate = true;
                        }
                        vPowerUnit.setName(vRealtimePowerUnit.getName());
                        break;
                    }
                    vModel.addRow(new Object[]{vPowerUnit, vPowerUnit.getPowerunitID(), vName, vUpdate});
                }
                this.mTableKnownPowerunits.getSelectionModel().clearSelection();
                vModel = (DefaultTableModel)this.mTableArchivedPowerunits.getModel();
                vModel.getDataVector().clear();
                for (RawPowerunit vPowerUnit : vArchivedPowerUnits) {
                    vModel.addRow(new Object[]{vPowerUnit, vPowerUnit.getPowerunitID(), vPowerUnit.getName(), false});
                }
                this.mTableArchivedPowerunits.getSelectionModel().clearSelection();
                vModel = (DefaultTableModel)this.mTableNewPowerunits.getModel();
                vModel.getDataVector().clear();
                for (RawPowerunit vPowerUnit : vNewPowerUnits) {
                    vPowerUnit.getPlugs().addAll(vAquatronicaInterface.getPlugsFromAquatronica(vPowerUnit.getPowerunitID(), this.mSample));
                    vModel.addRow(new Object[]{vPowerUnit, vPowerUnit.getPowerunitID(), vPowerUnit.getName(), true});
                }
                this.mTableNewPowerunits.getSelectionModel().clearSelection();
                vModel = (DefaultTableModel)this.mTableMissingPowerunits.getModel();
                vModel.getDataVector().clear();
                for (RawPowerunit vPowerUnit : vMissingPowerUnits) {
                    vModel.addRow(new Object[]{vPowerUnit, vPowerUnit.getPowerunitID(), vPowerUnit.getName(), true, false});
                }
                this.mTableMissingPowerunits.getSelectionModel().clearSelection();
                this.repaint();
            } else if (this.mTabbedPane1.getSelectedComponent() == this.mPanelPlugs) {
                List<RawPowerunit> vPowerUnits = vAquatronicaInterface.getPowerUnitsFromDB();
                List<RawPowerunit> vRealtimePowerUnits = vAquatronicaInterface.getPowerUnitsFromAquatronica(this.mSample);
                List<RawPowerunit> vKnownPowerUnits = vAquatronicaInterface.getKnownPowerUnits(vPowerUnits, vRealtimePowerUnits);
                DefaultTableModel vModel = (DefaultTableModel)this.mTableKnownPlugs.getModel();
                vModel.getDataVector().clear();
                for (RawPowerunit vPowerUnit : vKnownPowerUnits) {
                    List<RawPlug> vPlugs = vAquatronicaInterface.getPlugsFromDB(vPowerUnit.getID());
                    List<RawPlug> vRealtimePlugs = vAquatronicaInterface.getPlugsFromAquatronica(vPowerUnit.getPowerunitID(), this.mSample);
                    boolean vFirst = true;
                    for (RawPlug vPlug : vPlugs) {
                        String vName = vPlug.getName();
                        boolean vUpdate = false;
                        for (RawPlug vRealtimePlug : vRealtimePlugs) {
                            if (vRealtimePlug.getPlugID() != vPlug.getPlugID()) continue;
                            if (!vRealtimePlug.getName().equals(vPlug.getName())) {
                                vName = vName + " (renamed to: " + vRealtimePlug.getName() + ")";
                                vUpdate = true;
                            }
                            vPlug.setName(vRealtimePlug.getName());
                            break;
                        }
                        vModel.addRow(new Object[]{vPlug, vFirst ? vPowerUnit.getName() : "", vPlug.getPlugID(), vName, vUpdate});
                        vFirst = false;
                    }
                }
                this.mTableKnownPlugs.getSelectionModel().clearSelection();
            } else if (this.mTabbedPane1.getSelectedComponent() == this.mPanelSensors) {
                List<RawSensor> vSensors = vAquatronicaInterface.getSensorsFromDB();
                List<RawSensor> vRealtimeSensors = vAquatronicaInterface.getSensorsFromAquatronica(this.mSample);
                List<RawSensor> vKnownSensors = vAquatronicaInterface.getKnownSensors(vSensors, vRealtimeSensors);
                List<RawSensor> vArchivedSensors = vAquatronicaInterface.getArchivedSensors(vSensors, vRealtimeSensors);
                List<RawSensor> vNewSensors = vAquatronicaInterface.getNewSensors(vSensors, vRealtimeSensors);
                List<RawSensor> vMissingSensors = vAquatronicaInterface.getMissingSensors(vSensors, vRealtimeSensors);
                DefaultTableModel vModel = (DefaultTableModel)this.mTableKnownSensors.getModel();
                vModel.getDataVector().clear();
                for (RawSensor vSensor : vKnownSensors) {
                    String vName = vSensor.getName();
                    vModel.addRow(new Object[]{vSensor, vName, vSensor.isDiscrete(), false});
                }
                this.mTableKnownSensors.getSelectionModel().clearSelection();
                vModel = (DefaultTableModel)this.mTableArchivedSensors.getModel();
                vModel.getDataVector().clear();
                for (RawSensor vSensor : vArchivedSensors) {
                    vModel.addRow(new Object[]{vSensor, vSensor.getName(), false});
                }
                this.mTableArchivedSensors.getSelectionModel().clearSelection();
                vModel = (DefaultTableModel)this.mTableNewSensors.getModel();
                vModel.getDataVector().clear();
                for (RawSensor vSensor : vNewSensors) {
                    vModel.addRow(new Object[]{vSensor, false, vSensor.getName(), vMissingSensors.size() <= 0});
                }
                this.mTableNewSensors.getSelectionModel().clearSelection();
                vModel = (DefaultTableModel)this.mTableMissingSensors.getModel();
                vModel.getDataVector().clear();
                for (RawSensor vSensor : vMissingSensors) {
                    vModel.addRow(new Object[]{vSensor, false, vSensor.getName(), vNewSensors.size() <= 0, false});
                }
                this.mTableMissingSensors.getSelectionModel().clearSelection();
                boolean vHaveMissingAndNewSensors = vMissingSensors.size() > 0 && vNewSensors.size() > 0;
                this.mButtonLink.setEnabled(vHaveMissingAndNewSensors);
                this.mButtonDelink.setEnabled(vHaveMissingAndNewSensors);
                this.repaint();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonCancelActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void buttonSavePowerunitActionPerformed(ActionEvent e) {
        try {
            RawPowerunit vPowerunit;
            int i;
            final ArrayList<RawPowerunit> vPowerunitsToUpdate = new ArrayList<RawPowerunit>();
            DefaultTableModel vModel = (DefaultTableModel)this.mTableKnownPowerunits.getModel();
            for (int i2 = 0; i2 < vModel.getRowCount(); ++i2) {
                RawPowerunit vPowerunit2 = (RawPowerunit)vModel.getValueAt(i2, 0);
                if (!((Boolean)vModel.getValueAt(i2, 3)).booleanValue()) continue;
                vPowerunitsToUpdate.add(vPowerunit2);
            }
            final ArrayList<RawPowerunit> vPowerunitsToAdd = new ArrayList<RawPowerunit>();
            vModel = (DefaultTableModel)this.mTableNewPowerunits.getModel();
            for (int i3 = 0; i3 < vModel.getRowCount(); ++i3) {
                RawPowerunit vPowerunit3 = (RawPowerunit)vModel.getValueAt(i3, 0);
                if (!((Boolean)vModel.getValueAt(i3, 3)).booleanValue()) continue;
                vPowerunitsToAdd.add(vPowerunit3);
            }
            final ArrayList<RawPowerunit> vPowerunitsToDelete = new ArrayList<RawPowerunit>();
            vModel = (DefaultTableModel)this.mTableMissingPowerunits.getModel();
            for (i = 0; i < vModel.getRowCount(); ++i) {
                vPowerunit = (RawPowerunit)vModel.getValueAt(i, 0);
                if (!((Boolean)vModel.getValueAt(i, 4)).booleanValue()) continue;
                if (((Boolean)vModel.getValueAt(i, 3)).booleanValue()) {
                    throw new ValidationFailedException("Cannot mark a powerunit for Delete and Archive for powerunit " + vPowerunit.getName() + " - pick one...");
                }
                vPowerunitsToDelete.add(vPowerunit);
            }
            vModel = (DefaultTableModel)this.mTableArchivedPowerunits.getModel();
            for (i = 0; i < vModel.getRowCount(); ++i) {
                vPowerunit = (RawPowerunit)vModel.getValueAt(i, 0);
                if (!((Boolean)vModel.getValueAt(i, 3)).booleanValue()) continue;
                vPowerunitsToDelete.add(vPowerunit);
            }
            final ArrayList<RawPowerunit> vPowerunitsToArchive = new ArrayList<RawPowerunit>();
            vModel = (DefaultTableModel)this.mTableMissingPowerunits.getModel();
            for (int i4 = 0; i4 < vModel.getRowCount(); ++i4) {
                RawPowerunit vPowerunit4 = (RawPowerunit)vModel.getValueAt(i4, 0);
                if (!((Boolean)vModel.getValueAt(i4, 3)).booleanValue()) continue;
                vPowerunitsToArchive.add(vPowerunit4);
            }
            if (vPowerunitsToUpdate.size() <= 0 && vPowerunitsToDelete.size() <= 0 && vPowerunitsToAdd.size() <= 0 && vPowerunitsToArchive.size() <= 0) {
                JOptionPane.showMessageDialog(this, "No powerunit was ticked - hence nothing to save", "Warning", 2);
            } else if (vPowerunitsToDelete.size() <= 0 || JOptionPane.showConfirmDialog(this, "Deleting a powerunit will delete all associated data with it. Are you sure?  If not, rather archive it.", "Warning", 0, 2) == 0) {
                final ActionEvent event = e;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PleaseWaitDialog vPWD = new PleaseWaitDialog((JDialog)SwingUtilities.getRoot((Component)event.getSource()), "Please wait while AquaStats is updating your database...");
                        try {
                            new AquatronicaInterface(AquatronicaDevicesForm.this.mConfiguration).savePowerunitDefinition(vPowerunitsToUpdate, vPowerunitsToAdd, vPowerunitsToDelete, vPowerunitsToArchive);
                            AquatronicaDevicesForm.this.tabbedPane1StateChanged(null);
                        }
                        finally {
                            AquatronicaDevicesForm.this.setEnabled(true);
                            AquatronicaDevicesForm.this.setFocusable(true);
                            vPWD.dispose();
                        }
                    }
                }.start();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonSavePlugsActionPerformed(ActionEvent e) {
        try {
            ArrayList<RawPlug> vPlugsToUpdate = new ArrayList<RawPlug>();
            DefaultTableModel vModel = (DefaultTableModel)this.mTableKnownPlugs.getModel();
            for (int i = 0; i < vModel.getRowCount(); ++i) {
                RawPlug vPlug = (RawPlug)vModel.getValueAt(i, 0);
                if (!((Boolean)vModel.getValueAt(i, 4)).booleanValue()) continue;
                vPlugsToUpdate.add(vPlug);
            }
            if (vPlugsToUpdate.size() <= 0) {
                JOptionPane.showMessageDialog(this, "No plug was ticked - hence nothing to save", "Warning", 2);
            } else {
                new AquatronicaInterface(this.mConfiguration).savePlugDefinition(vPlugsToUpdate);
                this.tabbedPane1StateChanged(null);
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonLinkActionPerformed(ActionEvent e) {
        try {
            DefaultTableModel vModelMissing = (DefaultTableModel)this.mTableMissingSensors.getModel();
            int vIndexMissing = -1;
            for (int i = 0; i < vModelMissing.getRowCount(); ++i) {
                if (!((Boolean)vModelMissing.getValueAt(i, 1)).booleanValue()) continue;
                if (vIndexMissing >= 0) {
                    throw new ValidationFailedException("Cannot tick multiple missing sensors to link to new sensors.  Only one may be selected at a time.");
                }
                vIndexMissing = i;
            }
            if (vIndexMissing < 0) {
                throw new ValidationFailedException("One missing sensor needs to be selected for linking to a new sensor.");
            }
            int vIndexNew = -1;
            DefaultTableModel vModelNew = (DefaultTableModel)this.mTableNewSensors.getModel();
            for (int i = 0; i < vModelNew.getRowCount(); ++i) {
                if (!((Boolean)vModelNew.getValueAt(i, 1)).booleanValue()) continue;
                if (vIndexNew >= 0) {
                    throw new ValidationFailedException("Cannot tick multiple new sensors to link to missing sensors.  Only one may be selected at a time.");
                }
                vIndexNew = i;
            }
            if (vIndexNew < 0) {
                throw new ValidationFailedException("One new sensor needs to be selected for linking to a missing sensor.");
            }
            RawSensor vSensorMissing = (RawSensor)vModelMissing.getValueAt(vIndexMissing, 0);
            RawSensor vSensorNew = (RawSensor)vModelNew.getValueAt(vIndexNew, 0);
            vSensorMissing.setNewName(vSensorNew.getName());
            vModelMissing.setValueAt(vSensorMissing.getName() + " (rename to: " + vSensorNew.getName() + ")", vIndexMissing, 2);
            vModelMissing.setValueAt(false, vIndexMissing, 1);
            vModelNew.setValueAt(false, vIndexNew, 1);
            this.mTableNewSensors.getSelectionModel().clearSelection();
            this.mTableMissingSensors.getSelectionModel().clearSelection();
        }
        catch (ValidationFailedException exc) {
            JOptionPane.showMessageDialog(this, exc.getMessage(), "Error", 0);
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonDelinkActionPerformed(ActionEvent e) {
        try {
            DefaultTableModel vModelMissing = (DefaultTableModel)this.mTableMissingSensors.getModel();
            int vIndexMissing = -1;
            for (int i = 0; i < vModelMissing.getRowCount(); ++i) {
                if (!((Boolean)vModelMissing.getValueAt(i, 1)).booleanValue()) continue;
                RawSensor vSensorMissing = (RawSensor)vModelMissing.getValueAt(i, 0);
                vSensorMissing.setNewName(null);
                vModelMissing.setValueAt(vSensorMissing.getName(), i, 2);
                vModelMissing.setValueAt(false, i, 1);
                vIndexMissing = i;
            }
            if (vIndexMissing < 0) {
                throw new ValidationFailedException("One or more missing sensor needs to be selected for delinking.");
            }
            this.mTableMissingSensors.getSelectionModel().clearSelection();
        }
        catch (ValidationFailedException exc) {
            JOptionPane.showMessageDialog(this, exc.getMessage(), "Error", 0);
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonSaveSensorsActionPerformed(ActionEvent e) {
        try {
            int i;
            final ArrayList<RawSensor> vSensorsToUpdate = new ArrayList<RawSensor>();
            DefaultTableModel vModel = (DefaultTableModel)this.mTableKnownSensors.getModel();
            for (int i2 = 0; i2 < vModel.getRowCount(); ++i2) {
                RawSensor vSensor = (RawSensor)vModel.getValueAt(i2, 0);
                if (!((Boolean)vModel.getValueAt(i2, 3)).booleanValue()) continue;
                vSensor.setDiscrete((Boolean)vModel.getValueAt(i2, 2));
                vSensorsToUpdate.add(vSensor);
            }
            final ArrayList<RawSensor> vSensorsToAdd = new ArrayList<RawSensor>();
            vModel = (DefaultTableModel)this.mTableNewSensors.getModel();
            DefaultTableModel vModelMissingSensors = (DefaultTableModel)this.mTableMissingSensors.getModel();
            for (int i3 = 0; i3 < vModel.getRowCount(); ++i3) {
                RawSensor vSensor = (RawSensor)vModel.getValueAt(i3, 0);
                if (!((Boolean)vModel.getValueAt(i3, 3)).booleanValue()) continue;
                for (int j = 0; j < vModelMissingSensors.getRowCount(); ++j) {
                    RawSensor vMissingSensor = (RawSensor)vModelMissingSensors.getValueAt(j, 0);
                    if (Utils.isEmptyString((String)vMissingSensor.getNewName()) || !vMissingSensor.getNewName().equals(vSensor.getName())) continue;
                    throw new ValidationFailedException("Cannot mark a sensor for Add when it was linked to missing sensor: " + vMissingSensor.getName());
                }
                vSensorsToAdd.add(vSensor);
            }
            final ArrayList<RawSensor> vSensorsToDelete = new ArrayList<RawSensor>();
            vModel = (DefaultTableModel)this.mTableMissingSensors.getModel();
            for (i = 0; i < vModel.getRowCount(); ++i) {
                RawSensor vSensor = (RawSensor)vModel.getValueAt(i, 0);
                if (((Boolean)vModel.getValueAt(i, 4)).booleanValue()) {
                    if (!Utils.isEmptyString((String)vSensor.getNewName())) {
                        throw new ValidationFailedException("Cannot mark a sensor for Delete when it was linked to new sensor: " + vSensor.getNewName());
                    }
                    if (((Boolean)vModel.getValueAt(i, 3)).booleanValue()) {
                        throw new ValidationFailedException("Cannot mark a sensor for Delete and Archive for sensor " + vSensor.getName() + " - pick one...");
                    }
                    vSensorsToDelete.add(vSensor);
                    continue;
                }
                if (Utils.isEmptyString((String)vSensor.getNewName())) continue;
                vSensor.setName(vSensor.getNewName());
                vSensorsToUpdate.add(vSensor);
            }
            vModel = (DefaultTableModel)this.mTableArchivedSensors.getModel();
            for (i = 0; i < vModel.getRowCount(); ++i) {
                RawSensor vSensor = (RawSensor)vModel.getValueAt(i, 0);
                if (!((Boolean)vModel.getValueAt(i, 2)).booleanValue()) continue;
                vSensorsToDelete.add(vSensor);
            }
            final ArrayList<RawSensor> vSensorsToArchive = new ArrayList<RawSensor>();
            vModel = (DefaultTableModel)this.mTableMissingSensors.getModel();
            for (int i4 = 0; i4 < vModel.getRowCount(); ++i4) {
                RawSensor vSensor = (RawSensor)vModel.getValueAt(i4, 0);
                if (!((Boolean)vModel.getValueAt(i4, 3)).booleanValue()) continue;
                vSensorsToArchive.add(vSensor);
            }
            if (vSensorsToUpdate.size() <= 0 && vSensorsToAdd.size() <= 0 && vSensorsToDelete.size() <= 0 && vSensorsToArchive.size() <= 0) {
                JOptionPane.showMessageDialog(this, "No sensor was ticked - hence nothing to save", "Warning", 2);
            } else if (vSensorsToDelete.size() <= 0 || JOptionPane.showConfirmDialog(this, "Deleting a sensor will delete all associated data with it. Are you sure? If not, rather archive it.", "Warning", 0, 2) == 0) {
                final ActionEvent event = e;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PleaseWaitDialog vPWD = new PleaseWaitDialog((JDialog)SwingUtilities.getRoot((Component)event.getSource()), "Please wait while AquaStats is updating your database...");
                        try {
                            new AquatronicaInterface(AquatronicaDevicesForm.this.mConfiguration).saveSensorDefinition(vSensorsToUpdate, vSensorsToAdd, vSensorsToDelete, vSensorsToArchive);
                            AquatronicaDevicesForm.this.tabbedPane1StateChanged(null);
                        }
                        finally {
                            AquatronicaDevicesForm.this.setEnabled(true);
                            AquatronicaDevicesForm.this.setFocusable(true);
                            vPWD.dispose();
                        }
                    }
                }.start();
            }
        }
        catch (ValidationFailedException exc) {
            JOptionPane.showMessageDialog(this, exc.getMessage(), "Error", 0);
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mTabbedPane1 = new JTabbedPane();
        this.mPanelPowerunit = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Known (Current) Powerunits");
        this.mScrollPane1 = new JScrollPane();
        this.mTableKnownPowerunits = new JTable();
        this.mSeparator8 = compFactory.createSeparator("Archived Powerunits");
        this.mScrollPane8 = new JScrollPane();
        this.mTableArchivedPowerunits = new JTable();
        this.mSeparator2 = compFactory.createSeparator("New Powerunits");
        this.mScrollPane2 = new JScrollPane();
        this.mTableNewPowerunits = new JTable();
        this.mSeparator3 = compFactory.createSeparator("Missing Powerunits");
        this.mScrollPane3 = new JScrollPane();
        this.mTableMissingPowerunits = new JTable();
        this.mPanel3 = new JPanel();
        this.mButtonSavePowerunit = new JButton();
        this.mButtonCancel = new JButton();
        this.mPanelPlugs = new JPanel();
        this.mSeparator4 = compFactory.createSeparator("Known (Current) Plugs");
        this.mScrollPane4 = new JScrollPane();
        this.mTableKnownPlugs = new JTable();
        this.mPanel4 = new JPanel();
        this.mButtonSavePlugs = new JButton();
        this.mButtonCancel2 = new JButton();
        this.mPanelSensors = new JPanel();
        this.mSeparator5 = compFactory.createSeparator("Known (Current) Sensors");
        this.mScrollPane5 = new JScrollPane();
        this.mTableKnownSensors = new JTable();
        this.mSeparator9 = compFactory.createSeparator("Archived Sensors");
        this.mScrollPane9 = new JScrollPane();
        this.mTableArchivedSensors = new JTable();
        this.mSeparator6 = compFactory.createSeparator("New Sensors");
        this.mScrollPane6 = new JScrollPane();
        this.mTableNewSensors = new JTable();
        this.mSeparator7 = compFactory.createSeparator("Missing Sensor");
        this.mScrollPane7 = new JScrollPane();
        this.mTableMissingSensors = new JTable();
        this.mPanel5 = new JPanel();
        this.mButtonLink = new JButton();
        this.mButtonDelink = new JButton();
        this.mButtonSaveSensors = new JButton();
        this.mButtonCancel3 = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Aquatronica Device Configuration");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new FormLayout("default:grow", "fill:default:grow"));
        this.mTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AquatronicaDevicesForm.this.tabbedPane1StateChanged(e);
            }
        });
        this.mPanelPowerunit.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mPanelPowerunit.setLayout((LayoutManager)new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.BOTTOM, (Size)Sizes.DEFAULT, 1.0)}));
        this.mPanelPowerunit.add((Component)this.mSeparator1, cc.xy(1, 1));
        this.mTableKnownPowerunits.setModel(new DefaultTableModel(new Object[][]{{null, null, null, false}, {null, null, null, null}}, new String[]{"-", "ID", "Name", "Update"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Integer.class, String.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, false, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        TableColumnModel cm = this.mTableKnownPowerunits.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(1).setResizable(false);
        cm.getColumn(1).setMinWidth(40);
        cm.getColumn(1).setMaxWidth(40);
        cm.getColumn(1).setPreferredWidth(40);
        cm.getColumn(3).setResizable(false);
        cm.getColumn(3).setMinWidth(60);
        cm.getColumn(3).setMaxWidth(60);
        cm.getColumn(3).setPreferredWidth(60);
        this.mScrollPane1.setViewportView(this.mTableKnownPowerunits);
        this.mPanelPowerunit.add((Component)this.mScrollPane1, cc.xy(1, 3));
        this.mPanelPowerunit.add((Component)this.mSeparator8, cc.xy(1, 5));
        this.mTableArchivedPowerunits.setModel(new DefaultTableModel(new Object[][]{{null, null, null, false}, {null, null, null, null}}, new String[]{"-", "ID", "Name", "Delete"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Integer.class, String.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, false, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTableArchivedPowerunits.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(1).setResizable(false);
        cm.getColumn(1).setMinWidth(40);
        cm.getColumn(1).setMaxWidth(40);
        cm.getColumn(1).setPreferredWidth(40);
        cm.getColumn(3).setResizable(false);
        cm.getColumn(3).setMinWidth(60);
        cm.getColumn(3).setMaxWidth(60);
        cm.getColumn(3).setPreferredWidth(60);
        this.mTableArchivedPowerunits.setBackground(new Color(204, 204, 204));
        this.mScrollPane8.setViewportView(this.mTableArchivedPowerunits);
        this.mPanelPowerunit.add((Component)this.mScrollPane8, cc.xy(1, 7));
        this.mPanelPowerunit.add((Component)this.mSeparator2, cc.xy(1, 9));
        this.mTableNewPowerunits.setModel(new DefaultTableModel(new Object[][]{{null, null, null, false}, {null, null, null, null}}, new String[]{"-", "ID", "Name", "Add"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Integer.class, String.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, false, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTableNewPowerunits.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(1).setResizable(false);
        cm.getColumn(1).setMinWidth(40);
        cm.getColumn(1).setMaxWidth(40);
        cm.getColumn(1).setPreferredWidth(40);
        cm.getColumn(3).setResizable(false);
        cm.getColumn(3).setMinWidth(60);
        cm.getColumn(3).setMaxWidth(60);
        cm.getColumn(3).setPreferredWidth(60);
        this.mTableNewPowerunits.setBackground(new Color(151, 252, 164));
        this.mScrollPane2.setViewportView(this.mTableNewPowerunits);
        this.mPanelPowerunit.add((Component)this.mScrollPane2, cc.xy(1, 11));
        this.mPanelPowerunit.add((Component)this.mSeparator3, cc.xy(1, 13));
        this.mTableMissingPowerunits.setModel(new DefaultTableModel(new Object[][]{{null, null, null, false, false}, {null, null, null, false, null}}, new String[]{"-", "ID", "Name", "Archive", "Delete"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Integer.class, String.class, Boolean.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, false, true, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTableMissingPowerunits.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(1).setResizable(false);
        cm.getColumn(1).setMinWidth(40);
        cm.getColumn(1).setMaxWidth(40);
        cm.getColumn(1).setPreferredWidth(40);
        cm.getColumn(3).setResizable(false);
        cm.getColumn(3).setMinWidth(60);
        cm.getColumn(3).setMaxWidth(60);
        cm.getColumn(3).setPreferredWidth(60);
        cm.getColumn(4).setResizable(false);
        cm.getColumn(4).setMinWidth(60);
        cm.getColumn(4).setMaxWidth(60);
        cm.getColumn(4).setPreferredWidth(60);
        this.mTableMissingPowerunits.setBackground(new Color(254, 190, 190));
        this.mScrollPane3.setViewportView(this.mTableMissingPowerunits);
        this.mPanelPowerunit.add((Component)this.mScrollPane3, cc.xy(1, 15));
        this.mPanel3.setLayout(new FlowLayout(2));
        this.mButtonSavePowerunit.setText("Save");
        this.mButtonSavePowerunit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AquatronicaDevicesForm.this.buttonSavePowerunitActionPerformed(e);
            }
        });
        this.mPanel3.add(this.mButtonSavePowerunit);
        this.mButtonCancel.setText("Close");
        this.mButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AquatronicaDevicesForm.this.buttonCancelActionPerformed(e);
            }
        });
        this.mPanel3.add(this.mButtonCancel);
        this.mPanelPowerunit.add((Component)this.mPanel3, cc.xy(1, 17));
        this.mTabbedPane1.addTab("Powerunits", this.mPanelPowerunit);
        this.mPanelPlugs.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mPanelPlugs.setLayout((LayoutManager)new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.BOTTOM, (Size)Sizes.DEFAULT, 1.0)}));
        this.mPanelPlugs.add((Component)this.mSeparator4, cc.xy(1, 1));
        this.mTableKnownPlugs.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, false}, {null, null, null, null, null}}, new String[]{"-", "Powerunit", "Plug ID", "Plug Name", "Update"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Object.class, Integer.class, String.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, false, false, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTableKnownPlugs.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(1).setResizable(false);
        cm.getColumn(1).setPreferredWidth(150);
        cm.getColumn(2).setResizable(false);
        cm.getColumn(2).setMinWidth(60);
        cm.getColumn(2).setMaxWidth(60);
        cm.getColumn(2).setPreferredWidth(60);
        cm.getColumn(3).setPreferredWidth(230);
        cm.getColumn(4).setResizable(false);
        cm.getColumn(4).setMinWidth(60);
        cm.getColumn(4).setMaxWidth(60);
        cm.getColumn(4).setPreferredWidth(60);
        this.mScrollPane4.setViewportView(this.mTableKnownPlugs);
        this.mPanelPlugs.add((Component)this.mScrollPane4, cc.xy(1, 3));
        this.mPanel4.setLayout(new FlowLayout(2));
        this.mButtonSavePlugs.setText("Save");
        this.mButtonSavePlugs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AquatronicaDevicesForm.this.buttonSavePlugsActionPerformed(e);
            }
        });
        this.mPanel4.add(this.mButtonSavePlugs);
        this.mButtonCancel2.setText("Close");
        this.mButtonCancel2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AquatronicaDevicesForm.this.buttonCancelActionPerformed(e);
            }
        });
        this.mPanel4.add(this.mButtonCancel2);
        this.mPanelPlugs.add((Component)this.mPanel4, cc.xy(1, 9));
        this.mTabbedPane1.addTab("Plugs", this.mPanelPlugs);
        this.mPanelSensors.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mPanelSensors.setLayout((LayoutManager)new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 0.3), FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 0.3), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.BOTTOM, (Size)Sizes.DEFAULT, 1.0)}));
        this.mPanelSensors.add((Component)this.mSeparator5, cc.xy(1, 1));
        this.mTableKnownSensors.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}}, new String[]{"-", "Name", "Discrete?", "Update"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, String.class, Boolean.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, true, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTableKnownSensors.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(2).setResizable(false);
        cm.getColumn(2).setMinWidth(60);
        cm.getColumn(2).setMaxWidth(60);
        cm.getColumn(2).setPreferredWidth(60);
        cm.getColumn(3).setResizable(false);
        cm.getColumn(3).setMinWidth(60);
        cm.getColumn(3).setMaxWidth(60);
        cm.getColumn(3).setPreferredWidth(60);
        this.mScrollPane5.setViewportView(this.mTableKnownSensors);
        this.mPanelSensors.add((Component)this.mScrollPane5, cc.xy(1, 3));
        this.mPanelSensors.add((Component)this.mSeparator9, cc.xy(1, 5));
        this.mScrollPane9.setPreferredSize(new Dimension(454, 200));
        this.mTableArchivedSensors.setModel(new DefaultTableModel(new Object[][]{{null, null, false}, {null, null, null}}, new String[]{"-", "Name", "Delete"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, String.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTableArchivedSensors.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(2).setResizable(false);
        cm.getColumn(2).setMinWidth(60);
        cm.getColumn(2).setMaxWidth(60);
        cm.getColumn(2).setPreferredWidth(60);
        this.mTableArchivedSensors.setBackground(new Color(204, 204, 204));
        this.mScrollPane9.setViewportView(this.mTableArchivedSensors);
        this.mPanelSensors.add((Component)this.mScrollPane9, cc.xy(1, 7));
        this.mPanelSensors.add((Component)this.mSeparator6, cc.xy(1, 9));
        this.mScrollPane6.setPreferredSize(new Dimension(454, 200));
        this.mTableNewSensors.setModel(new DefaultTableModel(new Object[][]{{null, null, null, false}, {null, null, null, null}}, new String[]{"-", "Link", "Name", "Add"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Boolean.class, String.class, Boolean.class};
                this.columnEditable = new boolean[]{false, true, false, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTableNewSensors.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(1).setResizable(false);
        cm.getColumn(1).setMinWidth(40);
        cm.getColumn(1).setMaxWidth(40);
        cm.getColumn(1).setPreferredWidth(40);
        cm.getColumn(3).setResizable(false);
        cm.getColumn(3).setMinWidth(60);
        cm.getColumn(3).setMaxWidth(60);
        cm.getColumn(3).setPreferredWidth(60);
        this.mTableNewSensors.setBackground(new Color(151, 252, 164));
        this.mScrollPane6.setViewportView(this.mTableNewSensors);
        this.mPanelSensors.add((Component)this.mScrollPane6, cc.xy(1, 11));
        this.mPanelSensors.add((Component)this.mSeparator7, cc.xy(1, 13));
        this.mScrollPane7.setPreferredSize(new Dimension(450, 200));
        this.mTableMissingSensors.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, false}, {null, null, null, null, null}}, new String[]{"-", "Link", "Name", "Archive", "Delete"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Boolean.class, String.class, Boolean.class, Boolean.class};
                this.columnEditable = new boolean[]{false, true, false, true, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTableMissingSensors.getColumnModel();
        cm.getColumn(0).setResizable(false);
        cm.getColumn(1).setResizable(false);
        cm.getColumn(1).setMinWidth(40);
        cm.getColumn(1).setMaxWidth(40);
        cm.getColumn(1).setPreferredWidth(40);
        cm.getColumn(3).setResizable(false);
        cm.getColumn(3).setMinWidth(60);
        cm.getColumn(3).setMaxWidth(60);
        cm.getColumn(3).setPreferredWidth(60);
        cm.getColumn(4).setResizable(false);
        cm.getColumn(4).setMinWidth(60);
        cm.getColumn(4).setMaxWidth(60);
        cm.getColumn(4).setPreferredWidth(60);
        this.mTableMissingSensors.setBackground(new Color(254, 190, 190));
        this.mScrollPane7.setViewportView(this.mTableMissingSensors);
        this.mPanelSensors.add((Component)this.mScrollPane7, cc.xy(1, 15));
        this.mPanel5.setLayout(new FlowLayout(2));
        this.mButtonLink.setText("Link");
        this.mButtonLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AquatronicaDevicesForm.this.buttonLinkActionPerformed(e);
            }
        });
        this.mPanel5.add(this.mButtonLink);
        this.mButtonDelink.setText("Delink");
        this.mButtonDelink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AquatronicaDevicesForm.this.buttonDelinkActionPerformed(e);
            }
        });
        this.mPanel5.add(this.mButtonDelink);
        this.mButtonSaveSensors.setText("Save");
        this.mButtonSaveSensors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AquatronicaDevicesForm.this.buttonSaveSensorsActionPerformed(e);
            }
        });
        this.mPanel5.add(this.mButtonSaveSensors);
        this.mButtonCancel3.setText("Close");
        this.mButtonCancel3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AquatronicaDevicesForm.this.buttonCancelActionPerformed(e);
            }
        });
        this.mPanel5.add(this.mButtonCancel3);
        this.mPanelSensors.add((Component)this.mPanel5, cc.xy(1, 17));
        this.mTabbedPane1.addTab("Sensors", this.mPanelSensors);
        contentPane.add((Component)this.mTabbedPane1, cc.xy(1, 1));
        this.setSize(600, 740);
        this.setLocationRelativeTo(this.getOwner());
    }
}

