/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.NotificationDetails;
import za.co.pwnconsulting.aquatronica.SensorDefinition;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;
import za.co.pwnconsulting.aquatronica.helpers.GUIUtils;

public class AlertForm
extends JDialog {
    private Configuration mConfiguration;
    private JPanel mDialogPane;
    private JPanel mButtonBar;
    private JButton mOkButton;
    private JButton mCancelButton;
    private JTabbedPane mTabbedPaneNotificationSettings;
    private JPanel mContentPanelPreferences2;
    private JComponent mSeparator7;
    private JCheckBox mCheckBoxEnableAlarmNotification;
    private JCheckBox mCheckBoxEnableAlarmOnMissingDevicesNotification;
    private JCheckBox mCheckBoxEnableAlarmOnAquaStatDisconnect;
    private JCheckBox mCheckBoxEnableSummaryNotifications;
    private JPanel mContentPanelSensors;
    private JComponent mSeparator1;
    private JScrollPane mScrollPane1;
    private JTable mTableSelectedSensors;
    private JPanel mContentPanelNotificationDetails;
    private JComponent mSeparator2;
    private JLabel mLabel1;
    private JTextField mTextFieldEmailAddress;
    private JButton mButtonAddEmail;
    private JButton mButtonRemove;
    private JScrollPane mScrollPane2;
    private JList mListReceiverEmailAddresses;
    private JPanel mContentPanelAlertTemplates;
    private JComponent mSeparator3;
    private JLabel mTitle1;
    private JLabel mLabel2;
    private JTextField mTextFieldNewAlertSubject;
    private JLabel mLabel11;
    private JLabel mLabel4;
    private JScrollPane mScrollPane3;
    private JTextArea mTextAreaNewAlertBody;
    private JLabel mTitle2;
    private JLabel mLabel5;
    private JTextField mTextFieldAlertClearedSubject;
    private JLabel mLabel6;
    private JScrollPane mScrollPane4;
    private JTextArea mTextAreaAlertClearedBody;
    private JPanel mContentPanelSummaryUpdates;
    private JComponent mSeparator4;
    private JLabel mLabel7;
    private JTextField mTextFieldSummaryStatusSubject;
    private JLabel mLabel3;
    private JRadioButton mRadioButtonHourly;
    private JPanel mPanel1;
    private JRadioButton mRadioButtonDaily;
    private JLabel mLabelAtWhatTime;
    private JSpinner mSpinnerTimeHour;
    private JLabel mLabel9;
    private JSpinner mSpinnerTimeMinute;
    private JComponent mSeparator5;
    private JButton mButtonTestEmails;
    private JPanel mContentPanelPreferences;
    private JComponent mSeparator6;
    private JLabel mLabel8;
    private JPanel mPanel2;
    private JSpinner mSpinnerDeadTime;
    private JLabel mLabel10;
    private JLabel mLabel12;
    private JPanel mPanel3;
    private JSpinner mSpinnerDisconnectDelay;
    private JLabel mLabel13;

    public AlertForm(Frame owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents();
        this.init(pConfiguration);
    }

    public AlertForm(Dialog owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents();
        this.init(pConfiguration);
    }

    private void init(Configuration pConfiguration) {
        this.mConfiguration = pConfiguration;
        this.mTableSelectedSensors.getSelectionModel().setSelectionMode(0);
        this.mTableSelectedSensors.getColumn("-").setMaxWidth(0);
        this.mTableSelectedSensors.getColumn("-").setMinWidth(0);
        this.mTableSelectedSensors.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableSelectedSensors.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        DefaultTableModel vModel = (DefaultTableModel)this.mTableSelectedSensors.getModel();
        vModel.getDataVector().clear();
        NotificationDetails vNotificationDetails = new AquatronicaInterface(pConfiguration).getNotificationDetails();
        this.mCheckBoxEnableAlarmNotification.setSelected(vNotificationDetails.isAlertEnabled());
        this.mCheckBoxEnableAlarmOnMissingDevicesNotification.setSelected(vNotificationDetails.isAlertOnMissingDevicesEnabled());
        this.mCheckBoxEnableAlarmOnAquaStatDisconnect.setSelected(vNotificationDetails.isAlertOnAquaStatsDisconnected());
        this.mCheckBoxEnableSummaryNotifications.setSelected(vNotificationDetails.isSummaryEnabled());
        for (SensorDefinition vSensor : vNotificationDetails.getSensorDefinitions()) {
            vModel.addRow(new Object[]{vSensor, vSensor.getName(), vSensor.isNotifyOnAlert()});
        }
        DefaultListModel vEmailModel = (DefaultListModel)this.mListReceiverEmailAddresses.getModel();
        vEmailModel.clear();
        for (String vAddress : vNotificationDetails.getReceiverEmailAddresses()) {
            vEmailModel.addElement(vAddress);
        }
        this.mTextFieldNewAlertSubject.setText(vNotificationDetails.getNewAlertTemplateSubject());
        this.mTextAreaNewAlertBody.setText(vNotificationDetails.getNewAlertTemplateBody());
        this.mTextFieldAlertClearedSubject.setText(vNotificationDetails.getClearedAlertTemplateSubject());
        this.mTextAreaAlertClearedBody.setText(vNotificationDetails.getClearedAlertTemplateBody());
        this.mTextFieldSummaryStatusSubject.setText(vNotificationDetails.getSummaryUpdateNotificationSubject());
        if (vNotificationDetails.getSummaryUpdateFrequency() == NotificationDetails.SummaryUpdateFrequency.Daily) {
            this.mRadioButtonDaily.setSelected(true);
        } else if (vNotificationDetails.getSummaryUpdateFrequency() == NotificationDetails.SummaryUpdateFrequency.Hourly) {
            this.mRadioButtonHourly.setSelected(true);
        }
        Calendar vTime = Calendar.getInstance();
        if (vNotificationDetails.getSummaryOfUpdateTime() != null) {
            vTime.setTime(vNotificationDetails.getSummaryOfUpdateTime());
            this.mSpinnerTimeHour.setValue(vTime.get(11));
            this.mSpinnerTimeMinute.setValue(vTime.get(12));
        }
        this.toggleSpinnerStatus(vNotificationDetails.getSummaryUpdateFrequency() == NotificationDetails.SummaryUpdateFrequency.Daily);
        if (vNotificationDetails.getDeadTimeAlertNotification() != null) {
            this.mSpinnerDeadTime.setValue(vNotificationDetails.getDeadTimeAlertNotification());
        }
        if (vNotificationDetails.getAlertOnAquaStatsDisconnectedDelay() != null) {
            this.mSpinnerDisconnectDelay.setValue(vNotificationDetails.getAlertOnAquaStatsDisconnectedDelay());
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        try {
            if ((this.mCheckBoxEnableAlarmNotification.isSelected() || this.mCheckBoxEnableAlarmOnMissingDevicesNotification.isSelected() || this.mCheckBoxEnableAlarmOnAquaStatDisconnect.isSelected()) && ((DefaultListModel)this.mListReceiverEmailAddresses.getModel()).size() <= 0) {
                JOptionPane.showMessageDialog(this, "It does not make sense to enable email alarm notification without specifying any recipient email addresses", "Input Error", 2);
                this.mTabbedPaneNotificationSettings.setSelectedComponent(this.mContentPanelNotificationDetails);
            } else {
                NotificationDetails vNotificationDetails = this.buildNotificationDetails();
                new AquatronicaInterface(this.mConfiguration).saveNotificationDetails(vNotificationDetails);
                JOptionPane.showMessageDialog(this, "<html>Saved new settings.  Remember that any changes made in this dialog will not\n take effect until all instances of AquaStats have been restarted.", "Notice", 1);
                this.dispose();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private NotificationDetails buildNotificationDetails() {
        ArrayList<SensorDefinition> vSensors = new ArrayList<SensorDefinition>();
        DefaultTableModel vModel = (DefaultTableModel)this.mTableSelectedSensors.getModel();
        for (int i = 0; i < vModel.getRowCount(); ++i) {
            SensorDefinition vSensor = (SensorDefinition)vModel.getValueAt(i, 0);
            vSensor.setNotifyOnAlert((Boolean)vModel.getValueAt(i, 2));
            vSensors.add(vSensor);
        }
        ArrayList<String> vEmailAddresses = new ArrayList<String>();
        DefaultListModel vEmailModel = (DefaultListModel)this.mListReceiverEmailAddresses.getModel();
        for (int i = 0; i < vEmailModel.getSize(); ++i) {
            vEmailAddresses.add(vEmailModel.get(i).toString());
        }
        Calendar vTime = Calendar.getInstance();
        vTime.setTimeInMillis(0L);
        vTime.set(11, (Integer)this.mSpinnerTimeHour.getValue());
        vTime.set(12, (Integer)this.mSpinnerTimeMinute.getValue());
        return new NotificationDetails(vSensors, vEmailAddresses, this.mCheckBoxEnableAlarmNotification.isSelected(), this.mTextFieldNewAlertSubject.getText(), this.mTextAreaNewAlertBody.getText(), this.mTextFieldAlertClearedSubject.getText(), this.mTextAreaAlertClearedBody.getText(), this.mTextFieldSummaryStatusSubject.getText(), this.mCheckBoxEnableSummaryNotifications.isSelected(), this.mRadioButtonDaily.isSelected() ? NotificationDetails.SummaryUpdateFrequency.Daily : NotificationDetails.SummaryUpdateFrequency.Hourly, vTime.getTime(), (Integer)this.mSpinnerDeadTime.getValue(), this.mCheckBoxEnableAlarmOnMissingDevicesNotification.isSelected(), this.mCheckBoxEnableAlarmOnAquaStatDisconnect.isSelected(), (Integer)this.mSpinnerDisconnectDelay.getValue());
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void buttonAddEmailActionPerformed(ActionEvent e) {
        if (Utils.isEmptyString((String)this.mTextFieldEmailAddress.getText())) {
            JOptionPane.showMessageDialog(this, "The recipient's email address is required", "Input Error", 2);
        } else {
            DefaultListModel vModel = (DefaultListModel)this.mListReceiverEmailAddresses.getModel();
            for (int i = 0; i < vModel.getSize(); ++i) {
                if (!vModel.get(i).toString().toUpperCase().equals(this.mTextFieldEmailAddress.getText().toUpperCase())) continue;
                JOptionPane.showMessageDialog(this, "The recipient's email address is already in the list below", "Input Error", 2);
                return;
            }
            vModel.addElement(this.mTextFieldEmailAddress.getText());
            this.mTextFieldEmailAddress.setText("");
        }
    }

    private void buttonRemoveActionPerformed(ActionEvent e) {
        if (this.mListReceiverEmailAddresses.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "The email address to delete must be selected from the list below", "Input Error", 2);
        } else {
            DefaultListModel vModel = (DefaultListModel)this.mListReceiverEmailAddresses.getModel();
            vModel.remove(this.mListReceiverEmailAddresses.getSelectedIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buttonTestEmailsActionPerformed(ActionEvent e) {
        if (Utils.isEmptyString((String)this.mConfiguration.getSMTPIP())) {
            JOptionPane.showMessageDialog(this, "The SMTP settings for email has not yet been defined.  Go to File | Preferences | Notifications.", "Configuration Missing", 2);
        } else if (((DefaultListModel)this.mListReceiverEmailAddresses.getModel()).size() <= 0) {
            JOptionPane.showMessageDialog(this, "No recipients were defined.", "Configuration Missing", 2);
            this.mTabbedPaneNotificationSettings.setSelectedComponent(this.mContentPanelNotificationDetails);
        } else {
            try {
                GUIUtils.showBusyCursor(this);
                try {
                    NotificationDetails vNotificationDetails = this.buildNotificationDetails();
                    new AquatronicaInterface(this.mConfiguration).sendTestEmail(vNotificationDetails);
                }
                finally {
                    GUIUtils.showNormalCursor(this);
                }
                JOptionPane.showMessageDialog(this, "The test email has been successfully sent to your designated recipient address(es).", "Notice", 1);
            }
            catch (Exception exc) {
                BugManager.handleError(this, exc);
            }
        }
    }

    private void radioButtonDailyItemStateChanged(ItemEvent e) {
        this.toggleSpinnerStatus(e.getStateChange() == 1);
    }

    private void toggleSpinnerStatus(boolean pEnabled) {
        this.mLabelAtWhatTime.setEnabled(pEnabled);
        this.mSpinnerTimeHour.setEnabled(pEnabled);
        this.mSpinnerTimeMinute.setEnabled(pEnabled);
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        this.mCancelButton = new JButton();
        this.mTabbedPaneNotificationSettings = new JTabbedPane();
        this.mContentPanelPreferences2 = new JPanel();
        this.mSeparator7 = compFactory.createSeparator("Alert Notifications");
        this.mCheckBoxEnableAlarmNotification = new JCheckBox();
        this.mCheckBoxEnableAlarmOnMissingDevicesNotification = new JCheckBox();
        this.mCheckBoxEnableAlarmOnAquaStatDisconnect = new JCheckBox();
        this.mCheckBoxEnableSummaryNotifications = new JCheckBox();
        this.mContentPanelSensors = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Select Sensors To Monitor For Alarm Conditions");
        this.mScrollPane1 = new JScrollPane();
        this.mTableSelectedSensors = new JTable();
        this.mContentPanelNotificationDetails = new JPanel();
        this.mSeparator2 = compFactory.createSeparator("Specify The Notification Details");
        this.mLabel1 = new JLabel();
        this.mTextFieldEmailAddress = new JTextField();
        this.mButtonAddEmail = new JButton();
        this.mButtonRemove = new JButton();
        this.mScrollPane2 = new JScrollPane();
        this.mListReceiverEmailAddresses = new JList(new DefaultListModel());
        this.mContentPanelAlertTemplates = new JPanel();
        this.mSeparator3 = compFactory.createSeparator("Specify The Alert Templates");
        this.mTitle1 = compFactory.createTitle("New Alarm Condition Template");
        this.mLabel2 = new JLabel();
        this.mTextFieldNewAlertSubject = new JTextField();
        this.mLabel11 = new JLabel();
        this.mLabel4 = new JLabel();
        this.mScrollPane3 = new JScrollPane();
        this.mTextAreaNewAlertBody = new JTextArea();
        this.mTitle2 = compFactory.createTitle("Alarm Cleared Template");
        this.mLabel5 = new JLabel();
        this.mTextFieldAlertClearedSubject = new JTextField();
        this.mLabel6 = new JLabel();
        this.mScrollPane4 = new JScrollPane();
        this.mTextAreaAlertClearedBody = new JTextArea();
        this.mContentPanelSummaryUpdates = new JPanel();
        this.mSeparator4 = compFactory.createSeparator("Specify The Summary Status Notification Details");
        this.mLabel7 = new JLabel();
        this.mTextFieldSummaryStatusSubject = new JTextField();
        this.mLabel3 = new JLabel();
        this.mRadioButtonHourly = new JRadioButton();
        this.mPanel1 = new JPanel();
        this.mRadioButtonDaily = new JRadioButton();
        this.mLabelAtWhatTime = new JLabel();
        this.mSpinnerTimeHour = new JSpinner();
        this.mLabel9 = new JLabel();
        this.mSpinnerTimeMinute = new JSpinner();
        this.mSeparator5 = compFactory.createSeparator("Test Email");
        this.mButtonTestEmails = new JButton();
        this.mContentPanelPreferences = new JPanel();
        this.mSeparator6 = compFactory.createSeparator("Alert Notification Preferences");
        this.mLabel8 = new JLabel();
        this.mPanel2 = new JPanel();
        this.mSpinnerDeadTime = new JSpinner();
        this.mLabel10 = new JLabel();
        this.mLabel12 = new JLabel();
        this.mPanel3 = new JPanel();
        this.mSpinnerDisconnectDelay = new JSpinner();
        this.mLabel13 = new JLabel();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Define Alerts");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("Save");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlertForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlertForm.this.cancelButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mCancelButton, cc.xy(4, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        this.mContentPanelPreferences2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)100), 0.5), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 0.5)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mContentPanelPreferences2.add((Component)this.mSeparator7, cc.xywh(1, 1, 5, 1));
        this.mCheckBoxEnableAlarmNotification.setText("Enable Alarm Notification");
        this.mContentPanelPreferences2.add((Component)this.mCheckBoxEnableAlarmNotification, cc.xy(3, 3));
        this.mCheckBoxEnableAlarmOnMissingDevicesNotification.setText("Enable Alarm On Disconnected Devices Notification");
        this.mContentPanelPreferences2.add((Component)this.mCheckBoxEnableAlarmOnMissingDevicesNotification, cc.xy(3, 5));
        this.mCheckBoxEnableAlarmOnAquaStatDisconnect.setText("Enable Alarm On AquaStats Disconnect from Controller");
        this.mContentPanelPreferences2.add((Component)this.mCheckBoxEnableAlarmOnAquaStatDisconnect, cc.xy(3, 7));
        this.mCheckBoxEnableSummaryNotifications.setText("Enable Summary Notifications");
        this.mContentPanelPreferences2.add((Component)this.mCheckBoxEnableSummaryNotifications, cc.xy(3, 9));
        this.mTabbedPaneNotificationSettings.addTab("0: Start", this.mContentPanelPreferences2);
        this.mContentPanelSensors.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanelSensors.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GROWING_BUTTON_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.GROWING_BUTTON_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 0.0)}));
        ((FormLayout)this.mContentPanelSensors.getLayout()).setColumnGroups((int[][])new int[][]{{1, 3}});
        this.mContentPanelSensors.add((Component)this.mSeparator1, cc.xywh(1, 1, 3, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mTableSelectedSensors.setModel(new DefaultTableModel(new Object[0][], new String[]{"-", "Sensor", "Monitor"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, String.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        TableColumnModel cm = this.mTableSelectedSensors.getColumnModel();
        cm.getColumn(1).setPreferredWidth(75);
        cm.getColumn(2).setMinWidth(70);
        cm.getColumn(2).setMaxWidth(70);
        cm.getColumn(2).setPreferredWidth(70);
        this.mTableSelectedSensors.setShowHorizontalLines(false);
        this.mTableSelectedSensors.setShowVerticalLines(false);
        this.mScrollPane1.setViewportView(this.mTableSelectedSensors);
        this.mContentPanelSensors.add((Component)this.mScrollPane1, cc.xywh(1, 3, 3, 1));
        this.mTabbedPaneNotificationSettings.addTab("1: Sensors", this.mContentPanelSensors);
        this.mContentPanelNotificationDetails.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanelNotificationDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)70), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        this.mContentPanelNotificationDetails.add((Component)this.mSeparator2, cc.xywh(1, 1, 5, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mLabel1.setText("Recipient's Email Address:");
        this.mLabel1.setFont(this.mLabel1.getFont().deriveFont(this.mLabel1.getFont().getStyle() | 1));
        this.mContentPanelNotificationDetails.add((Component)this.mLabel1, cc.xywh(1, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mContentPanelNotificationDetails.add((Component)this.mTextFieldEmailAddress, cc.xy(3, 3));
        this.mButtonAddEmail.setText("Add Address");
        this.mButtonAddEmail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlertForm.this.buttonAddEmailActionPerformed(e);
            }
        });
        this.mContentPanelNotificationDetails.add((Component)this.mButtonAddEmail, cc.xywh(1, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mButtonRemove.setText("Remove Address");
        this.mButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlertForm.this.buttonRemoveActionPerformed(e);
            }
        });
        this.mContentPanelNotificationDetails.add((Component)this.mButtonRemove, cc.xywh(3, 5, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mListReceiverEmailAddresses.setSelectionMode(0);
        this.mScrollPane2.setViewportView(this.mListReceiverEmailAddresses);
        this.mContentPanelNotificationDetails.add((Component)this.mScrollPane2, cc.xywh(1, 7, 5, 1));
        this.mTabbedPaneNotificationSettings.addTab("2: Notification Details", this.mContentPanelNotificationDetails);
        this.mContentPanelAlertTemplates.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanelAlertTemplates.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)70), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)60), 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mContentPanelAlertTemplates.add((Component)this.mSeparator3, cc.xywh(1, 1, 5, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mContentPanelAlertTemplates.add((Component)this.mTitle1, cc.xywh(1, 3, 5, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mLabel2.setText("Subject:");
        this.mLabel2.setFont(this.mLabel2.getFont().deriveFont(this.mLabel2.getFont().getStyle() | 1));
        this.mContentPanelAlertTemplates.add((Component)this.mLabel2, cc.xywh(1, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mTextFieldNewAlertSubject.setText("A new alarm was raised for your aquarium");
        this.mContentPanelAlertTemplates.add((Component)this.mTextFieldNewAlertSubject, cc.xy(3, 5));
        this.mLabel11.setText("<html><div style='font-size: 8px'>The following variables can be used:<br><br>${DATESTRING}<br><br>Where DATESTRING is a combination of<br>yyyy for year,<br>MM for month,<br>dd for day,<br>HH for hour,<br>mm for minute.<br>eg. ${yyyy-MM-dd HH:mm} becomes 2007-12-22 14:03</div>");
        this.mContentPanelAlertTemplates.add((Component)this.mLabel11, cc.xywh(5, 5, 1, 9, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.mLabel4.setText("Message Body:");
        this.mLabel4.setFont(this.mLabel4.getFont().deriveFont(this.mLabel4.getFont().getStyle() | 1));
        this.mContentPanelAlertTemplates.add((Component)this.mLabel4, cc.xywh(1, 7, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mTextAreaNewAlertBody.setRows(5);
        this.mTextAreaNewAlertBody.setLineWrap(true);
        this.mTextAreaNewAlertBody.setWrapStyleWord(true);
        this.mTextAreaNewAlertBody.setText("The following sensor is currently in alarm: ");
        this.mTextAreaNewAlertBody.setFont(new Font("Helvetica", 0, 11));
        this.mScrollPane3.setViewportView(this.mTextAreaNewAlertBody);
        this.mContentPanelAlertTemplates.add((Component)this.mScrollPane3, cc.xy(3, 7));
        this.mContentPanelAlertTemplates.add((Component)this.mTitle2, cc.xywh(3, 9, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mLabel5.setText("Subject:");
        this.mLabel5.setFont(this.mLabel5.getFont().deriveFont(this.mLabel5.getFont().getStyle() | 1));
        this.mContentPanelAlertTemplates.add((Component)this.mLabel5, cc.xywh(1, 11, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mTextFieldAlertClearedSubject.setText("The alarm previously raised for your aquarium has been cleared");
        this.mContentPanelAlertTemplates.add((Component)this.mTextFieldAlertClearedSubject, cc.xy(3, 11));
        this.mLabel6.setText("Message Body:");
        this.mLabel6.setFont(this.mLabel6.getFont().deriveFont(this.mLabel6.getFont().getStyle() | 1));
        this.mContentPanelAlertTemplates.add((Component)this.mLabel6, cc.xywh(1, 13, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mTextAreaAlertClearedBody.setRows(5);
        this.mTextAreaAlertClearedBody.setLineWrap(true);
        this.mTextAreaAlertClearedBody.setWrapStyleWord(true);
        this.mTextAreaAlertClearedBody.setFont(new Font("Helvetica", 0, 11));
        this.mTextAreaAlertClearedBody.setText("The following sensor is NOT in alarm anymore: ");
        this.mScrollPane4.setViewportView(this.mTextAreaAlertClearedBody);
        this.mContentPanelAlertTemplates.add((Component)this.mScrollPane4, cc.xy(3, 13));
        this.mTabbedPaneNotificationSettings.addTab("3: Alert Templates", this.mContentPanelAlertTemplates);
        this.mContentPanelSummaryUpdates.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanelSummaryUpdates.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)60), 0.5), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 0.5)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mContentPanelSummaryUpdates.add((Component)this.mSeparator4, cc.xywh(1, 1, 5, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mLabel7.setText("Summary Message Subject:");
        this.mLabel7.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanelSummaryUpdates.add((Component)this.mLabel7, cc.xywh(1, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mTextFieldSummaryStatusSubject.setText("Summary of all aquatronica peripherals");
        this.mContentPanelSummaryUpdates.add((Component)this.mTextFieldSummaryStatusSubject, cc.xy(3, 3));
        this.mLabel3.setText("Frequency Of Notification:");
        this.mLabel3.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanelSummaryUpdates.add((Component)this.mLabel3, cc.xywh(1, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mRadioButtonHourly.setText("Hourly");
        this.mContentPanelSummaryUpdates.add((Component)this.mRadioButtonHourly, cc.xywh(3, 5, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.MIN_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default")));
        this.mRadioButtonDaily.setText("Daily");
        this.mRadioButtonDaily.setSelected(true);
        this.mRadioButtonDaily.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AlertForm.this.radioButtonDailyItemStateChanged(e);
            }
        });
        this.mPanel1.add((Component)this.mRadioButtonDaily, cc.xy(1, 1));
        this.mLabelAtWhatTime.setText("At what time?");
        this.mPanel1.add((Component)this.mLabelAtWhatTime, cc.xywh(3, 1, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mSpinnerTimeHour.setModel(new SpinnerNumberModel(20, 0, 23, 1));
        this.mPanel1.add((Component)this.mSpinnerTimeHour, cc.xy(5, 1));
        this.mLabel9.setText(":");
        this.mLabel9.setHorizontalAlignment(0);
        this.mPanel1.add((Component)this.mLabel9, cc.xywh(7, 1, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mSpinnerTimeMinute.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.mPanel1.add((Component)this.mSpinnerTimeMinute, cc.xy(9, 1));
        this.mContentPanelSummaryUpdates.add((Component)this.mPanel1, cc.xy(3, 7));
        this.mContentPanelSummaryUpdates.add((Component)this.mSeparator5, cc.xywh(1, 11, 5, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mButtonTestEmails.setText("Send Test Email(s)");
        this.mButtonTestEmails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlertForm.this.buttonTestEmailsActionPerformed(e);
            }
        });
        this.mContentPanelSummaryUpdates.add((Component)this.mButtonTestEmails, cc.xywh(1, 15, 5, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mTabbedPaneNotificationSettings.addTab("4: Summary Updates", this.mContentPanelSummaryUpdates);
        this.mContentPanelPreferences.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)100), 0.5), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.30000000000000004)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mContentPanelPreferences.add((Component)this.mSeparator6, cc.xywh(1, 1, 3, 1));
        this.mLabel8.setText("Dead time between alarm notifications:");
        this.mLabel8.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanelPreferences.add((Component)this.mLabel8, cc.xy(1, 3));
        this.mPanel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.mSpinnerDeadTime.setMinimumSize(new Dimension(100, 26));
        this.mSpinnerDeadTime.setPreferredSize(new Dimension(100, 26));
        this.mPanel2.add((Component)this.mSpinnerDeadTime, cc.xy(1, 1));
        this.mLabel10.setText("seconds");
        this.mLabel10.setFont(new Font("Helvetica", 2, 13));
        this.mPanel2.add((Component)this.mLabel10, cc.xy(3, 1));
        this.mContentPanelPreferences.add((Component)this.mPanel2, cc.xy(3, 3));
        this.mLabel12.setText("Delay after disconnect from controller before raising alert:");
        this.mLabel12.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanelPreferences.add((Component)this.mLabel12, cc.xy(1, 5));
        this.mPanel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.mSpinnerDisconnectDelay.setMinimumSize(new Dimension(100, 26));
        this.mSpinnerDisconnectDelay.setPreferredSize(new Dimension(100, 26));
        this.mPanel3.add((Component)this.mSpinnerDisconnectDelay, cc.xy(1, 1));
        this.mLabel13.setText("seconds");
        this.mLabel13.setFont(new Font("Helvetica", 2, 13));
        this.mPanel3.add((Component)this.mLabel13, cc.xy(3, 1));
        this.mContentPanelPreferences.add((Component)this.mPanel3, cc.xy(3, 5));
        this.mTabbedPaneNotificationSettings.addTab("Preferences", this.mContentPanelPreferences);
        this.mDialogPane.add((Component)this.mTabbedPaneNotificationSettings, "Center");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(860, 400);
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.mRadioButtonHourly);
        buttonGroup1.add(this.mRadioButtonDaily);
    }
}

