/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.za.pwnconsulting.javaconfig.utils.StringUtils;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.BrowserLauncher;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;
import za.co.pwnconsulting.aquatronica.helpers.DBHelper;
import za.co.pwnconsulting.aquatronica.helpers.GUIUtils;

public class AboutForm
extends JDialog {
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JLabel mLabel1;
    private JComponent mLabel2;
    private JPanel mPanel1;
    private JLabel mLabel3;
    private JLabel mLabelVersion;
    private JLabel mLabel7;
    private JLabel mLabel8;
    private JLabel mLabel9;
    private JLabel mLabelWebsite;
    private JLabel mLabel11;
    private JLabel mLabelEmail;
    private JLabel mLabel10;
    private JLabel mLabelDBPatchLevel;
    private JLabel mLabel12;
    private JLabel mLabelDBSize;
    private JLabel mLabel14;
    private JLabel mLabelDBTypeAndName;
    private JLabel mLabel13;
    private JPanel mButtonBar;
    private JButton mOkButton;

    public AboutForm(Frame owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents();
        this.mLabelVersion.setText("1.2.5a");
        this.mLabelDBPatchLevel.setText(Integer.toString(pConfiguration.isEmbedded() ? pConfiguration.getDBPatchLevelEmbedded() : pConfiguration.getDBPatchLevelRemote()));
        long vSize = DBHelper.getInstance().getDBSize();
        this.mLabelDBSize.setText(vSize <= 0L ? "Unknown" : StringUtils.formatDecimal((Double)((double)vSize / 1024.0 / 1024.0), (String)"###,###.##") + " MB");
        this.mLabelDBTypeAndName.setText(pConfiguration.isEmbedded() ? "Embedded Derby: aquatronica" : "Remote PostgreSQL: " + pConfiguration.getPostgreSQLDBName());
        this.getRootPane().setDefaultButton(this.mOkButton);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void labelWebsiteMouseClicked(MouseEvent e) {
        try {
            BrowserLauncher.openURL(this.mLabelWebsite.getText());
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void labelEmailMouseClicked(MouseEvent e) {
        try {
            BrowserLauncher.openURL("mailto:" + this.mLabelEmail.getText());
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void labelWebsiteMouseEntered(MouseEvent e) {
        GUIUtils.showHandCursor(this);
    }

    private void labelEmailMouseEntered(MouseEvent e) {
        GUIUtils.showHandCursor(this);
    }

    private void labelWebsiteMouseExited(MouseEvent e) {
        GUIUtils.showNormalCursor(this);
    }

    private void labelEmailMouseExited(MouseEvent e) {
        GUIUtils.showNormalCursor(this);
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mLabel1 = new JLabel();
        this.mLabel2 = compFactory.createSeparator("Aquatronica Statistical Data Analysis Toolkit");
        this.mPanel1 = new JPanel();
        this.mLabel3 = new JLabel();
        this.mLabelVersion = new JLabel();
        this.mLabel7 = new JLabel();
        this.mLabel8 = new JLabel();
        this.mLabel9 = new JLabel();
        this.mLabelWebsite = new JLabel();
        this.mLabel11 = new JLabel();
        this.mLabelEmail = new JLabel();
        this.mLabel10 = new JLabel();
        this.mLabelDBPatchLevel = new JLabel();
        this.mLabel12 = new JLabel();
        this.mLabelDBSize = new JLabel();
        this.mLabel14 = new JLabel();
        this.mLabelDBTypeAndName = new JLabel();
        this.mLabel13 = new JLabel();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("About");
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec("max(default;20dlu)")}));
        this.mLabel1.setIcon(new ImageIcon(this.getClass().getResource("/images/aquastats_logo.png")));
        this.mContentPanel.add((Component)this.mLabel1, cc.xywh(1, 1, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mContentPanel.add((Component)this.mLabel2, cc.xy(1, 3));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mLabel3.setText("Version:");
        this.mLabel3.setForeground(new Color(0, 128, 128));
        this.mLabel3.setFont(this.mLabel3.getFont().deriveFont(this.mLabel3.getFont().getStyle() | 1));
        this.mPanel1.add((Component)this.mLabel3, cc.xy(1, 1));
        this.mLabelVersion.setText("1.0.2");
        this.mPanel1.add((Component)this.mLabelVersion, cc.xy(3, 1));
        this.mLabel7.setText("Author:");
        this.mLabel7.setForeground(new Color(0, 128, 128));
        this.mLabel7.setFont(this.mLabel7.getFont().deriveFont(this.mLabel7.getFont().getStyle() | 1));
        this.mPanel1.add((Component)this.mLabel7, cc.xy(1, 3));
        this.mLabel8.setText("Waldo Nell");
        this.mPanel1.add((Component)this.mLabel8, cc.xy(3, 3));
        this.mLabel9.setText("Website:");
        this.mLabel9.setForeground(new Color(0, 128, 128));
        this.mLabel9.setFont(this.mLabel9.getFont().deriveFont(this.mLabel9.getFont().getStyle() | 1));
        this.mPanel1.add((Component)this.mLabel9, cc.xy(1, 5));
        this.mLabelWebsite.setText("http://reef.gamma.za.net/");
        this.mLabelWebsite.setForeground(new Color(97, 194, 162));
        this.mLabelWebsite.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AboutForm.this.labelWebsiteMouseClicked(e);
            }

            public void mouseExited(MouseEvent e) {
                AboutForm.this.labelWebsiteMouseExited(e);
            }

            public void mouseEntered(MouseEvent e) {
                AboutForm.this.labelWebsiteMouseEntered(e);
            }
        });
        this.mPanel1.add((Component)this.mLabelWebsite, cc.xy(3, 5));
        this.mLabel11.setText("Support Email:");
        this.mLabel11.setFont(this.mLabel11.getFont().deriveFont(this.mLabel11.getFont().getStyle() | 1));
        this.mLabel11.setForeground(new Color(0, 128, 128));
        this.mPanel1.add((Component)this.mLabel11, cc.xy(1, 7));
        this.mLabelEmail.setText("techsupport@pwnconsulting.co.za");
        this.mLabelEmail.setForeground(new Color(97, 194, 162));
        this.mLabelEmail.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AboutForm.this.labelEmailMouseClicked(e);
            }

            public void mouseExited(MouseEvent e) {
                AboutForm.this.labelEmailMouseExited(e);
            }

            public void mouseEntered(MouseEvent e) {
                AboutForm.this.labelEmailMouseEntered(e);
            }
        });
        this.mPanel1.add((Component)this.mLabelEmail, cc.xy(3, 7));
        this.mLabel10.setText("DB Patch Level");
        this.mLabel10.setForeground(new Color(0, 128, 128));
        this.mLabel10.setFont(this.mLabel10.getFont().deriveFont(this.mLabel10.getFont().getStyle() | 1));
        this.mPanel1.add((Component)this.mLabel10, cc.xy(1, 9));
        this.mLabelDBPatchLevel.setText("0");
        this.mPanel1.add((Component)this.mLabelDBPatchLevel, cc.xy(3, 9));
        this.mLabel12.setText("DB Size:");
        this.mLabel12.setForeground(new Color(0, 128, 128));
        this.mLabel12.setFont(this.mLabel12.getFont().deriveFont(this.mLabel12.getFont().getStyle() | 1));
        this.mPanel1.add((Component)this.mLabel12, cc.xy(1, 11));
        this.mLabelDBSize.setText("text");
        this.mPanel1.add((Component)this.mLabelDBSize, cc.xy(3, 11));
        this.mLabel14.setText("DB Type & Name:");
        this.mLabel14.setForeground(new Color(0, 128, 128));
        this.mLabel14.setFont(this.mLabel14.getFont().deriveFont(this.mLabel14.getFont().getStyle() | 1));
        this.mPanel1.add((Component)this.mLabel14, cc.xy(1, 13));
        this.mLabelDBTypeAndName.setText("text");
        this.mPanel1.add((Component)this.mLabelDBTypeAndName, cc.xy(3, 13));
        this.mContentPanel.add((Component)this.mPanel1, cc.xy(1, 5));
        this.mLabel13.setText("Copyright (c) 2007 by PWN Consulting.");
        this.mLabel13.setFont(this.mLabel13.getFont().deriveFont((float)this.mLabel13.getFont().getSize() - 2.0f));
        this.mLabel13.setIcon(new ImageIcon(this.getClass().getResource("/images/pwnlogo_small.png")));
        this.mContentPanel.add((Component)this.mLabel13, cc.xy(1, 9));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(535, 390);
        this.setLocationRelativeTo(this.getOwner());
    }
}

