/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import net.za.pwnconsulting.javaconfig.utils.StringUtils;
import net.za.pwnconsulting.javaconfig.utils.xml.AttributeList;
import net.za.pwnconsulting.javaconfig.utils.xml.InvalidStateException;

public class HugeXMLWriter {
    private boolean mPrettyPrint = false;
    private int mNestedLevel = 0;
    private PrintWriter mOutputFile;
    private File mOutputFilePath;
    private static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String XML_DOCTYPE = "<!DOCTYPE root_element SYSTEM \"dtd_name\" >";
    private String mRootElement = null;
    private int mState = 0;
    private int mIndentStep = 2;
    private boolean mTextAdded = false;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_STARTED_NO_ROOT = 1;
    private static final int STATE_ENDED_DOCUMENT = 2;
    private static final int STATE_STARTED_HAVE_ROOT = 3;
    private static final int STATE_STARTED_ELEMENT = 4;
    private static final int STATE_ENDED_ELEMENT = 5;

    public void startDocument(File pOutputFile) throws FileNotFoundException {
        this.mOutputFile = new PrintWriter(new FileOutputStream(pOutputFile));
        this.mOutputFile.println(XML_HEAD);
        this.mOutputFilePath = pOutputFile;
        this.mState = 1;
    }

    public void setRootElement(String pRootElement) throws InvalidStateException {
        if (this.mState != 1) {
            throw new InvalidStateException("Invalid state - the document has not yet been started");
        }
        this.mRootElement = pRootElement;
        this.mState = 3;
    }

    public void setDOCTYPE(String pDTDName) throws InvalidStateException {
        if (this.mState != 3) {
            throw new InvalidStateException("Invalid state - we do not yet have the root element");
        }
        String vDTD = StringUtils.replaceAll(StringUtils.replaceAll(XML_DOCTYPE, "root_element", this.mRootElement), "dtd_name", pDTDName);
        this.mOutputFile.println(vDTD);
    }

    public void startElement(String pElementName, AttributeList pAttribList) throws InvalidStateException {
        if (this.mState < 3) {
            throw new InvalidStateException("Invalid state - we do not yet have the root element");
        }
        String vLine = "<" + pElementName + " ";
        vLine = vLine + this.addAttributes(pAttribList);
        vLine = vLine + " >";
        this.mOutputFile.print(this.getPadding() + vLine);
        if (!this.mTextAdded) {
            this.mOutputFile.println();
        }
        this.mTextAdded = false;
        this.mState = 4;
        ++this.mNestedLevel;
    }

    public void addTextToElement(String pText) throws InvalidStateException {
        if (this.mState != 4) {
            throw new InvalidStateException("Invalid state - no element had been started yet");
        }
        this.mOutputFile.print(this.getPadding() + this.escapeXMLValue(pText, false));
        this.mTextAdded = true;
    }

    public void addCDataTextToElement(String pText) throws InvalidStateException {
        if (this.mState != 4) {
            throw new InvalidStateException("Invalid state - no element had been started yet");
        }
        this.mOutputFile.print(this.getPadding() + "<![CDATA[" + pText + "]]>");
        this.mTextAdded = true;
    }

    public void endElement(String pElementName) throws InvalidStateException {
        if (this.mState != 4 && this.mState != 5) {
            throw new InvalidStateException("Invalid state - no element had been started yet");
        }
        this.mOutputFile.println(this.getPadding() + "</" + pElementName + ">");
        this.mState = 5;
        --this.mNestedLevel;
        this.mTextAdded = false;
    }

    public void writeEmptyElement(String pElementName, AttributeList pAttribList) throws InvalidStateException {
        if (this.mState < 3) {
            throw new InvalidStateException("Invalid state - we do not yet have the root element");
        }
        String vLine = "<" + pElementName + " ";
        vLine = vLine + this.addAttributes(pAttribList);
        vLine = vLine + " />";
        this.mOutputFile.println(this.getPadding() + vLine);
        this.mState = 5;
        this.mTextAdded = false;
    }

    public void endDocument() {
        this.mState = 2;
        this.mOutputFile.flush();
        this.mOutputFile.close();
    }

    public void setIndentStep(int pIndentStep) {
        this.mIndentStep = pIndentStep;
    }

    public void setPrettyPrint(boolean pPrettyPrint) {
        this.mPrettyPrint = pPrettyPrint;
    }

    public File getOutputFilePath() {
        return this.mOutputFilePath;
    }

    private String getPadding() {
        if (!this.mPrettyPrint) {
            return "";
        }
        StringBuffer vPadding = new StringBuffer();
        for (int i = 0; i < this.mNestedLevel; ++i) {
            for (int j = 0; j < this.mIndentStep; ++j) {
                vPadding.append(" ");
            }
        }
        return vPadding.toString();
    }

    private String addAttributes(AttributeList pAttribList) {
        StringBuffer vRes = new StringBuffer();
        if (pAttribList != null) {
            for (int i = 0; i < pAttribList.getAttributes().size(); ++i) {
                AttributeList.Attribute vAttrib = (AttributeList.Attribute)pAttribList.getAttributes().get(i);
                vRes.append(vAttrib.getName());
                vRes.append("=");
                vRes.append("\"").append(this.escapeXMLValue(vAttrib.getValue(), true)).append("\" ");
            }
        }
        return vRes.toString();
    }

    private String escapeXMLValue(String pValue, boolean pIsAttribute) {
        String vRes = StringUtils.replaceAll(pValue, "&", "&amp;");
        vRes = StringUtils.replaceAll(vRes, "<", "&lt;");
        vRes = StringUtils.replaceAll(vRes, ">", "&gt;");
        if (pIsAttribute) {
            vRes = StringUtils.replaceAll(vRes, "\"", "&quot;");
        }
        StringBuffer vFinal = new StringBuffer();
        for (int i = 0; i < vRes.length(); ++i) {
            if (vRes.charAt(i) > '\u007f') {
                vFinal.append("&#").append(Integer.toString(vRes.charAt(i))).append(";");
                continue;
            }
            vFinal.append(vRes.charAt(i));
        }
        return vFinal.toString();
    }
}

