/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.time;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.utils.time.CatchupThread;
import net.za.pwnconsulting.javaconfig.utils.time.CronTimer;
import net.za.pwnconsulting.javaconfig.utils.time.CronTimerTask;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabException;

class MonitorThread
extends Thread {
    private boolean mTerminated = false;
    private CronTimer mCronTimer;
    private Map mCatchupThreadList;
    private boolean mRunning = false;

    MonitorThread(CronTimer pCronTimer) {
        this.mCronTimer = pCronTimer;
        this.mCatchupThreadList = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.mRunning = true;
        try {
            MonitorThread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        BasicLogger.getBasicLogger().debug(this.mCronTimer.mLogger, LMS.OWNER_JAVACONFIG, "Running in background monitor thread...");
        try {
            while (!this.mTerminated) {
                GregorianCalendar vNow = new GregorianCalendar();
                List list = this.mCronTimer.mQueue;
                synchronized (list) {
                    for (int i = 0; i < this.mCronTimer.mQueue.size(); ++i) {
                        CronTimerTask vST = (CronTimerTask)this.mCronTimer.mQueue.get(i);
                        if (vST.getState() != 4 && (!vST.getNextScheduledDate().before(vNow) && !vST.getNextScheduledDate().equals(vNow) || vST.getState() != 1)) continue;
                        BasicLogger.getBasicLogger().debug(this.mCronTimer.mLogger, LMS.OWNER_JAVACONFIG, "Running task [" + vST.getClass().getName() + "]...");
                        this.executeTask(vST, vNow);
                    }
                }
                Thread.sleep(45000L);
            }
        }
        catch (Exception e) {
            String vMsg = "Background monitor thread got exception: " + e.getMessage() + ". Dying...";
            if (e instanceof InterruptedException) {
                BasicLogger.getBasicLogger().warn(this.mCronTimer.mLogger, LMS.OWNER_JAVACONFIG, vMsg);
            } else {
                BasicLogger.getBasicLogger().error(this.mCronTimer.mLogger, LMS.OWNER_JAVACONFIG, vMsg);
            }
            this.mTerminated = true;
            this.mCronTimer.onMonitorThreadDeath(e, vMsg);
        }
        try {
            this.mCronTimer.cancelAll();
        }
        catch (CrontabException e1) {
            BasicLogger.getBasicLogger().error(this.mCronTimer.mLogger, LMS.OWNER_JAVACONFIG, "Background monitor thread cannot cancel scheduled tasks: " + e1.getMessage());
        }
        this.mRunning = false;
    }

    private void executeTask(CronTimerTask pTask, Calendar pNow) throws CrontabException {
        Calendar vDate = null;
        if (pTask.getSchedulingType() == 1) {
            vDate = pNow;
        } else if (pTask.getSchedulingType() == 2) {
            vDate = pTask.getNextScheduledDate();
            vDate.add(12, 1);
        } else {
            throw new CrontabException("Scheduling type was not specified for timer task [" + pTask.getClass().getName() + "]");
        }
        pTask.setNextScheduledDate(pTask.getCrontabEntry().getNextScheduledDate(vDate));
        if (this.mCatchupThreadList.containsKey(pTask) && ((CatchupThread)this.mCatchupThreadList.get(pTask)).isTerminated()) {
            this.mCatchupThreadList.remove(pTask);
        }
        if ((pTask.getNextScheduledDate().before(pNow) || pTask.getNextScheduledDate().equals(vDate)) && pTask.getSchedulingType() == 2) {
            if (!this.mCatchupThreadList.containsKey(pTask)) {
                CatchupThread vCT = new CatchupThread(pTask, pNow);
                this.mCatchupThreadList.put(pTask, vCT);
                vCT.start();
            }
        } else {
            Thread vT = new Thread(pTask);
            vT.start();
        }
    }

    public void setTerminated(boolean pTerminated) {
        this.mTerminated = pTerminated;
        this.interrupt();
    }

    public boolean isTerminated() {
        return this.mTerminated;
    }

    public boolean isRunning() {
        return this.mRunning;
    }
}

