/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.time;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.javaconfig.support.ApplicationContext;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import net.za.pwnconsulting.javaconfig.utils.time.ClusterNodeCheckIndeterminateException;
import net.za.pwnconsulting.javaconfig.utils.time.CronTimerTask;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabException;

public abstract class HACronTimerTask
extends CronTimerTask {
    private static final String DB_KEY_STATE = "ha_cron_timer_task_state";
    private static final String DB_KEY_NEXTSCHEDULEDDATE = "ha_cron_timer_task_nextscheduleddate";
    private static final String DB_KEY_LASTRUNDATE = "ha_cron_timer_task_lastrundate";
    private static final String DB_DATE_PATTERN = "yyyy-MM-dd HH:mm";
    protected ApplicationContext mAC;
    private String mAppName;
    private String mDBPool;
    private boolean mUnassignedKeyState;
    private boolean mUnassignedKeyNextScheduledDate;
    private boolean mUnassignedKeyLastRunDate;
    private String mTableName;
    private String mValueFieldName;
    private String mKeyFieldName;
    protected String mTaskName;
    private String mCurrentTimer;
    private boolean mInitialized;
    private Comparable mOwnNodeName;
    public static final String DB_NAME_TABLE = "DBStateTableName";
    public static final String DB_NAME_VALUE_FIELD = "DBStateValueFieldName";
    public static final String DB_NAME_KEY_FIELD = "DBStateKeyFieldName";

    protected HACronTimerTask(String pDBPool, String pAppName, Comparable pOwnNodeName) throws CrontabException {
        if (pOwnNodeName == null) {
            throw new CrontabException("The own node name parameter is mandatory");
        }
        this.mAppName = pAppName;
        this.mDBPool = pDBPool;
        this.mInitialized = false;
        this.mOwnNodeName = pOwnNodeName;
    }

    public abstract List getClusterNodeNames() throws CrontabException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute() throws CrontabException {
        List vClusterNodeNames = this.getClusterNodeNames();
        if (vClusterNodeNames == null || vClusterNodeNames.size() <= 0) {
            this.safeExecute();
        } else {
            boolean vTaskRunning = false;
            for (int i = 0; i < vClusterNodeNames.size(); ++i) {
                Comparable vNodeName = (Comparable)vClusterNodeNames.get(i);
                if (vNodeName == null || vNodeName.compareTo(this.mOwnNodeName) == 0 || !this.isTaskRunningOnNode(vNodeName, this.mOwnNodeName, this.mTaskName)) continue;
                vTaskRunning = true;
                break;
            }
            if (!vTaskRunning) {
                this.mReallyRunning = true;
                try {
                    this.safeExecute();
                }
                finally {
                    this.mReallyRunning = false;
                }
            }
        }
    }

    protected abstract boolean isTaskRunningOnNode(Comparable var1, Comparable var2, String var3) throws CrontabException, ClusterNodeCheckIndeterminateException;

    protected abstract void safeExecute() throws CrontabException;

    public void init(String pTaskName) throws CrontabException {
        if (this.mInitialized) {
            throw new CrontabException("HACronTimerTask [" + pTaskName + "] object already initialized");
        }
        try {
            GregorianCalendar vDate;
            Map vRow;
            this.mTaskName = pTaskName;
            this.mCurrentTimer = "_" + pTaskName;
            this.mAC = new ApplicationContextLocator().getApplicationContext();
            DBLayer vDBLayer = this.mAC.getDBLayer(this.mAppName);
            this.mTableName = this.mAC.getBasicConfiguration(this.mAppName).getSettings().getParameterByName(DB_NAME_TABLE);
            this.mValueFieldName = this.mAC.getBasicConfiguration(this.mAppName).getSettings().getParameterByName(DB_NAME_VALUE_FIELD);
            this.mKeyFieldName = this.mAC.getBasicConfiguration(this.mAppName).getSettings().getParameterByName(DB_NAME_KEY_FIELD);
            List vRes = vDBLayer.queryDatabase("select " + this.mValueFieldName + " from " + this.mTableName + " where " + this.mKeyFieldName + " = ?", new Object[]{DB_KEY_STATE + this.mCurrentTimer}, this.mDBPool);
            if (vRes.size() > 1) {
                throw new CrontabException("Inconsistent state table in database [" + this.mDBPool + "], more than one value found for key [" + DB_KEY_STATE + "]");
            }
            if (vRes.size() == 1) {
                vRow = (Map)vRes.get(0);
                int vState = Utils.getInt((String)vRow.get(this.mValueFieldName));
                if (vState == 2) {
                    vState = 4;
                }
                super.setState(vState == 1 || vState == 3 ? 0 : vState);
                this.mUnassignedKeyState = false;
            } else {
                this.mUnassignedKeyState = true;
            }
            vRes = vDBLayer.queryDatabase("select " + this.mValueFieldName + " from " + this.mTableName + " where " + this.mKeyFieldName + " = ?", new Object[]{DB_KEY_NEXTSCHEDULEDDATE + this.mCurrentTimer}, this.mDBPool);
            if (vRes.size() > 1) {
                throw new CrontabException("Inconsistent state table in database [" + this.mDBPool + "], more than one value found for key [" + DB_KEY_NEXTSCHEDULEDDATE + "]");
            }
            if (vRes.size() == 1) {
                vRow = (Map)vRes.get(0);
                SimpleDateFormat vSDF = new SimpleDateFormat(DB_DATE_PATTERN);
                vDate = new GregorianCalendar();
                vDate.setTime(vSDF.parse((String)vRow.get(this.mValueFieldName)));
                super.setNextScheduledDate(vDate);
                this.mUnassignedKeyNextScheduledDate = false;
            } else {
                this.mUnassignedKeyNextScheduledDate = true;
            }
            vRes = vDBLayer.queryDatabase("select " + this.mValueFieldName + " from " + this.mTableName + " where " + this.mKeyFieldName + " = ?", new Object[]{DB_KEY_LASTRUNDATE + this.mCurrentTimer}, this.mDBPool);
            if (vRes.size() > 1) {
                throw new CrontabException("Inconsistent state table in database [" + this.mDBPool + "], more than one value found for key [" + DB_KEY_LASTRUNDATE + "]");
            }
            if (vRes.size() == 1) {
                vRow = (Map)vRes.get(0);
                SimpleDateFormat vSDF = new SimpleDateFormat(DB_DATE_PATTERN);
                vDate = new GregorianCalendar();
                vDate.setTime(vSDF.parse((String)vRow.get(this.mValueFieldName)));
                super.setLastRunDate(vDate);
                this.mUnassignedKeyLastRunDate = false;
            } else {
                this.mUnassignedKeyLastRunDate = true;
            }
            this.mInitialized = true;
        }
        catch (Exception e) {
            throw new CrontabException("Error instantiating the HACronTimerTask: " + e.getMessage(), e);
        }
    }

    protected final void setState(int pState) throws CrontabException {
        if (!this.mInitialized) {
            throw new CrontabException("HACronTimerTask not yet initialized");
        }
        try {
            super.setState(pState);
            DBLayer vDBLayer = this.mAC.getDBLayer(this.mAppName);
            String vSQL = "";
            ArrayList<String> vParams = new ArrayList<String>();
            if (this.mUnassignedKeyState) {
                vSQL = "insert into " + this.mTableName + " (" + this.mKeyFieldName + "," + this.mValueFieldName + ") values (?,?)";
                vParams.add(DB_KEY_STATE + this.mCurrentTimer);
                vParams.add(Integer.toString(pState));
            } else {
                vSQL = "update " + this.mTableName + " set " + this.mValueFieldName + " = ? where " + this.mKeyFieldName + " = ?";
                vParams.add(Integer.toString(pState));
                vParams.add(DB_KEY_STATE + this.mCurrentTimer);
            }
            vDBLayer.submitTransaction(new SQLStatement(vSQL, vParams.toArray(), false), this.mDBPool);
            this.mUnassignedKeyState = false;
        }
        catch (Exception e) {
            throw new CrontabException("Error saving the state: " + e.getMessage(), e);
        }
    }

    protected final void setNextScheduledDate(Calendar pNextScheduledDate) throws CrontabException {
        if (!this.mInitialized) {
            throw new CrontabException("HACronTimerTask not yet initialized");
        }
        try {
            super.setNextScheduledDate(pNextScheduledDate);
            DBLayer vDBLayer = this.mAC.getDBLayer(this.mAppName);
            String vSQL = "";
            ArrayList<String> vParams = new ArrayList<String>();
            if (this.mUnassignedKeyNextScheduledDate) {
                vSQL = "insert into " + this.mTableName + " (" + this.mKeyFieldName + "," + this.mValueFieldName + ") values (?,?)";
                vParams.add(DB_KEY_NEXTSCHEDULEDDATE + this.mCurrentTimer);
                SimpleDateFormat vSDF = new SimpleDateFormat(DB_DATE_PATTERN);
                vParams.add(vSDF.format(pNextScheduledDate.getTime()));
            } else {
                vSQL = "update " + this.mTableName + " set " + this.mValueFieldName + " = ? where " + this.mKeyFieldName + " = ?";
                SimpleDateFormat vSDF = new SimpleDateFormat(DB_DATE_PATTERN);
                vParams.add(vSDF.format(pNextScheduledDate.getTime()));
                vParams.add(DB_KEY_NEXTSCHEDULEDDATE + this.mCurrentTimer);
            }
            vDBLayer.submitTransaction(new SQLStatement(vSQL, vParams.toArray(), false), this.mDBPool);
            this.mUnassignedKeyNextScheduledDate = false;
        }
        catch (Exception e) {
            throw new CrontabException("Error saving the next scheduled date: " + e.getMessage(), e);
        }
    }

    protected final void setLastRunDate(Calendar pLastRunDate) throws CrontabException {
        if (!this.mInitialized) {
            throw new CrontabException("HACronTimerTask not yet initialized");
        }
        try {
            super.setLastRunDate(pLastRunDate);
            DBLayer vDBLayer = this.mAC.getDBLayer(this.mAppName);
            String vSQL = "";
            ArrayList<String> vParams = new ArrayList<String>();
            if (this.mUnassignedKeyLastRunDate) {
                vSQL = "insert into " + this.mTableName + " (" + this.mKeyFieldName + "," + this.mValueFieldName + ") values (?,?)";
                vParams.add(DB_KEY_LASTRUNDATE + this.mCurrentTimer);
                SimpleDateFormat vSDF = new SimpleDateFormat(DB_DATE_PATTERN);
                vParams.add(vSDF.format(pLastRunDate.getTime()));
            } else {
                vSQL = "update " + this.mTableName + " set " + this.mValueFieldName + " = ? where " + this.mKeyFieldName + " = ?";
                SimpleDateFormat vSDF = new SimpleDateFormat(DB_DATE_PATTERN);
                vParams.add(vSDF.format(pLastRunDate.getTime()));
                vParams.add(DB_KEY_LASTRUNDATE + this.mCurrentTimer);
            }
            vDBLayer.submitTransaction(new SQLStatement(vSQL, vParams.toArray(), false), this.mDBPool);
            this.mUnassignedKeyLastRunDate = false;
        }
        catch (Exception e) {
            throw new CrontabException("Error saving the last run date: " + e.getMessage(), e);
        }
    }
}

