/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.time;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabException;

class CrontabField {
    private List mValues = new ArrayList();

    public CrontabField(String pField, int pLowerBound, int pUpperBound) throws CrontabException {
        StringTokenizer vST;
        if (Utils.isEmptyString(pField)) {
            throw new CrontabException("Field was not specified");
        }
        if (pField.indexOf("*") != -1 && pField.indexOf("/") == -1) {
            this.fillArray(this.mValues, pLowerBound, pUpperBound, 1);
        } else if (pField.indexOf("*") != -1 && pField.indexOf("/") != -1) {
            vST = new StringTokenizer(pField, "/");
            String vEvery = null;
            if (vST.hasMoreTokens()) {
                vST.nextToken();
            }
            if (vST.hasMoreTokens()) {
                vEvery = vST.nextToken();
            }
            if (!Utils.isValidInteger(vEvery)) {
                throw new CrontabException("Invalid interval specifier in crontab entry [" + pField + "]");
            }
            this.fillArray(this.mValues, pLowerBound, pUpperBound, Utils.getInt(vEvery));
        } else if (pField.indexOf("-") == -1) {
            vST = new StringTokenizer(pField, ",");
            while (vST.hasMoreTokens()) {
                String vToken = vST.nextToken();
                if (vToken.indexOf("-") == -1) {
                    if (!Utils.isValidInteger(vToken)) {
                        throw new CrontabException("Invalid crontab entry [" + pField + "]");
                    }
                    this.fillArray(this.mValues, Integer.parseInt(vToken), Integer.parseInt(vToken), 1);
                    continue;
                }
                StringTokenizer vST2 = new StringTokenizer(vToken, "-");
                String vLowerBound = null;
                String vUpperBound = null;
                if (vST2.hasMoreTokens()) {
                    vLowerBound = vST2.nextToken();
                }
                if (vST2.hasMoreTokens()) {
                    vUpperBound = vST2.nextToken();
                }
                if (vLowerBound == null || vUpperBound == null) {
                    throw new CrontabException("Invalid crontab entry [" + pField + "]");
                }
                this.fillArray(this.mValues, Integer.parseInt(vLowerBound), Integer.parseInt(vUpperBound), 1);
            }
        }
        if (!this.mValues.isEmpty()) {
            Collections.sort(this.mValues);
            if ((Integer)Collections.min(this.mValues) < pLowerBound || (Integer)Collections.max(this.mValues) > pUpperBound) {
                throw new CrontabException("Lower or Upper bound violated");
            }
            ArrayList vValues = new ArrayList();
            for (int i = 0; i < this.mValues.size(); ++i) {
                if (vValues.contains(this.mValues.get(i))) continue;
                vValues.add(this.mValues.get(i));
            }
            this.mValues = vValues;
        }
    }

    int getNextHighestElement(int pValue) throws CrontabException {
        int i;
        for (i = 0; i < this.mValues.size(); ++i) {
            if ((Integer)this.mValues.get(i) < pValue) continue;
            return (Integer)this.mValues.get(i);
        }
        for (i = 0; i < this.mValues.size(); ++i) {
            if ((Integer)this.mValues.get(i) >= pValue) continue;
            return (Integer)this.mValues.get(i);
        }
        if (this.mValues.size() == 0) {
            return -1;
        }
        throw new CrontabException("Internal Error: Unexpected flow of control in code in method getNextHighestElement()");
    }

    public boolean isMatch(int pValue) {
        return this.mValues.contains(new Integer(pValue));
    }

    public boolean isEmpty() {
        return this.mValues.isEmpty();
    }

    private void fillArray(List pValues, int pLowerBound, int pUpperBound, int pInterval) throws CrontabException {
        if (pLowerBound > pUpperBound) {
            throw new CrontabException("LowerBound cannot be bigger than UpperBound");
        }
        for (int i = pLowerBound; i <= pUpperBound; i += pInterval) {
            pValues.add(new Integer(i));
        }
    }

    public String toString() {
        return this.mValues.toString();
    }
}

