/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.time;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabException;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabField;

public class CrontabEntry {
    private CrontabField mMinute;
    private CrontabField mHour;
    private CrontabField mDayOfMonth;
    private CrontabField mMonth;
    private CrontabField mDayOfWeek;
    private String mRawCrontabEntry;

    public CrontabEntry(String pCrontabEntry) throws CrontabException {
        this.mRawCrontabEntry = pCrontabEntry;
        StringTokenizer vST = new StringTokenizer(pCrontabEntry, " ");
        String vMinute = null;
        String vHour = null;
        String vDayOfMonth = null;
        String vMonth = null;
        String vDayOfWeek = null;
        if (vST.hasMoreTokens()) {
            vMinute = vST.nextToken();
        }
        if (vST.hasMoreTokens()) {
            vHour = vST.nextToken();
        }
        if (vST.hasMoreTokens()) {
            vDayOfMonth = vST.nextToken();
        }
        if (vST.hasMoreTokens()) {
            vMonth = vST.nextToken();
        }
        if (vST.hasMoreTokens()) {
            vDayOfWeek = vST.nextToken();
        }
        this.mMinute = new CrontabField(vMinute, 0, 59);
        this.mHour = new CrontabField(vHour, 0, 23);
        this.mDayOfMonth = vDayOfWeek != null && !vDayOfWeek.equals("*") && vDayOfMonth != null && vDayOfMonth.equals("*") ? new CrontabField("-", 0, 0) : new CrontabField(vDayOfMonth, 1, 31);
        this.mMonth = new CrontabField(vMonth, 1, 12);
        this.mDayOfWeek = vDayOfWeek != null && vDayOfWeek.equals("*") && vDayOfMonth != null && !vDayOfMonth.equals("*") ? new CrontabField("-", 0, 0) : new CrontabField(vDayOfWeek, 0, 6);
    }

    public boolean isMatch(Calendar pDate) throws CrontabException {
        if (pDate == null) {
            throw new CrontabException("Date was not specified");
        }
        int vMinute = pDate.get(12);
        int vHour = pDate.get(11);
        int vDayOfMonth = pDate.get(5);
        int vMonth = pDate.get(2) + 1;
        int vDayOfWeek = pDate.get(7) - 1;
        return this.mMinute.isMatch(vMinute) && this.mHour.isMatch(vHour) && (this.mMonth.isMatch(vMonth) || this.mMonth.isMatch(31) && pDate.getActualMaximum(5) == vMonth) && (this.mDayOfMonth.isMatch(vDayOfMonth) || this.mDayOfWeek.isMatch(vDayOfWeek));
    }

    public Calendar getNextScheduledDate(Calendar pNow) throws CrontabException {
        Calendar vDate = pNow;
        if (this.mMinute.isEmpty() && this.mHour.isEmpty() && this.mDayOfMonth.isEmpty() && this.mMonth.isEmpty() && this.mDayOfWeek.isEmpty()) {
            GregorianCalendar vC = new GregorianCalendar();
            vC.setTime(new Date(0x7FFFFFFFFFFFFFFEL));
            return vC;
        }
        int vMinute = vDate.get(12);
        int vHour = vDate.get(11);
        Calendar vNextScheduledDate = (Calendar)pNow.clone();
        vNextScheduledDate.set(14, 0);
        vNextScheduledDate.set(13, 0);
        vNextScheduledDate.set(12, this.mMinute.getNextHighestElement(vMinute));
        vNextScheduledDate.set(11, this.mHour.getNextHighestElement(vHour));
        if (vNextScheduledDate.get(11) < vHour || vNextScheduledDate.get(11) == vHour && vNextScheduledDate.get(12) < vMinute) {
            vNextScheduledDate.add(6, 1);
        }
        int vLoopCheck = 0;
        do {
            if (this.isMatch(vNextScheduledDate)) {
                return vNextScheduledDate;
            }
            vNextScheduledDate.add(6, 1);
        } while (++vLoopCheck <= 366);
        throw new CrontabException("Internal Error: Could not determine next scheduled date");
    }

    public String getRawCrontabEntry() {
        return this.mRawCrontabEntry;
    }
}

