/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.time;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabEntry;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabException;
import org.apache.log4j.Logger;

public abstract class CronTimerTask
implements Runnable {
    private CrontabEntry mCrontabEntry = null;
    private String mRawCrontabEntry;
    private int mState = 0;
    private Calendar mNextScheduledDate = null;
    private Calendar mLastRunDate;
    private int mSchedulingType;
    protected Map mErrorCount;
    private String mLastExecutionStatus;
    protected boolean mReallyRunning;
    protected boolean mTerminated = true;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());
    public static final int SCHEDULING_TYPE_CONSTANT_DATE = 1;
    public static final int SCHEDULING_TYPE_FIXED_RATE = 2;
    static final int VIRGIN = 0;
    static final int SCHEDULED = 1;
    static final int EXECUTING = 2;
    static final int CANCELLED = 3;
    static final int NEED_RESUMING = 4;

    protected CronTimerTask() throws CrontabException {
        this.mErrorCount = new HashMap();
        this.mLastExecutionStatus = "Not Yet Executed [" + new Date().toString() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            int vOriginalState = this.getState();
            if (vOriginalState == 4) {
                vOriginalState = 1;
            }
            this.setState(2);
            try {
                this.mErrorCount.clear();
                this.setTerminated(false);
                this.execute();
                if (this.mErrorCount.size() <= 0) {
                    this.mLastExecutionStatus = "Successful [" + new Date().toString() + "]";
                }
            }
            finally {
                this.setLastRunDate(new GregorianCalendar());
                this.setTerminated(true);
                this.setState(vOriginalState);
            }
        }
        catch (CrontabException e) {
            this.addException(e);
        }
    }

    protected abstract void execute() throws CrontabException;

    protected int getState() throws CrontabException {
        return this.mState;
    }

    protected void setState(int pState) throws CrontabException {
        this.mState = pState;
    }

    public Calendar getNextScheduledDate() throws CrontabException {
        return this.mNextScheduledDate;
    }

    protected void setNextScheduledDate(Calendar pNextScheduledDate) throws CrontabException {
        this.mNextScheduledDate = pNextScheduledDate;
    }

    public Calendar getLastRunDate() throws CrontabException {
        return this.mLastRunDate;
    }

    protected void setLastRunDate(Calendar pLastRunDate) throws CrontabException {
        this.mLastRunDate = pLastRunDate;
    }

    CrontabEntry getCrontabEntry() {
        return this.mCrontabEntry;
    }

    void setCrontabEntry(CrontabEntry pCrontabEntry) {
        this.mCrontabEntry = pCrontabEntry;
        this.mRawCrontabEntry = pCrontabEntry.getRawCrontabEntry();
    }

    public String getRawCrontabEntry() {
        return this.mRawCrontabEntry;
    }

    public void setRawCrontabEntry(String pRawCrontabEntry) {
        this.mRawCrontabEntry = pRawCrontabEntry;
    }

    public int getSchedulingType() {
        return this.mSchedulingType;
    }

    public void setSchedulingType(int pSchedulingType) {
        this.mSchedulingType = pSchedulingType;
    }

    protected void addException(Exception pException) {
        this.mErrorCount.put(new Integer(this.mErrorCount.size() + 1), pException);
        this.mLastExecutionStatus = "Failure [" + new Date().toString() + "]";
    }

    public void cancel() throws CrontabException {
        this.setState(3);
    }

    public boolean isTerminated() {
        return this.mTerminated;
    }

    protected void setTerminated(boolean pTerminated) throws CrontabException {
        this.mTerminated = pTerminated;
    }

    public final void requestTermination() {
        this.mTerminated = true;
    }

    public String getStateDescription() throws CrontabException {
        String vState = null;
        switch (this.getState()) {
            case 0: {
                vState = "Not yet scheduled";
                break;
            }
            case 1: {
                vState = "Scheduled";
                break;
            }
            case 2: {
                vState = "Executing";
                break;
            }
            case 3: {
                vState = "Cancelled";
                break;
            }
            default: {
                vState = "Unknown [" + this.getState() + "]";
            }
        }
        return vState;
    }

    public boolean isReallyRunning() {
        return this.mReallyRunning;
    }

    public Map getErrorMap() {
        return this.mErrorCount;
    }

    public String getLastExecutionStatus() {
        return this.mLastExecutionStatus;
    }
}

