/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.time;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.utils.time.CronTimerEventHook;
import net.za.pwnconsulting.javaconfig.utils.time.CronTimerTask;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabEntry;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabException;
import net.za.pwnconsulting.javaconfig.utils.time.MonitorThread;
import org.apache.log4j.Logger;

public class CronTimer {
    List mQueue;
    private List mEventHooks;
    private MonitorThread mBackgroundMonitor;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());

    public CronTimer() {
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Cron timer starting up...");
        this.mQueue = new ArrayList();
        this.mEventHooks = new ArrayList();
        this.mBackgroundMonitor = new MonitorThread(this);
        this.mBackgroundMonitor.start();
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Cron timer started up, waiting on background monitor to start up...");
        boolean vRunning = false;
        while (!vRunning) {
            try {
                Thread.sleep(10L);
                vRunning = this.mBackgroundMonitor.isRunning();
                if (!vRunning) continue;
                this.mBackgroundMonitor.interrupt();
            }
            catch (InterruptedException e) {
                this.mBackgroundMonitor.interrupt();
            }
        }
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Cron timer started up, Background monitor " + (this.mBackgroundMonitor.isRunning() ? "started up" : "dead"));
    }

    public void shutdown() {
        this.mBackgroundMonitor.setTerminated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(CronTimerTask pTask, String pCrontabEntry) throws CrontabException {
        List list = this.mQueue;
        synchronized (list) {
            if (pTask == null) {
                throw new CrontabException("Task was not specified");
            }
            if (pTask.getState() != 0 && pTask.getState() != 4) {
                throw new IllegalStateException("Task [" + pTask.getClass().getName() + "] is not in the correct state because it is not a virgin task and not in need for being resumed");
            }
            if (!this.mBackgroundMonitor.isRunning()) {
                throw new IllegalStateException("Cannot schedule a task if the background monitor thread is not running");
            }
            boolean vNeedResuming = pTask.getState() == 4;
            pTask.setCrontabEntry(new CrontabEntry(pCrontabEntry));
            pTask.setState(1);
            if (pTask.getNextScheduledDate() == null) {
                pTask.setNextScheduledDate(pTask.getCrontabEntry().getNextScheduledDate(new GregorianCalendar()));
            }
            this.mQueue.add(pTask);
            if (vNeedResuming) {
                this.executeImmediately(pTask);
            }
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Scheduled task [" + pTask.getClass().getName() + "] for execution on [" + pTask.getNextScheduledDate().getTime().toString() + "]");
        }
    }

    public void executeImmediately(CronTimerTask pTask) throws CrontabException {
        if (pTask.getState() == 2) {
            return;
        }
        Thread vT = new Thread(pTask);
        vT.start();
    }

    public void stopImmediately(CronTimerTask pTask) throws CrontabException {
        if (pTask.getState() != 2) {
            return;
        }
        pTask.requestTermination();
    }

    public boolean isTaskRunning(CronTimerTask pTask) throws CrontabException {
        return !pTask.isTerminated();
    }

    public boolean isTaskActuallyRunning(CronTimerTask pTask) throws CrontabException {
        return pTask.isReallyRunning();
    }

    public void cancel(CronTimerTask pTask) throws CrontabException {
        if (!this.mBackgroundMonitor.isRunning()) {
            throw new IllegalStateException("Cannot cancel a task if the background monitor thread is not running");
        }
        CronTimerTask vTask = (CronTimerTask)this.mQueue.get(this.mQueue.indexOf(pTask));
        if (vTask == null) {
            throw new CrontabException("Could not find the task specified");
        }
        vTask.cancel();
        this.mQueue.remove(vTask);
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Cancelled task [" + pTask.getClass().getName() + "]");
    }

    public void cancelAll() throws CrontabException {
        while (this.mQueue.size() > 0) {
            this.cancel((CronTimerTask)this.mQueue.get(this.mQueue.size() - 1));
        }
    }

    public boolean isAlive() {
        return this.mBackgroundMonitor.isAlive() && !this.mBackgroundMonitor.isTerminated();
    }

    public void addEventHook(CronTimerEventHook pCTEH) {
        this.mEventHooks.add(pCTEH);
    }

    void onMonitorThreadDeath(Exception pException, String pMessage) {
        for (int i = 0; i < this.mEventHooks.size(); ++i) {
            CronTimerEventHook vCTEH = (CronTimerEventHook)this.mEventHooks.get(i);
            vCTEH.onMonitorThreadDeath(pException, pMessage);
        }
    }
}

