/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.time;

import java.util.Calendar;
import java.util.GregorianCalendar;
import net.za.pwnconsulting.javaconfig.utils.time.CronTimerTask;
import net.za.pwnconsulting.javaconfig.utils.time.CrontabException;

class CatchupThread
extends Thread {
    private CronTimerTask mTask;
    private Calendar mNow;
    private boolean mTerminated;

    CatchupThread(CronTimerTask pTask, Calendar pNow) {
        this.mTask = pTask;
        this.mNow = pNow;
        this.mTerminated = false;
    }

    public void run() {
        Calendar vNextScheduledDate = new GregorianCalendar(9999, 1, 1);
        do {
            try {
                this.mTask.run();
                if (this.mTask.getState() != 1) break;
                if (this.mTask.getNextScheduledDate().before(this.mNow) || this.mTask.getNextScheduledDate().equals(this.mNow)) {
                    Calendar vDate = this.mTask.getNextScheduledDate();
                    vDate.add(12, 1);
                    this.mTask.setNextScheduledDate(this.mTask.getCrontabEntry().getNextScheduledDate(vDate));
                    continue;
                }
            }
            catch (CrontabException e) {
                this.mTask.addException(e);
            }
            try {
                vNextScheduledDate = this.mTask.getNextScheduledDate();
            }
            catch (CrontabException e) {
                this.mTask.addException(e);
                break;
            }
        } while (vNextScheduledDate.before(this.mNow) || vNextScheduledDate.equals(this.mNow));
        this.mTerminated = true;
    }

    boolean isTerminated() {
        return this.mTerminated;
    }
}

