/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.encryption;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.za.pwnconsulting.javaconfig.utils.encryption.Hash;
import net.za.pwnconsulting.javaconfig.utils.encryption.HashException;

public class SHAHash
implements Hash {
    public String makeHash(String pString) throws HashException {
        BigInteger vBi = new BigInteger(this.makeRawHash(pString.getBytes()));
        StringBuffer vRes = new StringBuffer(vBi.abs().toString(16).toUpperCase());
        while (vRes.length() < 40) {
            vRes.insert(0, "0");
        }
        return vRes.toString();
    }

    public byte[] makeRawHash(byte[] pString) throws HashException {
        try {
            MessageDigest vMd = MessageDigest.getInstance("SHA-1");
            vMd.update(pString);
            return vMd.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new HashException("Could not locate algorithm SHA-1: " + e.getMessage(), e);
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.print("Type in your password: ");
        InputStreamReader vISR = new InputStreamReader(System.in);
        BufferedReader vInput = new BufferedReader(vISR);
        String vRawPwd = vInput.readLine();
        if (vRawPwd == null) {
            System.out.println("Password was not given!");
            System.exit(1);
        }
        System.out.println("");
        System.out.println("SHA-1 Hash: " + new SHAHash().makeHash(vRawPwd));
    }
}

