/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils.encryption;

import net.za.pwnconsulting.javaconfig.beans.ReflectionBean;
import net.za.pwnconsulting.javaconfig.utils.encryption.Encryption;
import net.za.pwnconsulting.javaconfig.utils.encryption.EncryptionException;

public class RC4Encryption
implements Encryption,
ReflectionBean {
    private short[] mKey = new short[256];
    private short[] mOrgKey = new short[256];
    private String mName;

    public String encryptData(String pString) throws EncryptionException {
        if (pString == null) {
            throw new EncryptionException("No data specified for encryption");
        }
        this.reset();
        int i = 0;
        short j = 0;
        StringBuffer vResult = new StringBuffer();
        vResult.setLength(0);
        for (int k = 0; k < pString.length(); ++k) {
            i = (short)(i + 1 & 0xFF);
            j = (short)(j + this.mKey[i] & 0xFF);
            short t = this.mKey[i];
            this.mKey[i] = this.mKey[j];
            this.mKey[j] = t;
            t = (short)(this.mKey[i] + this.mKey[j] & 0xFF);
            int vEncodedByte = (short)pString.charAt(k) ^ this.mKey[t];
            if (Integer.toHexString(vEncodedByte).length() < 2) {
                vResult.append("0");
            }
            vResult.append(Integer.toHexString(vEncodedByte).toUpperCase());
        }
        return vResult.toString();
    }

    public String decryptData(String pString) throws EncryptionException {
        if (pString == null) {
            throw new EncryptionException("No data specified for decryption");
        }
        this.reset();
        int i = 0;
        short j = 0;
        StringBuffer vResult = new StringBuffer();
        vResult.setLength(0);
        for (int k = 0; k < pString.length(); k += 2) {
            i = (short)(i + 1 & 0xFF);
            j = (short)(j + this.mKey[i] & 0xFF);
            short t = this.mKey[i];
            this.mKey[i] = this.mKey[j];
            this.mKey[j] = t;
            t = (short)(this.mKey[i] + this.mKey[j] & 0xFF);
            int vByte = Integer.parseInt(pString.substring(k, k + 2), 16);
            int vDecodedByte = (short)vByte ^ this.mKey[t];
            vResult.append((char)vDecodedByte);
        }
        return vResult.toString();
    }

    public void init(String pKey) throws EncryptionException {
        int i;
        short[] xKey = new short[256];
        if (pKey == null || pKey.length() <= 0) {
            throw new EncryptionException("Key not specified");
        }
        for (i = 0; i < 256; ++i) {
            this.mKey[i] = (short)i;
            xKey[i] = (short)pKey.charAt(i % pKey.length());
        }
        int j = 0;
        for (i = 0; i < 256; ++i) {
            j = j + this.mKey[i] + xKey[i] & 0xFF;
            short t = this.mKey[i];
            this.mKey[i] = this.mKey[j];
            this.mKey[j] = t;
        }
        for (i = 0; i < 256; ++i) {
            this.mOrgKey[i] = this.mKey[i];
        }
    }

    public void reset() {
        System.arraycopy(this.mOrgKey, 0, this.mKey, 0, 256);
    }

    public void setName(String pName) {
        this.mName = pName;
    }

    public String getName() {
        return this.mName;
    }
}

