/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File pDirectoryToZip, File pOutZipFile, File pRelativeTo) throws IOException {
        ZipOutputStream vZos = new ZipOutputStream(new FileOutputStream(pOutZipFile));
        try {
            ZipUtil.zipDir(pDirectoryToZip, vZos, pRelativeTo);
        }
        finally {
            vZos.close();
        }
    }

    public static void zipDir(File pDirectoryToZip, ZipOutputStream pZos, File pRelativeTo) throws IOException {
        String[] vDirList = pDirectoryToZip.list();
        byte[] vReadBuffer = new byte[8192];
        int vBytesIn = 0;
        for (int i = 0; i < vDirList.length; ++i) {
            File vFile = new File(pDirectoryToZip, vDirList[i]);
            if (vFile.isDirectory()) {
                ZipUtil.zipDir(vFile, pZos, pRelativeTo);
                continue;
            }
            FileInputStream vFis = new FileInputStream(vFile);
            String vPath = vFile.getPath();
            if (pRelativeTo != null && (vPath = vPath.replaceFirst(pRelativeTo.getPath(), "")).startsWith("/")) {
                vPath = vPath.substring(1);
            }
            ZipEntry anEntry = new ZipEntry(vPath);
            pZos.putNextEntry(anEntry);
            while ((vBytesIn = vFis.read(vReadBuffer)) != -1) {
                pZos.write(vReadBuffer, 0, vBytesIn);
            }
            vFis.close();
        }
    }
}

