/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.apache.regexp.RE;
import org.apache.regexp.REProgram;

public class ValidationUtils {
    private static char[] mEmailPatternInstructions = new char[]{'|', '\u0000', '\u01ba', '^', '\u0000', '\u0003', '(', '\u0001', '\u0003', '|', '\u0000', 'z', '(', '\u0002', '\u0003', '|', '\u0000', 'q', '[', '\r', '\u001d', '=', '=', '\\', '\\', '^', '\uffff', '*', '+', '-', '-', '/', '9', '\u000b', '\u000b', '\u0000', '\u0007', '\u000e', '\u001f', '?', '?', 'A', 'Z', '!', '!', '#', '\'', '|', '\u0000', '\u0006', 'G', '\u0000', '\uffe0', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '|', '\u0000', '?', '(', '\u0003', '\u0003', '|', '\u0000', '0', 'A', '\u0001', '\u0004', '.', '[', '\r', '\u001d', '=', '=', '\\', '\\', '^', '\uffff', '*', '+', '-', '-', '/', '9', '\u000b', '\u000b', '\u0000', '\u0007', '\u000e', '\u001f', '?', '?', 'A', 'Z', '!', '!', '#', '\'', '|', '\u0000', '\u0006', 'G', '\u0000', '\uffe0', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', ')', '\u0003', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\uffc4', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', ')', '\u0002', '&', '|', '\u0000', '#', '(', '\u0004', '\u0003', '|', '\u0000', '\u001a', 'A', '\u0001', '\u0004', '\"', '.', '\u0000', '\u0003', '|', '\u0000', '\u0006', 'G', '\u0000', '\ufffa', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', '\"', ')', '\u0004', '\u0003', ')', '\u0001', '\u0003', 'A', '\u0001', '\u0004', '@', '(', '\u0005', '\u0003', '|', '\u0000', '\u00a4', '(', '\u0006', '\u0003', '|', '\u0000', '\u009b', 'A', '\u0001', '\u0004', '[', '[', '\u0001', '\u0005', '0', '9', '|', '\u0000', '\b', '[', '\u0001', '\b', '0', '9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '|', '\u0000', '\b', '[', '\u0001', '\b', '0', '9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', '.', '[', '\u0001', '\u0005', '0', '9', '|', '\u0000', '\b', '[', '\u0001', '\b', '0', '9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '|', '\u0000', '\b', '[', '\u0001', '\b', '0', '9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', '.', '[', '\u0001', '\u0005', '0', '9', '|', '\u0000', '\b', '[', '\u0001', '\b', '0', '9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '|', '\u0000', '\b', '[', '\u0001', '\b', '0', '9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', '.', '[', '\u0001', '\u0005', '0', '9', '|', '\u0000', '\b', '[', '\u0001', '\b', '0', '9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '|', '\u0000', '\b', '[', '\u0001', '\b', '0', '9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', ']', ')', '\u0006', 'c', '|', '\u0000', '`', '(', '\u0007', '\u0003', '|', '\u0000', 'W', '(', '\b', '\u0003', '|', '\u0000', '\u001e', '[', '\u0004', '\u000b', 'a', 'z', 'A', 'Z', '-', '-', '0', '9', '|', '\u0000', '\u0006', 'G', '\u0000', '\ufff2', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', '.', ')', '\b', '\u0003', '|', '\u0000', '\u0006', 'G', '\u0000', '\uffd9', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '[', '\u0002', '\u0007', 'a', 'z', 'A', 'Z', '[', '\u0002', '\u0007', 'a', 'z', 'A', 'Z', '|', '\u0000', '\u0010', '[', '\u0002', '\u0007', 'a', 'z', 'A', 'Z', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff3', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', ')', '\u0007', '\u0003', ')', '\u0005', '\u0003', '$', '\u0000', '\u0003', 'E', '\u0000', '\u0000'};
    private static RE mEmailPattern = new RE(new REProgram(mEmailPatternInstructions));

    public static boolean isValidTelephoneNumber(String pTelephoneNumber, boolean pMandatory, boolean pAllowSymbols) {
        if (pMandatory && Utils.isEmptyString(pTelephoneNumber)) {
            return false;
        }
        if (!pMandatory && Utils.isEmptyString(pTelephoneNumber)) {
            return true;
        }
        for (int i = 0; i < pTelephoneNumber.length(); ++i) {
            if (Character.isDigit(pTelephoneNumber.charAt(i))) continue;
            if (pAllowSymbols && pTelephoneNumber.charAt(i) != '(' && pTelephoneNumber.charAt(i) != ')' && pTelephoneNumber.charAt(i) != '-' && pTelephoneNumber.charAt(i) != ' ') {
                return false;
            }
            if (pAllowSymbols) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidEmailAddress(String pEmailAddress, boolean pMandatory) {
        if (pMandatory && Utils.isEmptyString(pEmailAddress)) {
            return false;
        }
        if (!pMandatory && Utils.isEmptyString(pEmailAddress)) {
            return true;
        }
        return mEmailPattern.match(pEmailAddress);
    }
}

