/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.za.pwnconsulting.javaconfig.exceptions.InternalConsistencyException;
import net.za.pwnconsulting.javaconfig.utils.Pair;

public class Utils {
    private Utils() {
    }

    public static boolean isValidLong(String pLong) {
        try {
            if (Utils.isEmptyString(pLong)) {
                return false;
            }
            Long.parseLong(pLong);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidInteger(String pInteger) {
        try {
            if (Utils.isEmptyString(pInteger)) {
                return false;
            }
            Integer.parseInt(pInteger);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidDouble(String pDouble) {
        try {
            if (Utils.isEmptyString(pDouble)) {
                return false;
            }
            Double.parseDouble(pDouble);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidBigDecimal(String pBigDecimal) {
        try {
            if (Utils.isEmptyString(pBigDecimal)) {
                return false;
            }
            new BigDecimal(pBigDecimal);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidBigInteger(String pBigInteger) {
        try {
            if (Utils.isEmptyString(pBigInteger)) {
                return false;
            }
            new BigInteger(pBigInteger);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidBoolean(String pBoolean) {
        return pBoolean != null && (pBoolean.equalsIgnoreCase("true") || pBoolean.equalsIgnoreCase("false"));
    }

    public static int getInt(String pInteger) throws NumberFormatException {
        return Integer.parseInt(pInteger);
    }

    public static long getLong(String pLong) throws NumberFormatException {
        return Long.parseLong(pLong);
    }

    public static short getShort(String pShort) throws NumberFormatException {
        return Short.parseShort(pShort);
    }

    public static double getDouble(String pDouble) throws NumberFormatException {
        return Double.parseDouble(pDouble);
    }

    public static float getFloat(String pFloat) throws NumberFormatException {
        return Float.parseFloat(pFloat);
    }

    public static int getInt(Integer pInteger) {
        if (pInteger == null) {
            return -1;
        }
        return pInteger;
    }

    public static int getShort(Short pShort) {
        if (pShort == null) {
            return -1;
        }
        return pShort.shortValue();
    }

    public static long getLong(Long pLong) {
        if (pLong == null) {
            return -1L;
        }
        return pLong;
    }

    public static int getPositiveInt(Integer pInteger) {
        if (pInteger == null) {
            return -1;
        }
        if (pInteger < -1) {
            throw new NumberFormatException("The integer passed is negative, this method only accepts positive numbers");
        }
        return pInteger;
    }

    public static int getPositiveShort(Short pShort) {
        if (pShort == null) {
            return -1;
        }
        if (pShort < -1) {
            throw new NumberFormatException("The short passed is negative, this method only accepts positive numbers");
        }
        return pShort.shortValue();
    }

    public static long getPositiveLong(Long pLong) {
        if (pLong == null) {
            return -1L;
        }
        if (pLong < -1L) {
            throw new NumberFormatException("The long passed is negative, this method only accepts positive numbers");
        }
        return pLong;
    }

    public static double getPositiveDouble(Double pDouble) {
        if (pDouble == null) {
            return -1.0;
        }
        if (pDouble < 0.0 && Math.abs(pDouble - -1.0) > Math.abs(0.0)) {
            throw new NumberFormatException("The double passed is negative, this method only accepts positive numbers");
        }
        return pDouble;
    }

    public static float getPositiveFloat(Float pFloat) {
        if (pFloat == null) {
            return -1.0f;
        }
        if (pFloat.floatValue() < 0.0f && Math.abs(pFloat.floatValue() - -1.0f) > Math.abs(0.0f)) {
            throw new NumberFormatException("The float passed is negative, this method only accepts positive numbers");
        }
        return pFloat.floatValue();
    }

    public static boolean getBool(String pBool) throws NumberFormatException {
        if (!Utils.isValidBoolean(pBool)) {
            throw new NumberFormatException("Can't convert string [" + pBool + "] into type boolean");
        }
        return Boolean.valueOf(pBool);
    }

    public static Boolean getBoolFromChar(String pBool, Boolean pDefaultValue) throws NumberFormatException {
        Boolean v1 = Utils.getBoolFromChar(pBool, "T", "F", null);
        Boolean v2 = Utils.getBoolFromChar(pBool, "Y", "N", null);
        if (v1 != null) {
            return v1;
        }
        if (v2 != null) {
            return v2;
        }
        return pDefaultValue;
    }

    public static Boolean getBoolFromChar(String pBool, String pTrue, String pFalse, Boolean pDefaultValue) throws NumberFormatException {
        if (pBool == null || pTrue == null || pFalse == null) {
            return pDefaultValue;
        }
        if (pBool.toUpperCase().equals(pTrue.toUpperCase())) {
            return new Boolean(true);
        }
        if (pBool.toUpperCase().equals(pFalse.toUpperCase())) {
            return new Boolean(false);
        }
        return pDefaultValue;
    }

    public static String getCharFromBool(Boolean pBool, String pDefaultValue) {
        return Utils.getCharFromBool(pBool, "T", "F", pDefaultValue);
    }

    public static String getCharFromBool(Boolean pBool, String pTrue, String pFalse, String pDefaultValue) {
        if (pBool == null || pTrue == null || pFalse == null) {
            return pDefaultValue;
        }
        if (pBool.booleanValue()) {
            return pTrue;
        }
        return pFalse;
    }

    public static boolean isEmptyString(String pValue) {
        return pValue == null || pValue.trim().equals("");
    }

    public static boolean isEquals(String pString1, String pString2) {
        if (pString1 == null && pString2 == null) {
            return true;
        }
        if (pString1 == null) {
            return false;
        }
        if (pString2 == null) {
            return false;
        }
        return Utils.makeProperString(pString1).equals(Utils.makeProperString(pString2));
    }

    public static boolean isEquals(Integer pInteger1, Integer pInteger2) {
        if (pInteger1 == null && pInteger2 == null) {
            return true;
        }
        if (pInteger1 == null) {
            return false;
        }
        if (pInteger2 == null) {
            return false;
        }
        return pInteger1.equals(pInteger2);
    }

    public static String emptyAsNull(String pValue) {
        if (pValue == null || pValue.trim().equals("")) {
            return null;
        }
        return pValue.trim();
    }

    public static String makeProperString(String pValue) {
        if (pValue == null) {
            return "";
        }
        return pValue.trim();
    }

    public static String makeProperString(Object pValue) {
        if (pValue == null) {
            return "";
        }
        return pValue.toString().trim();
    }

    public static Date makeSQLDate(java.util.Date pDate) {
        if (pDate == null) {
            return null;
        }
        return new Date(pDate.getTime());
    }

    public static java.util.Date makeDateFromSQLDate(Date pDate) {
        if (pDate == null) {
            return null;
        }
        return new java.util.Date(pDate.getTime());
    }

    public static java.util.Date makeDateFromSQLDate(Timestamp pDate) {
        if (pDate == null) {
            return null;
        }
        return new java.util.Date(pDate.getTime());
    }

    public static Integer[] toIntegerArray(Object[] pArray) {
        if (pArray == null) {
            return null;
        }
        Integer[] vArray = new Integer[pArray.length];
        for (int i = 0; i < pArray.length; ++i) {
            vArray[i] = (Integer)pArray[i];
        }
        return vArray;
    }

    public static Integer[] toIntegerArray(int[] pArray) {
        if (pArray == null) {
            return null;
        }
        Integer[] vArray = new Integer[pArray.length];
        for (int i = 0; i < pArray.length; ++i) {
            vArray[i] = new Integer(pArray[i]);
        }
        return vArray;
    }

    public static String[] toStringArray(Object[] pArray) {
        if (pArray == null) {
            return null;
        }
        String[] vArray = new String[pArray.length];
        for (int i = 0; i < pArray.length; ++i) {
            vArray[i] = (String)pArray[i];
        }
        return vArray;
    }

    public static Pair[] toPairArray(Object[] pArray) {
        if (pArray == null) {
            return null;
        }
        Pair[] vArray = new Pair[pArray.length];
        for (int i = 0; i < pArray.length; ++i) {
            vArray[i] = (Pair)pArray[i];
        }
        return vArray;
    }

    public static List arrayToArrayList(Object[] pArray) {
        if (pArray == null) {
            return null;
        }
        return Arrays.asList(pArray);
    }

    public static byte[] serializeObject(Object pObject) throws IOException {
        if (pObject == null) {
            return null;
        }
        ByteArrayOutputStream vBOS = new ByteArrayOutputStream();
        ObjectOutputStream vOOS = new ObjectOutputStream(vBOS);
        vOOS.writeObject(pObject);
        return vBOS.toByteArray();
    }

    public static Object deserializeObject(byte[] pObject) throws IOException, ClassNotFoundException {
        if (pObject == null) {
            return null;
        }
        return new ObjectInputStream(new ByteArrayInputStream(pObject)).readObject();
    }

    public static long convertListOfBitValuesToInteger(List pBitList) {
        if (pBitList == null) {
            throw new InternalConsistencyException("The bit list was not specified");
        }
        if (pBitList.size() > 0 && pBitList.get(0) != null && !(pBitList.get(0) instanceof Integer)) {
            throw new ClassCastException("The elements of pBitList should be of type Integer, not [" + pBitList.get(0).getClass().getName() + "]");
        }
        long vRes = 0L;
        for (int i = 0; i < pBitList.size(); ++i) {
            Integer vBit = (Integer)pBitList.get(i);
            if (vBit == null) continue;
            vRes |= (long)vBit.intValue();
        }
        return vRes;
    }

    public static List convertIntegerToListOfBitValues(long pValue) {
        ArrayList<Integer> vRes = new ArrayList<Integer>();
        int vBit = 1;
        for (long vTmp = pValue; vTmp > 0L; vTmp >>= 1) {
            if ((vTmp & 1L) == 1L) {
                vRes.add(new Integer(1 << vBit - 1));
            }
            ++vBit;
        }
        return vRes;
    }

    public static String makeInitialCaps(String pString) {
        if (Utils.isEmptyString(pString)) {
            return pString;
        }
        StringBuffer vRes = new StringBuffer(pString.toLowerCase());
        for (int i = 0; i < vRes.length(); ++i) {
            if (i != 0 && (!Character.isWhitespace(vRes.charAt(i - 1)) || Character.isWhitespace(vRes.charAt(i)))) continue;
            vRes.setCharAt(i, Character.toTitleCase(vRes.charAt(i)));
        }
        return vRes.toString();
    }
}

