/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.za.pwnconsulting.javaconfig.utils.ChangePermissions;
import net.za.pwnconsulting.javaconfig.utils.Utils;

public class UNIXChangePermissions
implements ChangePermissions {
    public void changeOwnership(File pBasePath, String pOwner, String pGroup, boolean pRecurse) throws IOException, InterruptedException {
        String[] stringArray;
        String[] stringArray2;
        if (pBasePath == null) {
            throw new IllegalArgumentException("pBaseFile was not specified");
        }
        if (pBasePath.getAbsolutePath().equals("/")) {
            throw new IllegalArgumentException("pBaseFile may not refer to the root folder");
        }
        if (Utils.isEmptyString(pOwner) || Utils.isEmptyString(pGroup)) {
            throw new IllegalArgumentException("The owner and group must be specified");
        }
        Runtime runtime = Runtime.getRuntime();
        if (pRecurse) {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "chown";
            stringArray3[1] = "-R";
            stringArray3[2] = pOwner;
            stringArray2 = stringArray3;
            stringArray3[3] = pBasePath.getAbsolutePath();
        } else {
            String[] stringArray4 = new String[3];
            stringArray4[0] = "chown";
            stringArray4[1] = pOwner;
            stringArray2 = stringArray4;
            stringArray4[2] = pBasePath.getAbsolutePath();
        }
        Process vP = runtime.exec(stringArray2);
        if (vP.waitFor() != 0) {
            throw new IOException("The chown process failed [" + (vP.getErrorStream().available() > 0 ? new BufferedReader(new InputStreamReader(vP.getErrorStream())).readLine() : "Unknown") + "]");
        }
        Runtime runtime2 = Runtime.getRuntime();
        if (pRecurse) {
            String[] stringArray5 = new String[4];
            stringArray5[0] = "chgrp";
            stringArray5[1] = "-R";
            stringArray5[2] = pGroup;
            stringArray = stringArray5;
            stringArray5[3] = pBasePath.getAbsolutePath();
        } else {
            String[] stringArray6 = new String[3];
            stringArray6[0] = "chgrp";
            stringArray6[1] = pGroup;
            stringArray = stringArray6;
            stringArray6[2] = pBasePath.getAbsolutePath();
        }
        vP = runtime2.exec(stringArray);
        if (vP.waitFor() != 0) {
            throw new IOException("The chgrp process failed [" + (vP.getErrorStream().available() > 0 ? new BufferedReader(new InputStreamReader(vP.getErrorStream())).readLine() : "Unknown") + "]");
        }
    }

    public void changePermission(File pBasePath, String pFilePermission, String pDirectoryPermission) throws IOException, InterruptedException {
        if (pBasePath == null) {
            throw new IllegalArgumentException("pBaseFile was not specified");
        }
        if (pBasePath.getAbsolutePath().equals("/")) {
            throw new IllegalArgumentException("pBaseFile may not refer to the root folder");
        }
        if (Utils.isEmptyString(pFilePermission) || Utils.isEmptyString(pDirectoryPermission)) {
            throw new IllegalArgumentException("The file and directory permissions must be specified");
        }
        Process vP = Runtime.getRuntime().exec(new String[]{"find", pBasePath.getAbsolutePath(), "-type", "d", "-exec", "chmod", pDirectoryPermission, "{}", ";"});
        if (vP.waitFor() != 0) {
            throw new IOException("The find/chmod -d process failed [" + (vP.getErrorStream().available() > 0 ? new BufferedReader(new InputStreamReader(vP.getErrorStream())).readLine() : "Unknown") + "]");
        }
        vP = Runtime.getRuntime().exec(new String[]{"find", pBasePath.getAbsolutePath(), "-type", "f", "-exec", "chmod", pFilePermission, "{}", ";"});
        if (vP.waitFor() != 0) {
            throw new IOException("The find/chmod -f process failed [" + (vP.getErrorStream().available() > 0 ? new BufferedReader(new InputStreamReader(vP.getErrorStream())).readLine() : "Unknown") + "]");
        }
    }
}

