/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.javaconfig.exceptions.InvalidDataException;
import net.za.pwnconsulting.javaconfig.exceptions.ProgrammerMistakeException;
import net.za.pwnconsulting.javaconfig.utils.IntelligentStringTokenizer;
import net.za.pwnconsulting.javaconfig.utils.Pair;
import net.za.pwnconsulting.javaconfig.utils.Utils;

public class StringUtils {
    public static final int LEFT_JUSTIFIED = 0;
    public static final int RIGHT_JUSTIFIED = 1;

    private StringUtils() {
    }

    public static String replaceAll(String pString, String pMatch, String pReplace) {
        StringBuffer vRes = new StringBuffer();
        int vLastIndex = 0;
        int vOldLastIndex = 0;
        if (pString == null) {
            return null;
        }
        while ((vLastIndex = pString.indexOf(pMatch, vOldLastIndex)) != -1) {
            vRes.append(pString.substring(vOldLastIndex, vLastIndex));
            vRes.append(pReplace);
            vOldLastIndex = vLastIndex + pMatch.length();
        }
        if (vRes.toString().equals("")) {
            vRes.append(pString);
        } else {
            vRes.append(pString.substring(vOldLastIndex, pString.length()));
        }
        return vRes.toString();
    }

    public static String escapeStringForHTML(String pString) {
        StringBuffer vNewString = new StringBuffer();
        if (pString == null) {
            return null;
        }
        for (int i = 0; i < pString.length(); ++i) {
            if (pString.charAt(i) == '&') {
                vNewString.append("&amp;");
                continue;
            }
            if (pString.charAt(i) == '<') {
                vNewString.append("&lt;");
                continue;
            }
            if (pString.charAt(i) == '>') {
                vNewString.append("&gt;");
                continue;
            }
            vNewString.append(pString.charAt(i));
        }
        return vNewString.toString();
    }

    public static String escapeQuotesInString(String pValue, char pQuoteChar) {
        if (Utils.isEmptyString(pValue)) {
            return pValue;
        }
        StringBuffer vNewValue = new StringBuffer();
        int vLength = pValue.length();
        for (int j = 0; j < vLength; ++j) {
            char vChar = pValue.charAt(j);
            vNewValue.append(vChar);
            if (vChar != pQuoteChar) continue;
            vNewValue.append(pQuoteChar);
        }
        return vNewValue.toString();
    }

    public static List convertCSVStringToList(String pCSV) {
        ArrayList<String> vRes = new ArrayList<String>();
        if (pCSV == null) {
            return vRes;
        }
        IntelligentStringTokenizer vIST = new IntelligentStringTokenizer(pCSV, ",", "\"", "\"");
        while (vIST.hasMoreTokens()) {
            vRes.add(vIST.nextToken());
        }
        return vRes;
    }

    public static List convertCSVPairStringToPairList(String pCSV) {
        ArrayList<Pair> vRes = new ArrayList<Pair>();
        if (pCSV == null) {
            return vRes;
        }
        IntelligentStringTokenizer vIST = new IntelligentStringTokenizer(pCSV, ";", "\"", "\"");
        while (vIST.hasMoreTokens()) {
            String vToken = vIST.nextToken();
            IntelligentStringTokenizer vIST2 = new IntelligentStringTokenizer(vToken, ",", "\"", "\"");
            String vValue1 = "";
            String vValue2 = "";
            if (vIST2.hasMoreTokens()) {
                vValue1 = vIST2.nextToken();
            }
            if (vIST2.hasMoreTokens()) {
                vValue2 = vIST2.nextToken();
            }
            vRes.add(new Pair(vValue1, vValue2));
        }
        return vRes;
    }

    public static String convertListToCSVString(List pList, char pQuoteChar) {
        StringBuffer vData = new StringBuffer();
        if (pList == null) {
            throw new IllegalArgumentException("The List to convert was not specified.");
        }
        for (int i = 0; i < pList.size(); ++i) {
            Object vEntry = pList.get(i);
            if (!(vEntry instanceof List)) {
                throw new ProgrammerMistakeException("The contents of the List should be List objects.  Found [" + vEntry.getClass().getName() + "] instead.");
            }
            if (vEntry == null) continue;
            for (int j = 0; j < ((List)vEntry).size(); ++j) {
                Object vE = ((List)vEntry).get(j);
                if (vE != null) {
                    vE = pQuoteChar + StringUtils.escapeQuotesInString(vE.toString(), '\"') + pQuoteChar;
                }
                vData.append(vE);
                if (j >= ((List)vEntry).size() - 1) continue;
                vData.append(",");
            }
            vData.append("\n");
        }
        return vData.toString();
    }

    public static String convertScalarListToCSVStringForPresentation(List pList) {
        StringBuffer vData = new StringBuffer();
        if (pList == null) {
            throw new IllegalArgumentException("The List to convert was not specified.");
        }
        for (int i = 0; i < pList.size(); ++i) {
            Object vEntry = pList.get(i);
            if (vEntry == null) continue;
            vEntry = Utils.makeProperString(vEntry.toString());
            vData.append(vEntry);
            if (i >= pList.size() - 1) continue;
            vData.append(", ");
        }
        return vData.toString();
    }

    public static String justifyString(String pString, int pJustification, char pFiller, int pLength) throws InvalidDataException {
        StringBuffer vRes = new StringBuffer();
        vRes.setLength(pLength);
        if (pString == null || pLength == 0) {
            return vRes.toString();
        }
        if (pString.length() > pLength) {
            throw new InvalidDataException("The string to pad cannot be longer than the destination string");
        }
        for (int i = 0; i < vRes.length(); ++i) {
            vRes.setCharAt(i, pFiller);
        }
        if (pJustification == 0) {
            vRes.replace(0, pString.length(), pString);
        } else if (pJustification == 1) {
            vRes.replace(pLength - pString.length(), pLength, pString);
        } else {
            throw new InvalidDataException("Unsupported justification");
        }
        return vRes.toString();
    }

    public static String formatLeadingZero(Integer pValue, int pLength) throws InvalidDataException {
        if (pValue == null) {
            throw new InvalidDataException("The value to format was not specified");
        }
        StringBuffer vRes = new StringBuffer();
        for (int i = 0; i < pLength; ++i) {
            vRes.append('0');
        }
        DecimalFormat vFmt = new DecimalFormat(vRes.toString());
        return vFmt.format(pValue);
    }

    public static String formatLeadingZero(Long pValue, int pLength) throws InvalidDataException {
        if (pValue == null) {
            throw new InvalidDataException("The value to format was not specified");
        }
        StringBuffer vRes = new StringBuffer();
        for (int i = 0; i < pLength; ++i) {
            vRes.append('0');
        }
        DecimalFormat vFmt = new DecimalFormat(vRes.toString());
        return vFmt.format(pValue);
    }

    public static String formatDecimal(Double pValue, String pPattern) throws InvalidDataException {
        if (pValue == null) {
            throw new InvalidDataException("The value to format was not specified");
        }
        DecimalFormat vFmt = new DecimalFormat(pPattern);
        return vFmt.format(pValue);
    }

    public static String hexEncodeAsString(Object pObject) {
        if (pObject == null) {
            return null;
        }
        return StringUtils.hexEncodeAsString(pObject.toString().getBytes());
    }

    public static String hexEncodeAsString(byte[] pData) {
        if (pData == null) {
            return null;
        }
        byte[] vObject = pData;
        StringBuffer vRes = new StringBuffer();
        int vLength = vObject.length;
        for (int i = 0; i < vLength; ++i) {
            int vExpandedByte = vObject[i] & 0xFF;
            String vHex = Integer.toHexString(vExpandedByte).toUpperCase();
            vRes.append(vHex.length() < 2 ? "0" + vHex : vHex);
        }
        return vRes.toString();
    }

    public static byte[] hexDecodeAsBytes(String pString) {
        if (pString == null) {
            return null;
        }
        int vLen = pString.length() >> 1;
        byte[] vRes = new byte[vLen];
        int i = 0;
        for (int j = 0; j < vLen; ++j) {
            vRes[j] = (byte)Integer.parseInt(pString.substring(i, i + 2), 16);
            i += 2;
        }
        return vRes;
    }

    public static String wrapString(String pStringToWrap, int pColumn, boolean pHardWrap) {
        if (pStringToWrap == null) {
            return null;
        }
        StringBuffer vNewString = new StringBuffer();
        String vStringToWrap = pStringToWrap;
        String vDelimiters = "\r\n";
        if (pStringToWrap.indexOf("\r\n") != -1) {
            vDelimiters = "\n";
            vStringToWrap = StringUtils.replaceAll(vStringToWrap, "\r\n", "\n");
        } else if (pStringToWrap.indexOf("\r") != -1) {
            vDelimiters = "\r";
        } else if (pStringToWrap.indexOf("\n") != -1) {
            vDelimiters = "\n";
        }
        IntelligentStringTokenizer vST = new IntelligentStringTokenizer(vStringToWrap, vDelimiters, "", "");
        while (vST.hasMoreTokens()) {
            String vLine = vST.nextToken();
            if (vLine.length() > pColumn) {
                while (vLine.length() > pColumn) {
                    int vPos = pColumn;
                    if (!pHardWrap) {
                        for (int i = pColumn; i >= 0; --i) {
                            if (!Character.isWhitespace(vLine.charAt(i))) continue;
                            vPos = i;
                            break;
                        }
                    }
                    vNewString.append(vLine.substring(0, vPos)).append("\n");
                    vLine = vLine.substring(vPos + 1);
                }
                if (vLine.length() <= 0) continue;
                vNewString.append(vLine).append("\n");
                continue;
            }
            vNewString.append(vLine).append("\n");
        }
        return vNewString.toString();
    }
}

