/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Period
extends Date {
    private static SoftReference mSimpleFormatter = null;

    public Period() {
    }

    public Period(long pDate) {
        super(pDate);
    }

    public Period(String pDate, String pFormat) throws ParseException {
        super(new SimpleDateFormat(pFormat, Locale.US).parse(pDate).getTime());
    }

    public boolean before(Date pWhen) {
        return this.compareTo(pWhen) < 0;
    }

    public boolean after(Date pWhen) {
        return this.compareTo(pWhen) > 0;
    }

    public boolean beforeOrEquals(Date pWhen) {
        return this.compareTo(pWhen) <= 0;
    }

    public boolean afterOrEquals(Date pWhen) {
        return this.compareTo(pWhen) >= 0;
    }

    public boolean equals(Object pWhen) {
        return pWhen instanceof Date && this.compareTo((Date)pWhen) == 0;
    }

    public void add(int pField, int pAmount) {
        Calendar vC = Calendar.getInstance();
        vC.setTime(this);
        vC.add(pField, pAmount);
        this.setTime(vC.getTime().getTime());
    }

    public int get(int pField) {
        Calendar vC = Calendar.getInstance();
        vC.setTime(this);
        return vC.get(pField);
    }

    public int compareTo(Date pAnotherDate) {
        Calendar vThis = Calendar.getInstance();
        vThis.setTime(this);
        Calendar vOther = Calendar.getInstance();
        vOther.setTime(pAnotherDate);
        if (vThis.get(1) < vOther.get(1) || vThis.get(1) == vOther.get(1) && vThis.get(2) < vOther.get(2)) {
            return -1;
        }
        if (vThis.get(1) == vOther.get(1) && vThis.get(2) == vOther.get(2)) {
            return 0;
        }
        return 1;
    }

    public boolean between(Period pStartDate, Period pEndDate) {
        return this.afterOrEquals(pStartDate) && this.beforeOrEquals(pEndDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        DateFormat vFormatter = null;
        if (mSimpleFormatter != null) {
            vFormatter = (DateFormat)mSimpleFormatter.get();
        }
        if (vFormatter == null) {
            vFormatter = new SimpleDateFormat("yyyy-MM", Locale.US);
            mSimpleFormatter = new SoftReference<DateFormat>(vFormatter);
        }
        DateFormat dateFormat = vFormatter;
        synchronized (dateFormat) {
            vFormatter.setTimeZone(TimeZone.getDefault());
            return vFormatter.format(this);
        }
    }

    public int getMonthsDifference(Period pAnotherDate) {
        int vMonthDiff = 0;
        int vSign = 1;
        if (pAnotherDate == null) {
            throw new IllegalArgumentException("The date to compare to was not specified");
        }
        Period vC1 = new Period(this.getTime());
        Period vC2 = new Period(pAnotherDate.getTime());
        if (vC2.before(vC1)) {
            Period vTmp = vC1;
            vC1 = vC2;
            vC2 = vTmp;
            vSign = -1;
        }
        while (vC1.before(vC2)) {
            vC1.add(2, 1);
            ++vMonthDiff;
        }
        return vMonthDiff * vSign;
    }
}

