/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import net.za.pwnconsulting.javaconfig.utils.MapCheckException;
import net.za.pwnconsulting.javaconfig.utils.Utils;

public class MapUtils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;

    private MapUtils() {
    }

    public static Object getMapValue(Map pMap, String pMapKey, Class pExpectedType, boolean pZapStringGremlins) {
        if (pMap == null) {
            throw new MapCheckException("The map specified is null");
        }
        if (Utils.isEmptyString(pMapKey)) {
            throw new MapCheckException("The map key was not specified");
        }
        if (pExpectedType == null) {
            throw new MapCheckException("The expected class type for the map entry was not specified");
        }
        if (!pMap.containsKey(pMapKey)) {
            throw new MapCheckException("The map given does not contain the map key [" + pMapKey + "]");
        }
        Object vValue = pMap.get(pMapKey);
        if (!(vValue != null || pZapStringGremlins && pExpectedType == (class$java$lang$String == null ? (class$java$lang$String = MapUtils.class$("java.lang.String")) : class$java$lang$String))) {
            return null;
        }
        if (vValue != null && !pExpectedType.isAssignableFrom(vValue.getClass())) {
            throw new MapCheckException("The map entry [" + pMapKey + "] is of type [" + vValue.getClass().getName() + "], but was expected to be of type [" + pExpectedType.getName() + "]");
        }
        if (pZapStringGremlins && pExpectedType == (class$java$lang$String == null ? (class$java$lang$String = MapUtils.class$("java.lang.String")) : class$java$lang$String)) {
            return Utils.makeProperString(vValue);
        }
        return vValue;
    }

    public static String getMapValueAsString(Map pMap, String pMapKey, boolean pZapStringGremlins) {
        return (String)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$String == null ? (class$java$lang$String = MapUtils.class$("java.lang.String")) : class$java$lang$String, pZapStringGremlins);
    }

    public static String getMapValueAsStringBlankAsNull(Map pMap, String pMapKey) {
        String vRes = MapUtils.getMapValueAsString(pMap, pMapKey, true);
        if (Utils.isEmptyString(vRes)) {
            return null;
        }
        return vRes;
    }

    public static Integer getMapValueAsInteger(Map pMap, String pMapKey) {
        return (Integer)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$Integer == null ? (class$java$lang$Integer = MapUtils.class$("java.lang.Integer")) : class$java$lang$Integer, false);
    }

    public static Long getMapValueAsLong(Map pMap, String pMapKey) {
        return (Long)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$Long == null ? (class$java$lang$Long = MapUtils.class$("java.lang.Long")) : class$java$lang$Long, false);
    }

    public static Short getMapValueAsShort(Map pMap, String pMapKey) {
        return (Short)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$Short == null ? (class$java$lang$Short = MapUtils.class$("java.lang.Short")) : class$java$lang$Short, false);
    }

    public static BigDecimal getMapValueAsBigDecimal(Map pMap, String pMapKey) {
        return (BigDecimal)MapUtils.getMapValue(pMap, pMapKey, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MapUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, false);
    }

    public static Long getMapValueAsBigIntegerToLong(Map pMap, String pMapKey) {
        BigInteger vValue = (BigInteger)MapUtils.getMapValue(pMap, pMapKey, class$java$math$BigInteger == null ? (class$java$math$BigInteger = MapUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger, false);
        return vValue == null ? null : new Long(vValue.longValue());
    }

    public static Double getMapValueAsBigDecimalToDouble(Map pMap, String pMapKey) {
        BigDecimal vValue = (BigDecimal)MapUtils.getMapValue(pMap, pMapKey, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MapUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, false);
        return vValue == null ? null : new Double(vValue.doubleValue());
    }

    public static Double getMapValueAsDouble(Map pMap, String pMapKey) {
        return (Double)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$Double == null ? (class$java$lang$Double = MapUtils.class$("java.lang.Double")) : class$java$lang$Double, false);
    }

    public static Float getMapValueAsFloat(Map pMap, String pMapKey) {
        return (Float)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$Float == null ? (class$java$lang$Float = MapUtils.class$("java.lang.Float")) : class$java$lang$Float, false);
    }

    public static Boolean getMapValueAsBooleanFromTF(Map pMap, String pMapKey, Boolean pDefaultValue) {
        return Utils.getBoolFromChar((String)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$String == null ? (class$java$lang$String = MapUtils.class$("java.lang.String")) : class$java$lang$String, true), pDefaultValue);
    }

    public static Boolean getMapValueAsBooleanFromYN(Map pMap, String pMapKey, Boolean pDefaultValue) {
        return Utils.getBoolFromChar((String)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$String == null ? (class$java$lang$String = MapUtils.class$("java.lang.String")) : class$java$lang$String, true), pDefaultValue);
    }

    public static Boolean getMapValueAsBoolean(Map pMap, String pMapKey, Boolean pDefaultValue) {
        Boolean vValue = (Boolean)MapUtils.getMapValue(pMap, pMapKey, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MapUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, true);
        return vValue == null ? pDefaultValue : vValue;
    }

    public static Date getMapValueAsSQLDate(Map pMap, String pMapKey) {
        return (java.sql.Date)MapUtils.getMapValue(pMap, pMapKey, class$java$sql$Date == null ? (class$java$sql$Date = MapUtils.class$("java.sql.Date")) : class$java$sql$Date, false);
    }

    public static Date getMapValueAsSQLTimestamp(Map pMap, String pMapKey) {
        return (Timestamp)MapUtils.getMapValue(pMap, pMapKey, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = MapUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, false);
    }

    public static Date getMapValueAsSQLTime(Map pMap, String pMapKey) {
        return (Time)MapUtils.getMapValue(pMap, pMapKey, class$java$sql$Time == null ? (class$java$sql$Time = MapUtils.class$("java.sql.Time")) : class$java$sql$Time, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

