/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.util.List;
import net.za.pwnconsulting.javaconfig.exceptions.InternalConsistencyException;

public class ListUtils {
    private ListUtils() {
    }

    public static List makeUniqueList(List pList) {
        if (pList == null) {
            return null;
        }
        try {
            List vUnique = (List)Class.forName(pList.getClass().getName()).newInstance();
            for (int i = 0; i < pList.size(); ++i) {
                if (vUnique.contains(pList.get(i))) continue;
                vUnique.add(pList.get(i));
            }
            return vUnique;
        }
        catch (Exception e) {
            throw new InternalConsistencyException("Internal Error: " + e.getMessage(), e);
        }
    }

    public static List intersection(List pList1, List pList2) {
        try {
            if (pList1 == null || pList2 == null) {
                return null;
            }
            List vRes = (List)Class.forName(pList1.getClass().getName()).newInstance();
            for (int i = 0; i < pList1.size(); ++i) {
                if (!pList2.contains(pList1.get(i))) continue;
                vRes.add(pList1.get(i));
            }
            return vRes;
        }
        catch (Exception e) {
            throw new InternalConsistencyException("Internal Error: " + e.getMessage(), e);
        }
    }

    public static List union(List pList1, List pList2) {
        try {
            if (pList1 == null && pList2 == null) {
                return null;
            }
            List vRes = (List)Class.forName(pList1.getClass().getName()).newInstance();
            if (pList1 == null) {
                vRes.addAll(pList2);
                return vRes;
            }
            if (pList2 == null) {
                vRes.addAll(pList1);
                return vRes;
            }
            vRes.addAll(pList1);
            for (int i = 0; i < pList2.size(); ++i) {
                if (vRes.contains(pList2.get(i))) continue;
                vRes.add(pList2.get(i));
            }
            return vRes;
        }
        catch (Exception e) {
            throw new InternalConsistencyException("Internal Error: " + e.getMessage(), e);
        }
    }

    public static List difference(List pList1, List pList2) {
        try {
            if (pList1 == null) {
                return null;
            }
            List vRes = (List)Class.forName(pList1.getClass().getName()).newInstance();
            for (int i = 0; i < pList1.size(); ++i) {
                if (pList2.contains(pList1.get(i))) continue;
                vRes.add(pList1.get(i));
            }
            return vRes;
        }
        catch (Exception e) {
            throw new InternalConsistencyException("Internal Error: " + e.getMessage(), e);
        }
    }
}

