/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class IntelligentStringTokenizer {
    private List mTokenizedLine;
    private String mString;
    private int mTokenIterator;

    public IntelligentStringTokenizer(String pString, String pDelimiters, String pOpenQuoteChars, String pCloseQuoteChars) {
        this.mString = pString;
        this.mTokenizedLine = this.tokenizeString(pString, pDelimiters, pOpenQuoteChars, pCloseQuoteChars);
        this.mTokenIterator = 0;
    }

    public IntelligentStringTokenizer(String pString) {
        this(pString, " \r\n\f\t", "'\"", "'\"");
    }

    public boolean hasMoreTokens() {
        return this.mTokenIterator < this.mTokenizedLine.size();
    }

    public String nextToken() {
        if (this.hasMoreTokens()) {
            Map vToken = (Map)this.mTokenizedLine.get(this.mTokenIterator++);
            return (String)vToken.get(vToken.keySet().iterator().next());
        }
        throw new NoSuchElementException("No more tokens available");
    }

    public void rewindTokens() {
        this.mTokenIterator = 0;
    }

    public int getTokenCount() {
        return this.mTokenizedLine.size();
    }

    public String getPartialStringFromCurrentPosition() {
        if (this.mTokenIterator < 1) {
            throw new NoSuchElementException("Need to call nextToken() at least once before calling this method");
        }
        Map vToken = (Map)this.mTokenizedLine.get(this.mTokenIterator - 1);
        int vBeginIndex = (Integer)vToken.keySet().iterator().next();
        if (vBeginIndex >= this.mString.length()) {
            return null;
        }
        return this.mString.substring(vBeginIndex);
    }

    public String getPartialStringFromPreviousPosition() {
        if (this.mTokenIterator < 2) {
            throw new NoSuchElementException("Need to call nextToken() at least twice before calling this method");
        }
        Map vToken = (Map)this.mTokenizedLine.get(this.mTokenIterator - 2);
        return this.mString.substring((Integer)vToken.keySet().iterator().next());
    }

    private List tokenizeString(String pLine, String pDelimiters, String pOpenQuoteChars, String pCloseQuoteChars) {
        ArrayList vRes = new ArrayList();
        StringBuffer vField = new StringBuffer();
        boolean vInQuoted = false;
        boolean vEscaping = false;
        String QUOTE_OPEN_CHARS = pOpenQuoteChars;
        String QUOTE_CLOSE_CHARS = pCloseQuoteChars;
        String SEPARATOR_CHARS = pDelimiters;
        char ESCAPE_CHAR = '\\';
        if ((QUOTE_OPEN_CHARS.indexOf(32) != -1 || QUOTE_CLOSE_CHARS.indexOf(32) != -1) && SEPARATOR_CHARS.indexOf(32) != -1) {
            throw new IllegalArgumentException("It is not allowed to have the open or close quote character a space when the separator character is also a space");
        }
        if (pLine == null) {
            return vRes;
        }
        String vLine = pLine.trim();
        boolean vConsecutiveWhitespace = false;
        int vLastSavedQuoteIndex = -1;
        int vLineLength = vLine.length();
        for (int i = 0; i < vLineLength; ++i) {
            HashMap<Integer, String> vToken;
            vConsecutiveWhitespace = false;
            char vChar = vLine.charAt(i);
            if (vChar == ESCAPE_CHAR) {
                vEscaping = true;
            } else if ((!vInQuoted && QUOTE_OPEN_CHARS.indexOf(vChar) != -1 || vInQuoted && QUOTE_CLOSE_CHARS.charAt(vLastSavedQuoteIndex) == vChar) && !vEscaping) {
                if (!vInQuoted) {
                    vLastSavedQuoteIndex = QUOTE_OPEN_CHARS.indexOf(vChar);
                }
                vInQuoted = !vInQuoted;
            } else if (SEPARATOR_CHARS.indexOf(vChar) != -1 && !vInQuoted) {
                if (vChar == ' ' && SEPARATOR_CHARS.indexOf(32) != -1 && i > 0 && vLine.charAt(i - 1) == ' ') {
                    vConsecutiveWhitespace = true;
                } else {
                    vToken = new HashMap();
                    vToken.put(new Integer(i), vField.toString().trim());
                    vRes.add(vToken);
                    vField.setLength(0);
                }
            } else {
                vField.append(vChar);
            }
            if (vEscaping && vLine.charAt(i - 1) == ESCAPE_CHAR) {
                vEscaping = false;
            }
            if (i != vLineLength - 1 || vConsecutiveWhitespace) continue;
            vToken = new HashMap<Integer, String>();
            vToken.put(new Integer(i + 1), vField.toString().trim());
            vRes.add(vToken);
        }
        return vRes;
    }
}

