/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    public static boolean deleteDirectory(File pPath) {
        if (pPath == null) {
            throw new IllegalArgumentException("The path to delete was not specified");
        }
        if (!pPath.exists()) {
            return true;
        }
        File[] vFiles = pPath.listFiles();
        for (int i = 0; i < vFiles.length; ++i) {
            if (vFiles[i].isDirectory()) {
                FileUtils.deleteDirectory(vFiles[i]);
                continue;
            }
            vFiles[i].delete();
        }
        return pPath.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(byte[] pData, String pFilePath) throws IOException {
        if (pFilePath == null) {
            throw new IllegalArgumentException("The file to create was not specified");
        }
        FileOutputStream vFOS = new FileOutputStream(pFilePath);
        try {
            vFOS.write(pData);
        }
        finally {
            vFOS.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileAsBytes(String pFilePath) throws IOException {
        if (pFilePath == null) {
            throw new IllegalArgumentException("The file to read was not specified");
        }
        byte[] vRes = null;
        byte[] vBuffer = new byte[2048];
        ByteArrayOutputStream vBOS = new ByteArrayOutputStream();
        try {
            FileInputStream vIn = new FileInputStream(pFilePath);
            try {
                int vLength = 0;
                while ((vLength = vIn.read(vBuffer)) > 0) {
                    vBOS.write(vBuffer, 0, vLength);
                }
            }
            finally {
                vIn.close();
            }
            vRes = vBOS.toByteArray();
        }
        finally {
            vBOS.close();
        }
        return vRes;
    }
}

