/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final int DATE_MILLISECONDS = 1;
    public static final int DATE_SECONDS = 2;
    public static final int DATE_MINUTES = 3;
    public static final int DATE_HOURS = 4;
    public static final int DATE_DAYS = 5;

    private DateUtils() {
    }

    public static int compareByMonth(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            throw new IllegalArgumentException("pDate1 was not specified");
        }
        if (pDate2 == null) {
            throw new IllegalArgumentException("pDate2 was not specified");
        }
        Calendar vC1 = Calendar.getInstance();
        Calendar vC2 = Calendar.getInstance();
        vC1.setTime(pDate1);
        vC2.setTime(pDate2);
        if (vC1.get(1) < vC2.get(1) || vC1.get(1) == vC2.get(1) && vC1.get(2) < vC2.get(2)) {
            return -1;
        }
        if (vC1.get(1) == vC2.get(1) && vC1.get(2) == vC2.get(2)) {
            return 0;
        }
        return 1;
    }

    public static int getMonthDifference(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            throw new IllegalArgumentException("pDate1 was not specified");
        }
        if (pDate2 == null) {
            throw new IllegalArgumentException("pDate2 was not specified");
        }
        Calendar vC1 = Calendar.getInstance();
        Calendar vC2 = Calendar.getInstance();
        int vMonthDiff = 0;
        vC1.setTime(pDate1);
        vC2.setTime(pDate2);
        if (pDate2.before(pDate1)) {
            vC1.setTime(pDate2);
            vC2.setTime(pDate1);
        }
        while (vC1.before(vC2)) {
            vC1.add(2, 1);
            ++vMonthDiff;
        }
        return vMonthDiff;
    }

    public static long getDaysDifference(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            throw new IllegalArgumentException("pDate1 was not specified");
        }
        if (pDate2 == null) {
            throw new IllegalArgumentException("pDate2 was not specified");
        }
        Calendar vC1 = Calendar.getInstance();
        Calendar vC2 = Calendar.getInstance();
        vC1.setTime(pDate1);
        vC2.setTime(pDate2);
        if (pDate2.before(pDate1)) {
            vC1.setTime(pDate2);
            vC2.setTime(pDate1);
        }
        vC1.set(11, 0);
        vC1.set(12, 0);
        vC1.set(13, 0);
        vC1.set(14, 0);
        vC2.set(11, 0);
        vC2.set(12, 0);
        vC2.set(13, 0);
        vC2.set(14, 0);
        return (vC2.getTime().getTime() - vC1.getTime().getTime()) / 86400000L;
    }

    public static long getHoursDifference(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            throw new IllegalArgumentException("pDate1 was not specified");
        }
        if (pDate2 == null) {
            throw new IllegalArgumentException("pDate2 was not specified");
        }
        Calendar vC1 = Calendar.getInstance();
        Calendar vC2 = Calendar.getInstance();
        vC1.setTime(pDate1);
        vC2.setTime(pDate2);
        if (pDate2.before(pDate1)) {
            vC1.setTime(pDate2);
            vC2.setTime(pDate1);
        }
        return Math.round((double)(vC2.getTime().getTime() - vC1.getTime().getTime()) / 3600000.0);
    }

    public static long getMinutesDifference(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            throw new IllegalArgumentException("pDate1 was not specified");
        }
        if (pDate2 == null) {
            throw new IllegalArgumentException("pDate2 was not specified");
        }
        Calendar vC1 = Calendar.getInstance();
        Calendar vC2 = Calendar.getInstance();
        vC1.setTime(pDate1);
        vC2.setTime(pDate2);
        if (pDate2.before(pDate1)) {
            vC1.setTime(pDate2);
            vC2.setTime(pDate1);
        }
        return Math.round((double)(vC2.getTime().getTime() - vC1.getTime().getTime()) / 60000.0);
    }

    public static boolean isDatesEqualByDay(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            throw new IllegalArgumentException("pDate1 was not specified");
        }
        if (pDate2 == null) {
            throw new IllegalArgumentException("pDate2 was not specified");
        }
        Calendar vC1 = Calendar.getInstance();
        Calendar vC2 = Calendar.getInstance();
        vC1.setTime(pDate1);
        vC2.setTime(pDate2);
        return vC1.get(1) == vC2.get(1) && vC1.get(2) == vC2.get(2) && vC1.get(5) == vC2.get(5);
    }

    public static boolean isDatesEqualByMonth(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            throw new IllegalArgumentException("pDate1 was not specified");
        }
        if (pDate2 == null) {
            throw new IllegalArgumentException("pDate2 was not specified");
        }
        Calendar vC1 = Calendar.getInstance();
        Calendar vC2 = Calendar.getInstance();
        vC1.setTime(pDate1);
        vC2.setTime(pDate2);
        return vC1.get(1) == vC2.get(1) && vC1.get(2) == vC2.get(2);
    }

    public static Date add(Date pDate, int pField, int pAmount) {
        if (pDate == null) {
            throw new IllegalArgumentException("pDate was not specified");
        }
        Calendar vDate = Calendar.getInstance();
        vDate.setTime(pDate);
        vDate.add(pField, pAmount);
        return vDate.getTime();
    }

    public static Date oldestDate(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            return pDate2;
        }
        if (pDate2 == null) {
            return pDate1;
        }
        if (pDate1.before(pDate2)) {
            return pDate1;
        }
        return pDate2;
    }

    public static Date newestDate(Date pDate1, Date pDate2) {
        if (pDate1 == null) {
            return pDate2;
        }
        if (pDate2 == null) {
            return pDate1;
        }
        if (pDate1.after(pDate2)) {
            return pDate1;
        }
        return pDate2;
    }

    public static Date makeStartOfMonth(Date pDate) {
        if (pDate == null) {
            throw new IllegalArgumentException("pDate was not specified");
        }
        Calendar vDate = Calendar.getInstance();
        vDate.setTime(pDate);
        vDate.set(5, 1);
        vDate.set(11, 0);
        vDate.set(12, 0);
        vDate.set(13, 0);
        vDate.set(14, 0);
        return vDate.getTime();
    }

    public static Date makeEndOfMonth(Date pDate) {
        if (pDate == null) {
            throw new IllegalArgumentException("pDate was not specified");
        }
        Calendar vDate = Calendar.getInstance();
        vDate.setTime(pDate);
        vDate.set(5, 1);
        vDate.set(11, 0);
        vDate.set(12, 0);
        vDate.set(13, 0);
        vDate.set(14, 0);
        vDate.add(2, 1);
        vDate.add(14, -1);
        return vDate.getTime();
    }

    public static Date makeStartOfDay(Date pDate) {
        if (pDate == null) {
            throw new IllegalArgumentException("pDate was not specified");
        }
        Calendar vDate = Calendar.getInstance();
        vDate.setTime(pDate);
        vDate.set(11, 0);
        vDate.set(12, 0);
        vDate.set(13, 0);
        vDate.set(14, 0);
        return vDate.getTime();
    }

    public static Date makeEndOfDay(Date pDate) {
        if (pDate == null) {
            throw new IllegalArgumentException("pDate was not specified");
        }
        Calendar vDate = Calendar.getInstance();
        vDate.setTime(DateUtils.add(DateUtils.makeStartOfDay(pDate), 5, 1));
        vDate.add(14, -1);
        return vDate.getTime();
    }

    public static Date addMonths(Date pDate, int pMonths) {
        if (pDate == null) {
            throw new IllegalArgumentException("pDate was not specified");
        }
        Calendar vDate = Calendar.getInstance();
        vDate.setTime(pDate);
        vDate.add(2, pMonths);
        return vDate.getTime();
    }

    public static boolean isDatesEqual(Date pDate1, Date pDate2, int pUnitOfMeasure, int pAmount) {
        if (pDate1 == null) {
            throw new IllegalArgumentException("pDate1 was not specified");
        }
        if (pDate2 == null) {
            throw new IllegalArgumentException("pDate2 was not specified");
        }
        long vDiff = Math.abs(pDate1.getTime() - pDate2.getTime());
        switch (pUnitOfMeasure) {
            case 1: {
                return vDiff <= (long)pAmount;
            }
            case 2: {
                return vDiff <= (long)(pAmount * 1000);
            }
            case 3: {
                return vDiff <= (long)(pAmount * 1000 * 60);
            }
            case 4: {
                return vDiff <= (long)(pAmount * 1000 * 60 * 60);
            }
            case 5: {
                return vDiff <= (long)(pAmount * 1000 * 60 * 60 * 24);
            }
        }
        throw new IllegalArgumentException("Unknown unit of measure specified");
    }

    public static boolean isDateValid(String pDate, String pPattern) {
        try {
            SimpleDateFormat vSimpleDateFormat = new SimpleDateFormat(pPattern);
            vSimpleDateFormat.setLenient(false);
            vSimpleDateFormat.parse(pDate);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static double convertTime(long pTime, int pFromUnitOfMeasure, int pToUnitOfMeasure) {
        double vResult;
        block4: {
            int[] vFactors;
            block3: {
                vResult = pTime;
                vFactors = new int[]{1000, 60, 60, 24};
                if (pFromUnitOfMeasure == pToUnitOfMeasure) {
                    return pTime;
                }
                if (pFromUnitOfMeasure >= pToUnitOfMeasure) break block3;
                for (int i = pFromUnitOfMeasure; i < pToUnitOfMeasure; ++i) {
                    vResult /= (double)vFactors[i - 1];
                }
                break block4;
            }
            if (pFromUnitOfMeasure <= pToUnitOfMeasure) break block4;
            for (int i = pToUnitOfMeasure; i < pFromUnitOfMeasure; ++i) {
                vResult *= (double)vFactors[i - 1];
            }
        }
        return vResult;
    }

    public static Date getMaxDate() {
        return new Date(Long.MAX_VALUE);
    }
}

