/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.NamingException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDISupport;
import net.za.pwnconsulting.javaconfig.support.ApplicationContext;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocatorException;
import net.za.pwnconsulting.javaconfig.support.BasicApplicationContext;
import net.za.pwnconsulting.javaconfig.support.IApplicationContextLocator;

class J2EEApplicationContextLocator
implements IApplicationContextLocator {
    public static final String APP_CTX_WEBMVC_PATH = "WebMVC";
    public static final String APP_CTX_JNDI_PATH = "ApplicationContext";
    public static final String JNDI_CFG_PATH = "/properties/jndi.properties";
    private static final Object mLock = new Object();

    J2EEApplicationContextLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext getApplicationContext() throws ApplicationContextLocatorException {
        try {
            Properties vMap = this.getJNDIProperties();
            JNDISupport vJNDI = new JNDISupport(vMap);
            Object object = mLock;
            synchronized (object) {
                ApplicationContext vAppContext = null;
                try {
                    vAppContext = (ApplicationContext)vJNDI.lookup("WebMVC/ApplicationContext");
                    if (vAppContext == null) {
                        throw new NamingException();
                    }
                    return vAppContext;
                }
                catch (NamingException e) {
                    try {
                        if (vJNDI.lookup(APP_CTX_WEBMVC_PATH) == null) {
                            throw new NamingException();
                        }
                    }
                    catch (NamingException e2) {
                        vJNDI.getInitialContext().createSubcontext(APP_CTX_WEBMVC_PATH);
                    }
                    vAppContext = new BasicApplicationContext();
                    vJNDI.getInitialContext().bind("WebMVC/ApplicationContext", (Object)vAppContext);
                    return vAppContext;
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new ApplicationContextLocatorException("Error in looking up ApplicationContext in JNDI: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new ApplicationContextLocatorException("Could not initialize or use JNDI subsystem: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApplicationContextLocatorException("Could not initialize JNDI subsystem: " + e.getMessage(), e);
        }
    }

    private Properties getJNDIProperties() throws JNDIException, IOException {
        Properties vProps = new Properties();
        InputStream vIS = this.getClass().getResourceAsStream(JNDI_CFG_PATH);
        if (vIS == null) {
            throw new JNDIException("Could not locate jndi properties file in resource path [/properties/jndi.properties]");
        }
        vProps.load(vIS);
        return vProps;
    }

    public static void main(String[] args) throws ApplicationContextLocatorException {
        new J2EEApplicationContextLocator().getApplicationContext();
    }
}

