/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.config.DBLayerConfiguration;
import net.za.pwnconsulting.javaconfig.beans.BeanFactory;
import net.za.pwnconsulting.javaconfig.core.BasicConfiguration;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.support.ApplicationContext;
import org.apache.log4j.Logger;

public abstract class AbstractApplicationContext
implements ApplicationContext {
    private static Map mBasicConfigurations;
    private static Map mDBLayerConfigurations;
    private static int mRefCount;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$DBLayer;

    protected AbstractApplicationContext() {
        mBasicConfigurations = new HashMap();
        mDBLayerConfigurations = new HashMap();
        mRefCount = 0;
    }

    public BeanFactory getDBLayerBeanFactory(String pAppName) throws ConfigurationException {
        if (pAppName == null || pAppName.equals("")) {
            throw new ConfigurationException("No Application Name was specified for the DBLayer Bean Factory");
        }
        if (!mDBLayerConfigurations.containsKey(pAppName)) {
            throw new ConfigurationException("DBLayerConfiguration object does not yet exist for application [" + pAppName + "]");
        }
        return ((DBLayerConfiguration)mDBLayerConfigurations.get(pAppName)).getBeanFactory();
    }

    public DBLayer getDBLayer(String pAppName) throws ConfigurationException {
        try {
            return (DBLayer)this.getDBLayerBeanFactory(pAppName).getBean(class$net$za$pwnconsulting$dblayer$DBLayer == null ? (class$net$za$pwnconsulting$dblayer$DBLayer = AbstractApplicationContext.class$("net.za.pwnconsulting.dblayer.DBLayer")) : class$net$za$pwnconsulting$dblayer$DBLayer);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not locate DBLayer in the BeanFactory: " + e.getMessage(), e);
        }
    }

    public BeanFactory getBeanFactory(String pAppName) throws ConfigurationException {
        if (pAppName == null || pAppName.equals("")) {
            throw new ConfigurationException("No Application Name was specified for the BasicConfiguration");
        }
        BasicConfiguration vBC = (BasicConfiguration)mBasicConfigurations.get(pAppName);
        if (vBC == null) {
            throw new ConfigurationException("No Basic Configuration was found for application [" + pAppName + "] in the ApplicationContext");
        }
        return vBC.getBeanFactory();
    }

    public BasicConfiguration getBasicConfiguration(String pAppName) throws ConfigurationException {
        if (pAppName == null || pAppName.equals("")) {
            throw new ConfigurationException("No Application Name was specified for the BasicConfiguration");
        }
        BasicConfiguration vBC = (BasicConfiguration)mBasicConfigurations.get(pAppName);
        if (vBC == null) {
            throw new ConfigurationException("No Basic Configuration was found for application [" + pAppName + "] in the ApplicationContext");
        }
        return vBC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBasicConfiguration(String pBasicConfigurationFilePath, String pAppName, boolean pLoadDBLayer) throws ConfigurationException {
        if (pBasicConfigurationFilePath == null) {
            throw new ConfigurationException("No Basic Configuration File Path was specified for ApplicationContext");
        }
        Map map = mBasicConfigurations;
        synchronized (map) {
            BasicConfiguration vBasicConfiguration;
            ++mRefCount;
            String vAppName = pAppName;
            if (pAppName == null || !mBasicConfigurations.containsKey(pAppName)) {
                vBasicConfiguration = new BasicConfiguration();
                vBasicConfiguration.init(pBasicConfigurationFilePath);
                vAppName = vBasicConfiguration.getAppName();
                if (!mBasicConfigurations.containsKey(vAppName)) {
                    mBasicConfigurations.put(vAppName, vBasicConfiguration);
                    BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "BasicConfiguration for application [" + vAppName + "] loaded.");
                } else {
                    BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "BasicConfiguration for application [" + vAppName + "] already loaded - discarding...");
                }
            }
            if (pLoadDBLayer && !mDBLayerConfigurations.containsKey(vAppName)) {
                BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Kick-starting DBConnectionLayer for application [" + vAppName + "]...");
                try {
                    vBasicConfiguration = (BasicConfiguration)mBasicConfigurations.get(vAppName);
                    if (!vBasicConfiguration.existsSpecificNode("/j2ee-app/dblayer/@configfile_path")) {
                        BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_JAVACONFIG, "Could not locate the entry in [j2ee-app] for the configuration file location of [dblayer].  This warning may safely be ignored if DBLayer is not used in this project.");
                    } else {
                        mDBLayerConfigurations.put(vAppName, new DBLayerConfiguration(vBasicConfiguration));
                    }
                }
                catch (LinkageError e) {
                    BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "DBConnectionLayer not loaded because of a class Linkage error for application [" + vAppName + "].  " + "This could happen if dblayer.jar is not in the same class loader scope than javaconfig*.jar. Remember, " + "even if DBLayer is not configured (or used), it is still required that dblayer.jar be deployed with javaconfig*.jar.");
                    throw e;
                }
                BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "DBConnectionLayer for application [" + vAppName + "] is running...");
            } else if (!pLoadDBLayer) {
                BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "DBConnectionLayer for application [" + vAppName + "] skipped.");
            } else {
                BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "DBConnectionLayer for application [" + vAppName + "] already loaded.");
            }
        }
    }

    public void addBasicConfiguration(String pBasicConfigurationFilePath, String pAppName) throws ConfigurationException {
        this.addBasicConfiguration(pBasicConfigurationFilePath, pAppName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map map = mBasicConfigurations;
        synchronized (map) {
            if (--mRefCount > 0) {
                return;
            }
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Shutting down ApplicationContext....");
            Iterator vI = mDBLayerConfigurations.keySet().iterator();
            while (vI.hasNext()) {
                ((DBLayerConfiguration)mDBLayerConfigurations.get(vI.next())).shutdown();
            }
            vI = mBasicConfigurations.keySet().iterator();
            while (vI.hasNext()) {
                ((BasicConfiguration)mBasicConfigurations.get(vI.next())).shutdown();
            }
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Shut down ApplicationContext");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

