/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.security;

import java.math.BigInteger;
import java.util.List;
import net.za.pwnconsulting.javaconfig.security.ACL;
import net.za.pwnconsulting.javaconfig.security.RoleNotFoundException;
import net.za.pwnconsulting.javaconfig.security.Roles;
import net.za.pwnconsulting.javaconfig.security.Rule;

public class RuleFilterHelper {
    private RuleFilterHelper() {
    }

    public static boolean applyRulesToRoles(List pUserRoles, Roles pSystemRoles, ACL pACL) throws RoleNotFoundException {
        int i;
        boolean vAccessGranted = pACL.isAllowByDefault();
        BigInteger vEffectiveRoles = BigInteger.ZERO;
        for (i = 0; i < pUserRoles.size(); ++i) {
            Integer vRole = (Integer)pUserRoles.get(i);
            vEffectiveRoles = vEffectiveRoles.or(pSystemRoles.getRoleByID(vRole).getPrivilege());
        }
        for (i = 0; i < pACL.getRules().size(); ++i) {
            Rule vRule = (Rule)pACL.getRules().get(i);
            if (!vEffectiveRoles.testBit(vRule.getPrivilege())) continue;
            if (vRule.getRuleType() == 0) {
                vAccessGranted = true;
                if (!pACL.isAllowByDefault()) continue;
                break;
            }
            if (vRule.getRuleType() != 1) continue;
            vAccessGranted = false;
            if (!pACL.isAllowByDefault()) break;
        }
        return vAccessGranted;
    }

    public static boolean applyRulesToRoles(List pUserRoles, Roles pSystemRoles, String pPrivilege) throws RoleNotFoundException {
        for (int i = 0; i < pUserRoles.size(); ++i) {
            Integer vRole = (Integer)pUserRoles.get(i);
            if (!pSystemRoles.getRoleByID(vRole).hasPrivilege(pPrivilege)) continue;
            return true;
        }
        return false;
    }
}

