/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.security;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.javaconfig.exceptions.InvalidDataException;
import net.za.pwnconsulting.javaconfig.security.Role;
import net.za.pwnconsulting.javaconfig.security.RoleNotFoundException;
import net.za.pwnconsulting.javaconfig.utils.Utils;

public class Roles {
    private List mRoles = new ArrayList();

    public void addRole(Role pRole) throws InvalidDataException {
        if (pRole == null || Utils.isEmptyString(pRole.getName())) {
            throw new InvalidDataException("Role not specified");
        }
        this.mRoles.add(pRole);
    }

    public BigInteger getRoleValueByName(String pRoleName) throws RoleNotFoundException {
        for (int i = 0; i < this.mRoles.size(); ++i) {
            Role vRole = (Role)this.mRoles.get(i);
            if (!vRole.getName().equals(pRoleName)) continue;
            return vRole.getPrivilege();
        }
        throw new RoleNotFoundException("Role [" + pRoleName + "] was not found");
    }

    public int getRoleIDByName(String pRoleName) throws RoleNotFoundException {
        for (int i = 0; i < this.mRoles.size(); ++i) {
            Role vRole = (Role)this.mRoles.get(i);
            if (!vRole.getName().equals(pRoleName)) continue;
            return vRole.getUniqueID();
        }
        throw new RoleNotFoundException("Role [" + pRoleName + "] was not found");
    }

    public BigInteger getRoleValueByID(int pRoleID) throws RoleNotFoundException {
        for (int i = 0; i < this.mRoles.size(); ++i) {
            Role vRole = (Role)this.mRoles.get(i);
            if (vRole.getUniqueID() != pRoleID) continue;
            return vRole.getPrivilege();
        }
        throw new RoleNotFoundException("Role [" + pRoleID + "] was not found");
    }

    public Role getRoleByID(int pRoleID) throws RoleNotFoundException {
        for (int i = 0; i < this.mRoles.size(); ++i) {
            Role vRole = (Role)this.mRoles.get(i);
            if (vRole.getUniqueID() != pRoleID) continue;
            return vRole;
        }
        throw new RoleNotFoundException("Role [" + pRoleID + "] was not found");
    }

    public List getAllRoles() {
        return this.mRoles;
    }

    public List getAllVisibleRoles() {
        ArrayList<Role> vRoles = new ArrayList<Role>();
        for (int i = 0; i < this.mRoles.size(); ++i) {
            Role vRole = (Role)this.mRoles.get(i);
            if (!vRole.isVisible()) continue;
            vRoles.add(vRole);
        }
        return vRoles;
    }
}

