/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.security;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.javaconfig.security.Privilege;

public class Role {
    private String mName;
    private int mUniqueID;
    private boolean mVisible;
    private List mPrivileges;

    public Role(String pName, int pUniqueID, boolean pVisible, List pPrivileges) {
        this.mName = pName;
        this.mUniqueID = pUniqueID;
        this.mVisible = pVisible;
        this.mPrivileges = pPrivileges == null ? new ArrayList() : pPrivileges;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String pName) {
        this.mName = pName;
    }

    public int getUniqueID() {
        return this.mUniqueID;
    }

    public void setUniqueID(int pUniqueID) {
        this.mUniqueID = pUniqueID;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setVisible(boolean pVisible) {
        this.mVisible = pVisible;
    }

    public BigInteger getPrivilege() {
        BigInteger vEffectivePrivilege = BigInteger.ZERO;
        for (int i = 0; i < this.mPrivileges.size(); ++i) {
            int vPrivilege = ((Privilege)this.mPrivileges.get(i)).getValue();
            vEffectivePrivilege = vEffectivePrivilege.setBit(vPrivilege);
        }
        return vEffectivePrivilege;
    }

    public boolean hasPrivilege(String pPrivilege) {
        for (int i = 0; i < this.mPrivileges.size(); ++i) {
            if (!((Privilege)this.mPrivileges.get(i)).getName().equals(pPrivilege)) continue;
            return true;
        }
        return false;
    }

    public void addPrivilege(Privilege pPrivilege) {
        this.mPrivileges.add(pPrivilege);
    }
}

