/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.security;

import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.javaconfig.exceptions.InvalidDataException;
import net.za.pwnconsulting.javaconfig.security.Privilege;
import net.za.pwnconsulting.javaconfig.security.PrivilegeNotFoundException;
import net.za.pwnconsulting.javaconfig.utils.Utils;

public class Privileges {
    private List mPrivileges = new ArrayList();

    public void addPrivilege(Privilege pPrivilege) throws InvalidDataException {
        if (pPrivilege == null || Utils.isEmptyString(pPrivilege.getName())) {
            throw new InvalidDataException("Privilege not specified");
        }
        this.mPrivileges.add(pPrivilege);
    }

    public int getPrivilegeValueByName(String pPrivilegeName) throws PrivilegeNotFoundException {
        return this.getPrivilegeByName(pPrivilegeName).getValue();
    }

    public Privilege getPrivilegeByName(String pPrivilegeName) throws PrivilegeNotFoundException {
        for (int i = 0; i < this.mPrivileges.size(); ++i) {
            Privilege vPrivilege = (Privilege)this.mPrivileges.get(i);
            if (!vPrivilege.getName().equals(pPrivilegeName)) continue;
            return vPrivilege;
        }
        throw new PrivilegeNotFoundException("Privilege [" + pPrivilegeName + "] was not found");
    }
}

