/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.net;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeFailureException;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class HttpClient {
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());
    private int mReadTimeout;
    private static final int DEFAULT_READ_TIMEOUT = 60000;

    public HttpClient(int pReadTimeout) {
        this.mReadTimeout = pReadTimeout;
    }

    public HttpClient() {
        this.mReadTimeout = 60000;
    }

    public String executeGETRequest(String pServerAddress, int pServerPort, String pPath, Map pGetRequest) throws IOException {
        return this.executeGETRequest(pServerAddress, pServerPort, pPath, pGetRequest, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeGETRequest(String pServerAddress, int pServerPort, String pPath, Map pGetRequest, ProxyDetails pProxyDetails) throws IOException {
        try {
            StringBuffer vGetRequest = new StringBuffer();
            if (pGetRequest != null) {
                Iterator vI = pGetRequest.keySet().iterator();
                while (vI.hasNext()) {
                    if (vGetRequest.length() > 0) {
                        vGetRequest.append("&");
                    }
                    String vName = URLEncoder.encode((String)vI.next(), "UTF-8");
                    String vValue = URLEncoder.encode((String)pGetRequest.get(vName), "UTF-8");
                    vGetRequest.append(vName).append("=").append(vValue);
                }
            }
            URL vServer = new URL("http", pServerAddress, pServerPort, (!pPath.startsWith("/") ? "/" : "") + pPath + (pGetRequest != null && pGetRequest.size() > 0 ? "?" + vGetRequest.toString() : ""));
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Requesting GET for URL [" + vServer.toExternalForm() + "]");
            Socket vSocket = new Socket(pProxyDetails == null ? pServerAddress : pProxyDetails.getProxyAddress(), pProxyDetails == null ? pServerPort : pProxyDetails.getProxyPort());
            vSocket.setSoTimeout(this.mReadTimeout);
            try {
                OutputStreamWriter vWriter = new OutputStreamWriter(vSocket.getOutputStream(), "ISO-8859-1");
                try {
                    vWriter.write("GET " + vServer.toExternalForm() + " HTTP/1.0\r\n");
                    vWriter.write("Host: " + vServer.getHost() + "\r\n");
                    if (pProxyDetails != null && !Utils.isEmptyString(pProxyDetails.getUserName())) {
                        vWriter.write("Proxy-Authorization: Basic " + new BASE64Encoder().encode((pProxyDetails.getUserName() + ":" + pProxyDetails.getPassword()).getBytes()) + "\r\n");
                    }
                    vWriter.write("\r\n");
                    ((Writer)vWriter).flush();
                    StringBuffer vResponse = new StringBuffer();
                    BufferedReader vReader = new BufferedReader(new InputStreamReader(vSocket.getInputStream(), "ISO-8859-1"));
                    try {
                        String vLine = vReader.readLine();
                        if (!Utils.makeProperString(vLine).startsWith("HTTP/")) throw new IOException("Bad protocol in response [" + vLine + "]");
                        int vSP = vLine.indexOf(32);
                        String vStatus = vLine.substring(vSP + 1, vSP + 4);
                        if (!vStatus.equals("200")) throw new FileNotFoundException("Server [" + pServerAddress + "] reported an HTTP error [" + vStatus + "]");
                        boolean vInHeader = true;
                        while (vLine != null) {
                            vLine = vReader.readLine();
                            if (vLine == null) continue;
                            if (vLine.length() <= 0 && vInHeader) {
                                vInHeader = false;
                                continue;
                            }
                            if (vInHeader) continue;
                            vResponse.append(vLine).append("\n");
                        }
                        String vResponseString = vResponse.toString();
                        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Got reply for GET for URL [" + vResponseString + "]");
                        String string = vResponseString;
                        return string;
                    }
                    finally {
                        vReader.close();
                    }
                }
                finally {
                    ((Writer)vWriter).close();
                }
            }
            finally {
                vSocket.close();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeFailureException("The ISO-8859-1 character set was not found in this Java installation: " + e.getMessage(), e);
        }
    }

    public static class ProxyDetails {
        private String mUserName;
        private String mPassword;
        private String mProxyAddress;
        private int mProxyPort;

        public ProxyDetails(String pProxyAddress, int pProxyPort) {
            this(pProxyAddress, pProxyPort, null, null);
        }

        public ProxyDetails(String pProxyAddress, int pProxyPort, String pUserName, String pPassword) {
            this.mUserName = pUserName;
            this.mPassword = pPassword;
            this.mProxyAddress = pProxyAddress;
            this.mProxyPort = pProxyPort;
        }

        public String getUserName() {
            return this.mUserName;
        }

        public String getPassword() {
            return this.mPassword;
        }

        public String getProxyAddress() {
            return this.mProxyAddress;
        }

        public int getProxyPort() {
            return this.mProxyPort;
        }
    }
}

