/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeNestedException;
import net.za.pwnconsulting.javaconfig.mail.Attachment;
import net.za.pwnconsulting.javaconfig.mail.ByteArrayDataSource;
import net.za.pwnconsulting.javaconfig.mail.EMailException;
import net.za.pwnconsulting.javaconfig.mail.Mail;
import net.za.pwnconsulting.javaconfig.utils.StringUtils;

public class SMTPMail
implements Mail {
    private String mSMTPServer;
    private String mSMTPPort;
    private String mFrom;
    private String[] mTo;
    private String[] mCC;
    private String[] mBCC;
    private String mSubject;
    private String mData;
    private Session mSession;
    private List mAttachments;

    public void setMailData(String pFrom, String[] pTo, String[] pCC, String[] pBCC, String pSubject, String pData) {
        this.mFrom = pFrom;
        this.mTo = pTo;
        this.mCC = pCC;
        this.mBCC = pBCC;
        this.mSubject = pSubject;
        this.mData = pData;
        this.mAttachments = new ArrayList();
    }

    public void addAttachment(Attachment pAttachment) {
        this.mAttachments.add(pAttachment);
    }

    public void sendEMail() throws EMailException {
        try {
            int i;
            if (this.mSMTPServer == null || this.mSMTPServer.equals("")) {
                throw new IllegalArgumentException("The SMTP Server was not specified.  Call setMailSettings() first.");
            }
            MimeMessage vMessage = new MimeMessage(this.mSession);
            vMessage.setFrom((Address)new InternetAddress(this.mFrom));
            if (this.mTo == null) {
                throw new IllegalArgumentException("The To address cannot be null");
            }
            for (i = 0; i < this.mTo.length; ++i) {
                vMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.mTo[i]));
            }
            if (this.mCC != null) {
                for (i = 0; i < this.mCC.length; ++i) {
                    vMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(this.mCC[i]));
                }
            }
            if (this.mBCC != null) {
                for (i = 0; i < this.mBCC.length; ++i) {
                    vMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(this.mBCC[i]));
                }
            }
            vMessage.setSentDate(new Date());
            vMessage.setSubject(this.mSubject);
            String vData = StringUtils.replaceAll(this.mData, "\\n", "\n");
            if (this.mAttachments.size() <= 0) {
                vMessage.setText(vData);
            } else {
                MimeMultipart vMP = new MimeMultipart();
                MimeBodyPart vMBP = new MimeBodyPart();
                vMBP.setText(vData);
                vMP.addBodyPart((BodyPart)vMBP);
                for (int i2 = 0; i2 < this.mAttachments.size(); ++i2) {
                    Attachment vAtt = (Attachment)this.mAttachments.get(i2);
                    vMBP = new MimeBodyPart();
                    ByteArrayDataSource vDS = new ByteArrayDataSource(vAtt.getData(), vAtt.getContentType());
                    vMBP.setDataHandler(new DataHandler((DataSource)vDS));
                    vMBP.setFileName(vAtt.getFileName());
                    vMP.addBodyPart((BodyPart)vMBP);
                }
                vMessage.setContent((Multipart)vMP);
            }
            Transport.send((Message)vMessage);
        }
        catch (ParseException e) {
            throw new RuntimeNestedException("Error sending mail: " + e.getMessage(), e);
        }
        catch (MessagingException e) {
            throw new EMailException("Error sending mail: " + e.getMessage(), e);
        }
    }

    public void setMailSettings(String pSMTPServer, int pSMTPPort) {
        this.mSMTPServer = pSMTPServer;
        this.mSMTPPort = Integer.toString(pSMTPPort);
        Properties vProps = System.getProperties();
        vProps.put("mail.smtp.host", this.mSMTPServer);
        vProps.put("mail.smtp.port", this.mSMTPPort);
        this.mSession = Session.getInstance((Properties)vProps);
    }

    public void setMailSettings(String pSMTPServer, int pSMTPPort, final String pUsername, final String pPassword, boolean pEnableTLS) {
        this.mSMTPServer = pSMTPServer;
        this.mSMTPPort = Integer.toString(pSMTPPort);
        Properties vProps = System.getProperties();
        vProps.put("mail.smtp.host", this.mSMTPServer);
        vProps.put("mail.smtp.port", this.mSMTPPort);
        vProps.put("mail.smtp.auth", "true");
        vProps.put("mail.smtp.user", pUsername);
        vProps.put("mail.smtp.password", pPassword);
        vProps.put("mail.smtp.starttls.enable", pEnableTLS ? "true" : "false");
        this.mSession = Session.getInstance((Properties)vProps, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(pUsername, pPassword);
            }
        });
    }

    public void setMailSettings(String pSMTPServer) {
        this.setMailSettings(pSMTPServer, 25);
    }
}

