/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.mail;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    private String mContentType;
    private byte[] mData;

    public ByteArrayDataSource(InputStream pInputStream, String pContentType) throws IOException {
        this.mContentType = pContentType;
        ByteArrayOutputStream vBAOS = new ByteArrayOutputStream();
        BufferedOutputStream vBOS = new BufferedOutputStream(vBAOS);
        int vLen = -1;
        byte[] vData = new byte[1024];
        while ((vLen = pInputStream.read(vData)) != -1) {
            for (int i = 0; i < vLen; ++i) {
                vBOS.write(vData[i]);
            }
        }
        this.mData = vBAOS.toByteArray();
    }

    public ByteArrayDataSource(byte[] pData, String pContentType) {
        this.mData = pData;
        this.mContentType = pContentType;
    }

    public ByteArrayDataSource(String pData, String pContentType) {
        try {
            this.mContentType = pContentType;
            this.mData = pData.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.mData == null) {
            throw new IOException("No data available to return");
        }
        return new ByteArrayInputStream(this.mData);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Unsupported operation");
    }

    public String getContentType() {
        return this.mContentType;
    }

    public String getName() {
        return "ByteArrayDataSource";
    }
}

