/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.j2ee.jndi.storage;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.Settings;
import net.za.pwnconsulting.javaconfig.exceptions.NoMatchFoundException;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeFailureException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDISupport;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.storage.AbstractJNDIStorage;
import net.za.pwnconsulting.javaconfig.support.ApplicationContext;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocatorException;
import net.za.pwnconsulting.javaconfig.utils.Pair;
import net.za.pwnconsulting.javaconfig.utils.StringUtils;

public class LAJNDIStorage
extends AbstractJNDIStorage {
    public static final String APP_CTX_WEBMVC_PATH = "WebMVC";
    private static final String JNDI_STORAGE_PREFIX = "__Storage__";
    private static String mHOST_ADDRESS;

    public void setObjectTransacted(String pObjectToSaveName, Object pObjectToSave, SQLBatch pSQLBatch) throws JNDIException {
        throw new UnsupportedOperationException("Method not supported in LA Storage");
    }

    public synchronized void setObject(String pObjectToSaveName, Object pObjectToSave) throws JNDIException {
        try {
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            JNDISupport vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            if (!vJNDISupport.exists("WebMVC/__Storage__" + pObjectToSaveName)) {
                try {
                    if (!vJNDISupport.exists(APP_CTX_WEBMVC_PATH)) {
                        throw new NamingException();
                    }
                }
                catch (NamingException e) {
                    try {
                        vJNDISupport.getInitialContext().createSubcontext(APP_CTX_WEBMVC_PATH);
                    }
                    catch (NamingException e1) {
                        throw new JNDIException("Could not create subcontext [WebMVC] for JNDI storage: " + e.getMessage(), e);
                    }
                }
            }
            vJNDISupport.rebind("WebMVC/__Storage__" + pObjectToSaveName, pObjectToSave);
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    public synchronized Object getObject(String pObjectToRetrieveName) throws JNDIException, NoMatchFoundException {
        try {
            JNDISupport vJNDISupport;
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            try {
                vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            }
            catch (ConfigurationException e) {
                throw new JNDIException("Configuration Error: " + e.getMessage(), e);
            }
            if (!vJNDISupport.exists("WebMVC/__Storage__" + pObjectToRetrieveName)) {
                throw new NoMatchFoundException("The object [" + pObjectToRetrieveName + "] does not exist in the JNDI tree");
            }
            return vJNDISupport.lookup("WebMVC/__Storage__" + pObjectToRetrieveName);
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    public synchronized void removeObject(String pObjectToRemoveName) throws JNDIException {
        try {
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            JNDISupport vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            if (!vJNDISupport.exists("WebMVC/__Storage__" + pObjectToRemoveName)) {
                return;
            }
            vJNDISupport.unbind("WebMVC/__Storage__" + pObjectToRemoveName);
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    public synchronized boolean exists(String pObjectToEnquireName) throws JNDIException {
        try {
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            JNDISupport vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            return vJNDISupport.exists("WebMVC/__Storage__" + pObjectToEnquireName);
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    public synchronized boolean existsObjectByContent(String pObjectToEnquireNameStartsWith, Object pObjectToFind) throws JNDIException {
        try {
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            JNDISupport vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            try {
                NamingEnumeration<Binding> vEnum = vJNDISupport.getInitialContext().listBindings(APP_CTX_WEBMVC_PATH);
                while (vEnum.hasMore()) {
                    Binding vBinding = vEnum.next();
                    if (vBinding.getName() == null || !vBinding.getName().startsWith(JNDI_STORAGE_PREFIX + pObjectToEnquireNameStartsWith) || !vBinding.getObject().equals(pObjectToFind)) continue;
                    return true;
                }
            }
            catch (NamingException e) {
                if (!vJNDISupport.exists(APP_CTX_WEBMVC_PATH)) {
                    return false;
                }
                throw e;
            }
            return false;
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    public synchronized List enumerateObjects(String pObjectToEnquireNameStartsWith) throws JNDIException {
        try {
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            JNDISupport vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            ArrayList<Pair> vObjects = new ArrayList<Pair>();
            try {
                NamingEnumeration<Binding> vEnum = vJNDISupport.getInitialContext().listBindings(APP_CTX_WEBMVC_PATH);
                while (vEnum.hasMore()) {
                    Binding vBinding = vEnum.next();
                    if (vBinding.getName() == null || !vBinding.getName().startsWith(JNDI_STORAGE_PREFIX + pObjectToEnquireNameStartsWith)) continue;
                    vObjects.add(new Pair(vBinding.getName(), vBinding.getObject()));
                }
            }
            catch (NamingException e) {
                if (!vJNDISupport.exists(APP_CTX_WEBMVC_PATH)) {
                    return vObjects;
                }
                throw e;
            }
            return vObjects;
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    public synchronized void removeAllObjects(String pObjectToRemoveNameStartsWith) throws JNDIException {
        try {
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            JNDISupport vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            NamingEnumeration vEnum = vJNDISupport.listBindings(APP_CTX_WEBMVC_PATH);
            ArrayList<Binding> vBindingsToRemove = new ArrayList<Binding>();
            while (vEnum.hasMore()) {
                Binding vBinding = (Binding)vEnum.next();
                if (vBinding.getName() == null || !vBinding.getName().startsWith(JNDI_STORAGE_PREFIX + pObjectToRemoveNameStartsWith)) continue;
                vBindingsToRemove.add(vBinding);
            }
            for (int i = 0; i < vBindingsToRemove.size(); ++i) {
                Binding vBinding = (Binding)vBindingsToRemove.get(i);
                vJNDISupport.unbind("WebMVC/" + vBinding.getName());
            }
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    public synchronized void removeObjectByContent(String pObjectToRemoveNameStartsWith, Object pObjectToRemove) throws JNDIException {
        try {
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            JNDISupport vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            NamingEnumeration vEnum = vJNDISupport.listBindings(APP_CTX_WEBMVC_PATH);
            while (vEnum.hasMore()) {
                Binding vBinding = (Binding)vEnum.next();
                if (vBinding.getName() == null || !vBinding.getName().startsWith(JNDI_STORAGE_PREFIX + pObjectToRemoveNameStartsWith) || !vBinding.getObject().equals(pObjectToRemove)) continue;
                vJNDISupport.unbind("WebMVC/" + vBinding.getName());
                break;
            }
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    public synchronized Object getObjectByContent(String pObjectToRetrieveNameStartsWith, Object pObjectToRetrieve) throws JNDIException, NoMatchFoundException {
        try {
            ApplicationContextLocator vACL = new ApplicationContextLocator();
            ApplicationContext vAC = vACL.getApplicationContext();
            JNDISupport vJNDISupport = this.getJNDISupport(vAC, vACL.getApplicationName());
            NamingEnumeration vEnum = vJNDISupport.listBindings(APP_CTX_WEBMVC_PATH);
            while (vEnum.hasMore()) {
                Binding vBinding = (Binding)vEnum.next();
                if (vBinding.getName() == null || !vBinding.getName().startsWith(JNDI_STORAGE_PREFIX + pObjectToRetrieveNameStartsWith) || !vBinding.getObject().equals(pObjectToRetrieve)) continue;
                return vJNDISupport.lookup("WebMVC/" + vBinding.getName());
            }
            throw new NoMatchFoundException("The object [" + pObjectToRetrieveNameStartsWith + "] does not exist in the JNDI tree");
        }
        catch (ConfigurationException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new JNDIException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new JNDIException("JNDI Error: " + e.getMessage(), e);
        }
    }

    protected JNDISupport getJNDISupport(ApplicationContext pAC, String pApplicationName) throws ConfigurationException, JNDIException {
        Hashtable<String, String> vEnv = new Hashtable<String, String>();
        Settings vSettings = pAC.getBasicConfiguration(pApplicationName).getSettings();
        if (vSettings.existsParameterByName("jnp.sotimeout")) {
            vEnv.put("jnp.sotimeout", vSettings.getParameterByName("jnp.sotimeout"));
        }
        vEnv.put("java.naming.factory.initial", vSettings.getParameterByName("java.naming.factory.initial"));
        vEnv.put("java.naming.factory.url.pkgs", vSettings.getParameterByName("java.naming.factory.url.pkgs"));
        vEnv.put("java.naming.provider.url", StringUtils.replaceAll(vSettings.getParameterByName("java.naming.provider.url"), "[IPHAJNDIIsBoundTo]", mHOST_ADDRESS));
        return new JNDISupport(vEnv);
    }

    static {
        try {
            mHOST_ADDRESS = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeFailureException("Could not determine own IP address for JNDI Provider URL: " + e.getMessage(), e);
        }
    }
}

