/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.j2ee.jndi.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.locking.XLayerProperties;
import net.za.pwnconsulting.dblayer.parser.SQLParser;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.javaconfig.exceptions.NoMatchFoundException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.storage.AbstractJNDIStorage;
import net.za.pwnconsulting.javaconfig.support.ApplicationContext;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.utils.MapUtils;
import net.za.pwnconsulting.javaconfig.utils.Pair;
import net.za.pwnconsulting.javaconfig.utils.Utils;

public class HAJNDIStorage
extends AbstractJNDIStorage {
    public static final String DB_NAME_TABLE = "DBStorageTableName";
    public static final String DB_NAME_NAME_FIELD = "DBStorageNameFieldName";
    public static final String DB_NAME_OBJECT_FIELD = "DBStorageObjectFieldName";
    public static final String DB_NAME_POOL = "DBStoragePool";
    private static String mTableName;
    private static String mNameFieldName;
    private static String mObjectFieldName;
    private static String mAppName;
    private static String mDBPool;
    private static ApplicationContext mAC;
    static /* synthetic */ Class class$java$lang$Object;

    public void setObjectTransacted(String pObjectToSaveName, Object pObjectToSave, SQLBatch pSQLBatch) throws JNDIException {
        try {
            pSQLBatch.addSQLStatement(new SQLStatement("delete from " + mTableName + " where " + mNameFieldName + " = ?", new Object[]{pObjectToSaveName}, false));
            pSQLBatch.addSQLStatement(new SQLStatement("insert into " + mTableName + " (" + mNameFieldName + "," + mObjectFieldName + ") values (?,?)", new Object[]{pObjectToSaveName, Utils.serializeObject(pObjectToSave)}, false, "__YYY__", true, null, true));
        }
        catch (IOException e) {
            throw new JNDIException("Could not save object: " + e.getMessage(), e);
        }
    }

    public void setObject(String pObjectToSaveName, Object pObjectToSave) throws JNDIException {
        SQLBatch vSQLBatch = new SQLBatch(true, mDBPool, new XLayerProperties(true, 8));
        this.setObjectTransacted(pObjectToSaveName, pObjectToSave, vSQLBatch);
        mAC.getDBLayer(mAppName).submitTransaction(vSQLBatch);
    }

    public void removeObject(String pObjectToRemoveName) throws JNDIException {
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        SQLBatch vSQLBatch = new SQLBatch(true, mDBPool);
        vSQLBatch.addSQLStatement(new SQLStatement("delete from " + mTableName + " where " + mNameFieldName + " = ?", new Object[]{pObjectToRemoveName}, false));
        vDBLayer.submitTransaction(vSQLBatch);
    }

    public Object getObject(String pObjectToRetrieveName) throws JNDIException, NoMatchFoundException {
        try {
            DBLayer vDBLayer = mAC.getDBLayer(mAppName);
            List vRes = vDBLayer.queryDatabase("select * from " + mTableName + " where " + mNameFieldName + " = ?", new Object[]{pObjectToRetrieveName}, mDBPool);
            if (vRes.size() <= 0) {
                throw new NoMatchFoundException("The object [" + pObjectToRetrieveName + "] does not exist in the storage area");
            }
            return Utils.deserializeObject((byte[])MapUtils.getMapValue((Map)vRes.get(0), mObjectFieldName, class$java$lang$Object == null ? (class$java$lang$Object = HAJNDIStorage.class$("java.lang.Object")) : class$java$lang$Object, false));
        }
        catch (IOException e) {
            throw new JNDIException("Could not retrieve object: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new JNDIException("Could not retrieve object: " + e.getMessage(), e);
        }
    }

    public boolean exists(String pObjectToEnquireName) throws JNDIException {
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        List vRes = vDBLayer.queryDatabase("select * from " + mTableName + " where " + mNameFieldName + " = ?", new Object[]{pObjectToEnquireName}, mDBPool);
        return vRes.size() > 0;
    }

    public boolean existsObjectByContent(String pObjectToEnquireNameStartsWith, Object pObjectToFind) throws JNDIException {
        try {
            DBLayer vDBLayer = mAC.getDBLayer(mAppName);
            List vRes = vDBLayer.queryDatabase("select * from " + mTableName + " where " + mNameFieldName + " like ?", new Object[]{pObjectToEnquireNameStartsWith + "%"}, mDBPool);
            for (int i = 0; i < vRes.size(); ++i) {
                Map vRow = (Map)vRes.get(i);
                Object vObject = Utils.deserializeObject((byte[])MapUtils.getMapValue(vRow, mObjectFieldName, class$java$lang$Object == null ? HAJNDIStorage.class$("java.lang.Object") : class$java$lang$Object, false));
                if (vObject == null || pObjectToFind == null || !vObject.equals(pObjectToFind)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new JNDIException("Could not retrieve object: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new JNDIException("Could not retrieve object: " + e.getMessage(), e);
        }
    }

    public void removeAllObjects(String pObjectToRemoveNameStartsWith) throws JNDIException {
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        SQLBatch vSQLBatch = new SQLBatch(true, mDBPool);
        vSQLBatch.addSQLStatement(new SQLStatement("delete from " + mTableName + " where " + mNameFieldName + " like ?", new Object[]{pObjectToRemoveNameStartsWith + "%"}, false));
        vDBLayer.submitTransaction(vSQLBatch);
    }

    public List enumerateObjects(String pObjectToEnquireNameStartsWith) throws JNDIException {
        try {
            DBLayer vDBLayer = mAC.getDBLayer(mAppName);
            List vRes = vDBLayer.queryDatabase("select * from " + mTableName + " where " + mNameFieldName + " like ?", new Object[]{pObjectToEnquireNameStartsWith + "%"}, mDBPool);
            ArrayList<Pair> vObjects = new ArrayList<Pair>();
            for (int i = 0; i < vRes.size(); ++i) {
                Map vRow = (Map)vRes.get(i);
                Object vObject = Utils.deserializeObject((byte[])MapUtils.getMapValue(vRow, mObjectFieldName, class$java$lang$Object == null ? HAJNDIStorage.class$("java.lang.Object") : class$java$lang$Object, false));
                vObjects.add(new Pair(MapUtils.getMapValueAsString(vRow, mNameFieldName, true), vObject));
            }
            return vObjects;
        }
        catch (IOException e) {
            throw new JNDIException("Could not retrieve object: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new JNDIException("Could not retrieve object: " + e.getMessage(), e);
        }
    }

    public void removeObjectByContent(String pObjectToRemoveNameStartsWith, Object pObjectToRemove) throws JNDIException {
        try {
            DBLayer vDBLayer = mAC.getDBLayer(mAppName);
            List vRes = vDBLayer.queryDatabase("select * from " + mTableName + " where " + mNameFieldName + " like ?", new Object[]{pObjectToRemoveNameStartsWith + "%"}, mDBPool);
            ArrayList<String> vNames = new ArrayList<String>();
            for (int i = 0; i < vRes.size(); ++i) {
                Map vRow = (Map)vRes.get(i);
                Object vObject = Utils.deserializeObject((byte[])MapUtils.getMapValue(vRow, mObjectFieldName, class$java$lang$Object == null ? HAJNDIStorage.class$("java.lang.Object") : class$java$lang$Object, false));
                if (vObject == null || pObjectToRemove == null || !vObject.equals(pObjectToRemove)) continue;
                vNames.add(MapUtils.getMapValueAsString(vRow, mNameFieldName, true));
            }
            SQLBatch vSQLBatch = new SQLBatch(true, mDBPool);
            vSQLBatch.addSQLStatement(new SQLStatement(SQLParser.expandIn((String)("delete from " + mTableName + " where " + mNameFieldName + " in ()"), (Object[])vNames.toArray()), null, false));
            vDBLayer.submitTransaction(vSQLBatch);
        }
        catch (IOException e) {
            throw new JNDIException("Could not remove object: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new JNDIException("Could not remove object: " + e.getMessage(), e);
        }
    }

    public Object getObjectByContent(String pObjectToRetrieveNameStartsWith, Object pObjectToRetrieve) throws JNDIException, NoMatchFoundException {
        try {
            DBLayer vDBLayer = mAC.getDBLayer(mAppName);
            List vRes = vDBLayer.queryDatabase("select * from " + mTableName + " where " + mNameFieldName + " like ?", new Object[]{pObjectToRetrieveNameStartsWith + "%"}, mDBPool);
            for (int i = 0; i < vRes.size(); ++i) {
                Map vRow = (Map)vRes.get(i);
                Object vObject = Utils.deserializeObject((byte[])MapUtils.getMapValue(vRow, mObjectFieldName, class$java$lang$Object == null ? HAJNDIStorage.class$("java.lang.Object") : class$java$lang$Object, false));
                if (vObject == null || pObjectToRetrieve == null || !vObject.equals(pObjectToRetrieve)) continue;
                return vObject;
            }
            throw new NoMatchFoundException("The object [" + pObjectToRetrieveNameStartsWith + "] does not exist in the storage area");
        }
        catch (IOException e) {
            throw new JNDIException("Could not retrieve object: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new JNDIException("Could not retrieve object: " + e.getMessage(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mAC = new ApplicationContextLocator().getApplicationContext();
        mAppName = new ApplicationContextLocator().getApplicationName();
        mTableName = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_TABLE);
        mNameFieldName = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_NAME_FIELD);
        mObjectFieldName = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_OBJECT_FIELD);
        mDBPool = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_POOL);
    }
}

