/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.j2ee.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;
import org.apache.log4j.Logger;

public class JNDISupport {
    private Context mContext;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());

    public JNDISupport() throws JNDIException {
        try {
            this.mContext = new InitialContext();
        }
        catch (NamingException e) {
            throw new JNDIException("Could not create an initial context: " + e.getMessage(), e);
        }
    }

    public JNDISupport(Hashtable pEnvironment) throws JNDIException {
        try {
            this.mContext = new InitialContext(pEnvironment);
        }
        catch (NamingException e) {
            throw new JNDIException("Could not create an initial context: " + e.getMessage(), e);
        }
    }

    public Object lookup(String pObjectName) throws JNDIException {
        long vStart = System.currentTimeMillis();
        try {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Looking up pObjectName [" + pObjectName + "]...");
            Object vX = this.mContext.lookup(pObjectName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Looked up pObjectName [" + pObjectName + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds...");
            return vX;
        }
        catch (NamingException e) {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Failed Looked up pObjectName [" + pObjectName + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds...");
            throw new JNDIException("Could not lookup object [" + pObjectName + "] in the JNDI tree: " + e.getMessage(), e);
        }
    }

    public boolean exists(String pObjectName) throws JNDIException {
        long vStart = System.currentTimeMillis();
        try {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Exists pObjectName [" + pObjectName + "]...");
            Object vO = this.mContext.lookup(pObjectName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Exists pObjectName [" + pObjectName + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds...");
            return vO != null;
        }
        catch (NameNotFoundException e) {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Exists pObjectName [" + pObjectName + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds...");
            return false;
        }
        catch (NamingException e) {
            throw new JNDIException("Could not determine object's existence [" + pObjectName + "] in the JNDI tree: " + e.getMessage(), e);
        }
    }

    public void unbind(String pObjectName) throws JNDIException {
        long vStart = System.currentTimeMillis();
        try {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Unbind pObjectName [" + pObjectName + "]...");
            this.mContext.unbind(pObjectName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Unbind pObjectName [" + pObjectName + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds...");
        }
        catch (NamingException e) {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Failed Unbind pObjectName [" + pObjectName + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds...");
            throw new JNDIException("Could not unbind object [" + pObjectName + "] in the JNDI tree: " + e.getMessage(), e);
        }
    }

    public void rebind(String pObjectName, Object pObject) throws JNDIException {
        try {
            this.mContext.rebind(pObjectName, pObject);
        }
        catch (NamingException e) {
            throw new JNDIException("Could not rebind object [" + pObjectName + "] in the JNDI tree: " + e.getMessage(), e);
        }
    }

    public void bind(String pObjectName, Object pObject) throws JNDIException {
        long vStart = System.currentTimeMillis();
        try {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Bind pObjectName [" + pObjectName + "]...");
            this.mContext.bind(pObjectName, pObject);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Bind pObjectName [" + pObjectName + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds...");
        }
        catch (NamingException e) {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Failed Bind pObjectName [" + pObjectName + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds...");
            throw new JNDIException("Could not bind object [" + pObjectName + "] in the JNDI tree: " + e.getMessage(), e);
        }
    }

    public NamingEnumeration listBindings(String pObjectName) throws JNDIException {
        try {
            return this.mContext.listBindings(pObjectName);
        }
        catch (NamingException e) {
            throw new JNDIException("Could not list the bindings for object [" + pObjectName + "] in the JNDI tree: " + e.getMessage(), e);
        }
    }

    public Context getInitialContext() {
        return this.mContext;
    }
}

