/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.j2ee.jmx;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import net.za.pwnconsulting.javaconfig.j2ee.jmx.MBeanOperationException;

public class MBeanServerProxy {
    private String mDomainName;
    private String mKey;
    private String mValue;
    private List mServers;

    private MBeanServerProxy(String pAgentID) {
        this.mServers = MBeanServerFactory.findMBeanServer(pAgentID);
    }

    public MBeanServerProxy(String pDomainName, String pKey, String pClassName) {
        this(null, pDomainName, pKey, pClassName);
    }

    public MBeanServerProxy(String pAgentID, String pDomainName, String pKey, String pClassName) {
        this(pAgentID);
        this.mDomainName = pDomainName;
        this.mKey = pKey;
        this.mValue = pClassName;
    }

    public Object invokeMethod(String pMethodName, Object[] pParams, String[] pSignature) throws MBeanOperationException {
        try {
            return this.getFirstMBeanServer().invoke(new ObjectName(this.mDomainName, this.mKey, this.mValue), pMethodName, pParams, pSignature);
        }
        catch (MBeanException e) {
            throw new MBeanOperationException("Could not invoke the JMX method: " + e.getMessage() + ", Root Cause: " + (e.getTargetException() == null ? "Unknown" : e.getTargetException().getMessage()), e);
        }
        catch (Exception e) {
            throw new MBeanOperationException("Could not invoke the JMX method: " + e.getMessage(), e);
        }
    }

    public void setAttribute(String pAttributeName, Object pValue) throws MBeanOperationException {
        try {
            this.getFirstMBeanServer().setAttribute(new ObjectName(this.mDomainName, this.mKey, this.mValue), new Attribute(pAttributeName, pValue));
        }
        catch (MBeanException e) {
            throw new MBeanOperationException("Could not set the JMX attribute: " + e.getMessage() + ", Root Cause: " + (e.getTargetException() == null ? "Unknown" : e.getTargetException().getMessage()), e);
        }
        catch (Exception e) {
            throw new MBeanOperationException("Could not set the JMX attribute: " + e.getMessage(), e);
        }
    }

    public Object getAttribute(String pAttributeName) throws MBeanOperationException {
        try {
            return this.getFirstMBeanServer().getAttribute(new ObjectName(this.mDomainName, this.mKey, this.mValue), pAttributeName);
        }
        catch (MBeanException e) {
            throw new MBeanOperationException("Could not get the JMX attribute: " + e.getMessage() + ", Root Cause: " + (e.getTargetException() == null ? "Unknown" : e.getTargetException().getMessage()), e);
        }
        catch (Exception e) {
            throw new MBeanOperationException("Could not get the JMX attribute: " + e.getMessage(), e);
        }
    }

    private MBeanServer getFirstMBeanServer() throws MBeanOperationException {
        if (this.mServers.size() <= 0) {
            throw new MBeanOperationException("Could not locate any MBeanServer instances in the list of MBean servers");
        }
        return (MBeanServer)this.mServers.get(0);
    }
}

