/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.j2ee.jms;

import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import net.za.pwnconsulting.javaconfig.j2ee.jms.AbstractMessageComms;
import net.za.pwnconsulting.javaconfig.j2ee.jms.JMSProducerException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;

public class TopicMessageProducer
extends AbstractMessageComms {
    private Topic mTopic;

    public TopicMessageProducer() throws JMSProducerException {
        super(3, 1000);
    }

    public TopicMessageProducer(int pBrokenConRetryCount, int pBrokenConRetryWait) throws JMSProducerException {
        super(pBrokenConRetryCount, pBrokenConRetryWait);
    }

    public TopicMessageProducer(Hashtable pEnvironment) throws JMSProducerException {
        super(3, 1000, pEnvironment);
    }

    public TopicMessageProducer(int pBrokenConRetryCount, int pBrokenConRetryWait, Hashtable pEnvironment) throws JMSProducerException {
        super(pBrokenConRetryCount, pBrokenConRetryWait, pEnvironment);
    }

    protected Connection getConnection(String pConnectionFactoryName) throws JMSProducerException {
        try {
            TopicConnectionFactory mCF = (TopicConnectionFactory)this.mJNDI.lookup(pConnectionFactoryName);
            return mCF.createTopicConnection();
        }
        catch (JNDIException e) {
            throw new JMSProducerException("Could not lookup the ConnectionFactory [" + pConnectionFactoryName + "] in the JNDI tree: " + e.getMessage(), e);
        }
        catch (JMSException e) {
            throw new JMSProducerException("Could not create the topic connection for ConnectionFactory [" + pConnectionFactoryName + "] in the JNDI tree: " + e.getMessage(), e);
        }
    }

    protected void initDestination(String pProduceDestination, String pConsumeDestination) throws JMSProducerException {
        if (this.mCon == null) {
            throw new JMSProducerException("Could not initialize topic [" + pProduceDestination + "] because the TopicMessageProducer class was not initialized");
        }
        if (pProduceDestination == null || pProduceDestination.equals("")) {
            throw new JMSProducerException("Could not initialize topic because the produce destination was not specified");
        }
        if (pConsumeDestination != null) {
            throw new JMSProducerException("Could not initialize topic because the consume destination was specified, and is not supported");
        }
        try {
            this.mTopic = (Topic)this.mJNDI.lookup(pProduceDestination);
        }
        catch (JNDIException e) {
            throw new JMSProducerException("Could not lookup the Topic [" + pProduceDestination + "] in the JNDI tree: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message pMessage) throws JMSProducerException {
        if (this.mTopic == null) {
            throw new JMSProducerException("Could not publish message to topic [" + this.mProduceDestination + "] because the TopicMessageProducer class was not initialized");
        }
        int vRetryCount = 0;
        while (true) {
            try {
                TopicSession vSession = ((TopicConnection)this.mCon).createTopicSession(false, 1);
                try {
                    TopicPublisher vPublisher = vSession.createPublisher(this.mTopic);
                    try {
                        vPublisher.publish(pMessage);
                    }
                    finally {
                        vPublisher.close();
                    }
                }
                finally {
                    vSession.close();
                }
            }
            catch (JMSException e) {
                vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                continue;
            }
            break;
        }
    }

    public void sendText(String pMessage, int pDeliveryMode) throws JMSProducerException {
        try {
            TextMessage vTM = (TextMessage)this.createMessage(1);
            vTM.setJMSDeliveryMode(pDeliveryMode);
            vTM.setText(pMessage);
            this.send((Message)vTM);
        }
        catch (JMSException e) {
            throw new JMSProducerException("Could not publish the message to the topic [" + this.mProduceDestination + "] because: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message createMessage(int pMessageKind) throws JMSProducerException, JMSException {
        if (this.mTopic == null) {
            throw new JMSProducerException("Could not create message because the TopicMessageProducer class was not initialized");
        }
        int vRetryCount = 0;
        while (true) {
            try {
                TopicSession vSession = ((TopicConnection)this.mCon).createTopicSession(false, 1);
                try {
                    switch (pMessageKind) {
                        case 1: {
                            TextMessage textMessage = vSession.createTextMessage();
                            return textMessage;
                        }
                        case 3: {
                            MapMessage mapMessage = vSession.createMapMessage();
                            return mapMessage;
                        }
                        case 2: {
                            ObjectMessage objectMessage = vSession.createObjectMessage();
                            return objectMessage;
                        }
                        case 4: {
                            StreamMessage streamMessage = vSession.createStreamMessage();
                            return streamMessage;
                        }
                        case 5: {
                            BytesMessage bytesMessage = vSession.createBytesMessage();
                            return bytesMessage;
                        }
                    }
                    throw new JMSProducerException("Unknown message kind specified: [" + pMessageKind + "]");
                }
                finally {
                    vSession.close();
                }
            }
            catch (JMSException e) {
                vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                continue;
            }
            break;
        }
    }
}

