/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.j2ee.jms;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import net.za.pwnconsulting.javaconfig.exceptions.InternalConsistencyException;
import net.za.pwnconsulting.javaconfig.j2ee.jms.AbstractMessageComms;
import net.za.pwnconsulting.javaconfig.j2ee.jms.JMSProducerException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;

public class QueueMessageProducer
extends AbstractMessageComms {
    private Queue mSubmitQueue;
    private Queue mReceiveQueue;
    private final Map mTransactionalClients = new HashMap();
    private static Random RANDOM = new Random();
    private static final int MAX_CONCURRENT_TRANSACTIONS = 1000;

    public QueueMessageProducer() throws JMSProducerException {
        super(3, 1000);
    }

    public QueueMessageProducer(int pBrokenConRetryCount, int pBrokenConRetryWait) throws JMSProducerException {
        super(pBrokenConRetryCount, pBrokenConRetryWait);
    }

    public QueueMessageProducer(Hashtable pEnvironment) throws JMSProducerException {
        super(3, 1000, pEnvironment);
    }

    public QueueMessageProducer(int pBrokenConRetryCount, int pBrokenConRetryWait, Hashtable pEnvironment) throws JMSProducerException {
        super(pBrokenConRetryCount, pBrokenConRetryWait, pEnvironment);
    }

    public String beginTransaction() {
        return this.beginTransactionInternal(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String beginTransactionInternal(String pToken) {
        String vToken;
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        if (pToken == null || pToken.trim().equals("")) {
            vToken = this.generateNewToken();
            if (this.mTransactionalClients.containsKey(vToken)) {
                throw new InternalConsistencyException("Duplicate token generated - this is never supposed to happen.");
            }
            if (this.mTransactionalClients.size() > 1000) {
                throw new JMSProducerException("The maximum concurrent transaction threshold of [1000] has been exceeded - refusing to start new transaction");
            }
        } else {
            vToken = this.resolveOriginalReference(pToken);
        }
        String string = vToken;
        synchronized (string) {
            int vRetryCount = 0;
            while (true) {
                try {
                    QueueSession vQueueSession = ((QueueConnection)this.mCon).createQueueSession(true, -1);
                    Map map = this.mTransactionalClients;
                    synchronized (map) {
                        this.mTransactionalClients.put(vToken, vQueueSession);
                    }
                }
                catch (JMSException e) {
                    vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                    continue;
                }
                break;
            }
            return vToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveOriginalReference(String pToken) {
        Map map = this.mTransactionalClients;
        synchronized (map) {
            Iterator vI = this.mTransactionalClients.keySet().iterator();
            while (vI.hasNext()) {
                String vKey = (String)vI.next();
                if (!vKey.equals(pToken)) continue;
                return vKey;
            }
        }
        throw new InternalConsistencyException("Could not find token [" + pToken + "] in internal token list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(String pToken) {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        if (!this.mTransactionalClients.containsKey(pToken)) {
            throw new JMSProducerException("Could not commit the transaction since the token [" + pToken + "] is not part of an active transaction");
        }
        String string = this.resolveOriginalReference(pToken);
        synchronized (string) {
            try {
                Map map;
                QueueSession vQueueSession = (QueueSession)this.mTransactionalClients.get(pToken);
                try {
                    vQueueSession.commit();
                    Object var5_5 = null;
                    map = this.mTransactionalClients;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    Map map2 = this.mTransactionalClients;
                    synchronized (map2) {
                        this.mTransactionalClients.remove(pToken);
                    }
                    vQueueSession.close();
                    throw throwable;
                }
                synchronized (map) {
                    this.mTransactionalClients.remove(pToken);
                }
                vQueueSession.close();
                {
                }
            }
            catch (JMSException e) {
                throw new JMSProducerException("Could not commit the transaction: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(String pToken) {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        if (!this.mTransactionalClients.containsKey(pToken)) {
            throw new JMSProducerException("Could not roll back the transaction since the token [" + pToken + "] is not part of an active transaction");
        }
        String string = this.resolveOriginalReference(pToken);
        synchronized (string) {
            try {
                Map map;
                QueueSession vQueueSession = (QueueSession)this.mTransactionalClients.get(pToken);
                try {
                    vQueueSession.rollback();
                    Object var5_5 = null;
                    map = this.mTransactionalClients;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    Map map2 = this.mTransactionalClients;
                    synchronized (map2) {
                        this.mTransactionalClients.remove(pToken);
                    }
                    vQueueSession.close();
                    throw throwable;
                }
                synchronized (map) {
                    this.mTransactionalClients.remove(pToken);
                }
                vQueueSession.close();
                {
                }
            }
            catch (JMSException e) {
                throw new JMSProducerException("Could not roll back the transaction: " + e.getMessage(), e);
            }
        }
    }

    protected Connection getConnection(String pConnectionFactoryName) throws JMSProducerException {
        try {
            QueueConnectionFactory vCF = (QueueConnectionFactory)this.mJNDI.lookup(pConnectionFactoryName);
            return vCF.createQueueConnection();
        }
        catch (JNDIException e) {
            throw new JMSProducerException("Could not lookup the ConnectionFactory [" + pConnectionFactoryName + "] in the JNDI tree: " + e.getMessage(), e);
        }
        catch (JMSException e) {
            String vLinkedError = e.getLinkedException() != null ? e.getLinkedException().getMessage() : "<<Linked Exception not available>>";
            throw new JMSProducerException("Could not create the queue connection for ConnectionFactory [" + pConnectionFactoryName + "] in the JNDI tree: " + e.getMessage() + ", Linked Exception: " + vLinkedError, e);
        }
    }

    protected void initDestination(String pProduceDestination, String pConsumeDestination) throws JMSProducerException {
        if (this.mCon == null && pProduceDestination != null) {
            throw new JMSProducerException("Could not initialize queue [" + pProduceDestination + "] because the QueueMessageProducer class was not initialized");
        }
        if (this.mCon == null && pConsumeDestination != null) {
            throw new JMSProducerException("Could not initialize queue [" + pConsumeDestination + "] because the QueueMessageConsumer class was not initialized");
        }
        if (pProduceDestination == null && pConsumeDestination == null) {
            throw new JMSProducerException("Could not initialize queues because none were specified");
        }
        try {
            if (pProduceDestination != null) {
                this.mSubmitQueue = (Queue)this.mJNDI.lookup(pProduceDestination);
            }
            if (pConsumeDestination != null) {
                this.mReceiveQueue = (Queue)this.mJNDI.lookup(pConsumeDestination);
            }
        }
        catch (JNDIException e) {
            StringBuffer vMsg = new StringBuffer("Could not lookup the Queue(s) [");
            if (pProduceDestination != null) {
                vMsg.append(pProduceDestination);
            }
            if (pConsumeDestination != null) {
                if (pProduceDestination != null) {
                    vMsg.append(",");
                }
                vMsg.append(pProduceDestination);
            }
            vMsg.append("] in the JNDI tree: ").append(e.getMessage());
            throw new JMSProducerException(vMsg.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message pMessage) throws JMSProducerException {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        if (this.mSubmitQueue == null) {
            throw new JMSProducerException("Could not send message to queue [" + this.mProduceDestination + "] because the QueueMessageProducer class was not initialized");
        }
        int vRetryCount = 0;
        while (true) {
            try {
                QueueSession vSession = ((QueueConnection)this.mCon).createQueueSession(false, 1);
                try {
                    QueueSender vSender = vSession.createSender(this.mSubmitQueue);
                    try {
                        vSender.send(pMessage);
                    }
                    finally {
                        vSender.close();
                    }
                }
                finally {
                    vSession.close();
                }
            }
            catch (JMSException e) {
                vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String pToken, Message pMessage) throws JMSProducerException {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        if (this.mSubmitQueue == null) {
            throw new JMSProducerException("Could not send message to queue [" + this.mProduceDestination + "] because the QueueMessageProducer class was not initialized");
        }
        if (!this.mTransactionalClients.containsKey(pToken)) {
            throw new JMSProducerException("Could not send the message as part of a transaction since the token [" + pToken + "] is not part of an active transaction");
        }
        String string = this.resolveOriginalReference(pToken);
        synchronized (string) {
            int vRetryCount = 0;
            while (true) {
                try {
                    if (vRetryCount > 0) {
                        this.beginTransactionInternal(pToken);
                    }
                    QueueSession vQueueSession = (QueueSession)this.mTransactionalClients.get(pToken);
                    QueueSender vSender = vQueueSession.createSender(this.mSubmitQueue);
                    try {
                        vSender.send(pMessage);
                    }
                    finally {
                        vSender.close();
                    }
                }
                catch (JMSException e) {
                    try {
                        this.rollbackTransaction(pToken);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                    continue;
                }
                break;
            }
        }
    }

    public Message sendAndReceive(Message pMessage, int pTimeout, String pMessageSelector) throws JMSProducerException {
        this.send(pMessage);
        return this.receive(pTimeout, pMessageSelector);
    }

    public Message sendAndReceive(String pToken, Message pMessage, int pTimeout, String pMessageSelector) throws JMSProducerException {
        this.send(pToken, pMessage);
        return this.receive(pToken, pTimeout, pMessageSelector);
    }

    public Message receive(int pTimeout, String pMessageSelector) throws JMSProducerException {
        return this.receiveInternal(pTimeout, pMessageSelector, false);
    }

    public Message receive(String pToken, int pTimeout, String pMessageSelector) throws JMSProducerException {
        return this.receiveInternal(pToken, pTimeout, pMessageSelector, false);
    }

    public Message receiveNoWait(String pMessageSelector) throws JMSProducerException {
        return this.receiveInternal(-1, pMessageSelector, true);
    }

    public Message receiveNoWait(String pToken, String pMessageSelector) throws JMSProducerException {
        return this.receiveInternal(pToken, -1, pMessageSelector, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveInternal(int pTimeout, String pMessageSelector, boolean pReturnImmediately) throws JMSProducerException {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        Message vMsg = null;
        if (this.mReceiveQueue == null) {
            throw new JMSProducerException("Could not receive message on queue [" + this.mConsumeDestination + "] because the QueueMessageConsumer class was not initialized for receiving messages");
        }
        int vRetryCount = 0;
        while (true) {
            try {
                QueueSession vSession = ((QueueConnection)this.mCon).createQueueSession(false, 1);
                try {
                    QueueReceiver vReceiver = vSession.createReceiver(this.mReceiveQueue, pMessageSelector);
                    try {
                        this.mCon.start();
                        try {
                            vMsg = pReturnImmediately ? vReceiver.receiveNoWait() : vReceiver.receive((long)pTimeout);
                        }
                        finally {
                            try {
                                this.mCon.stop();
                            }
                            catch (Exception e) {}
                        }
                    }
                    finally {
                        vReceiver.close();
                    }
                }
                finally {
                    vSession.close();
                }
                return vMsg;
            }
            catch (JMSException e) {
                vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveInternal(String pToken, int pTimeout, String pMessageSelector, boolean pReturnImmediately) throws JMSProducerException {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        Message vMsg = null;
        if (this.mReceiveQueue == null) {
            throw new JMSProducerException("Could not receive message on queue [" + this.mConsumeDestination + "] because the QueueMessageConsumer class was not initialized for receiving messages");
        }
        if (!this.mTransactionalClients.containsKey(pToken)) {
            throw new JMSProducerException("Could not receive a message as part of a transaction since the token [" + pToken + "] is not part of an active transaction");
        }
        String string = this.resolveOriginalReference(pToken);
        synchronized (string) {
            int vRetryCount = 0;
            while (true) {
                try {
                    if (vRetryCount > 0) {
                        this.beginTransactionInternal(pToken);
                    }
                    QueueSession vQueueSession = (QueueSession)this.mTransactionalClients.get(pToken);
                    QueueReceiver vReceiver = vQueueSession.createReceiver(this.mReceiveQueue, pMessageSelector);
                    try {
                        this.mCon.start();
                        try {
                            vMsg = pReturnImmediately ? vReceiver.receiveNoWait() : vReceiver.receive((long)pTimeout);
                        }
                        finally {
                            try {
                                this.mCon.stop();
                            }
                            catch (Exception e) {}
                        }
                    }
                    finally {
                        vReceiver.close();
                    }
                    return vMsg;
                }
                catch (JMSException e) {
                    try {
                        this.rollbackTransaction(pToken);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                    continue;
                }
                break;
            }
        }
    }

    public void sendText(String pMessage, int pDeliveryMode) throws JMSProducerException {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        try {
            TextMessage vTM = (TextMessage)this.createMessage(1);
            vTM.setJMSDeliveryMode(pDeliveryMode);
            vTM.setText(pMessage);
            this.send((Message)vTM);
        }
        catch (JMSException e) {
            throw new JMSProducerException("Could not send the message to the queue [" + this.mProduceDestination + "] because: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendText(String pToken, String pMessage, int pDeliveryMode) throws JMSProducerException {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        if (!this.mTransactionalClients.containsKey(pToken)) {
            throw new JMSProducerException("Could not send the text message as part of a transaction since the token [" + pToken + "] is not part of an active transaction");
        }
        String string = this.resolveOriginalReference(pToken);
        synchronized (string) {
            try {
                TextMessage vTM = (TextMessage)this.createMessage(pToken, 1);
                vTM.setJMSDeliveryMode(pDeliveryMode);
                vTM.setText(pMessage);
                this.send(pToken, (Message)vTM);
            }
            catch (JMSException e) {
                throw new JMSProducerException("Could not send the message to the queue [" + this.mProduceDestination + "] because: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message createMessage(int pMessageKind) throws JMSProducerException, JMSException {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        if (this.mSubmitQueue == null) {
            throw new JMSProducerException("Could not create message because the QueueMessageProducer class was not initialized");
        }
        int vRetryCount = 0;
        while (true) {
            Message message;
            QueueSession vSession = ((QueueConnection)this.mCon).createQueueSession(false, 1);
            try {
                message = this.createMessageInternal(vSession, pMessageKind);
            }
            catch (Throwable throwable) {
                try {
                    vSession.close();
                    throw throwable;
                }
                catch (JMSException e) {
                    vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                    continue;
                }
            }
            vSession.close();
            return message;
            break;
        }
    }

    public Message createMessage(String pToken, int pMessageKind) throws JMSProducerException, JMSException {
        if (!this.mInitialised) {
            throw new JMSProducerException("QueueMessageProducer has not yet been initialised - i.e. init() has not yet been called");
        }
        if (this.mSubmitQueue == null) {
            throw new JMSProducerException("Could not create message because the QueueMessageProducer class was not initialized");
        }
        if (!this.mTransactionalClients.containsKey(pToken)) {
            throw new JMSProducerException("Could not create the text message as part of a transaction since the token [" + pToken + "] is not part of an active transaction");
        }
        String string = this.resolveOriginalReference(pToken);
        synchronized (string) {
            int vRetryCount = 0;
            while (true) {
                try {
                    QueueSession vQueueSession = (QueueSession)this.mTransactionalClients.get(pToken);
                    return this.createMessageInternal(vQueueSession, pMessageKind);
                }
                catch (JMSException e) {
                    try {
                        this.rollbackTransaction(pToken);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    vRetryCount = this.handlePotentialBrokenCon(vRetryCount, e);
                    continue;
                }
                break;
            }
        }
    }

    private Message createMessageInternal(QueueSession pSession, int pMessageKind) throws JMSException {
        switch (pMessageKind) {
            case 1: {
                return pSession.createTextMessage();
            }
            case 3: {
                return pSession.createMapMessage();
            }
            case 2: {
                return pSession.createObjectMessage();
            }
            case 4: {
                return pSession.createStreamMessage();
            }
            case 5: {
                return pSession.createBytesMessage();
            }
        }
        throw new JMSProducerException("Unknown message kind specified: [" + pMessageKind + "]");
    }

    private String generateNewToken() {
        return new BigInteger(128, RANDOM).toString(32).toUpperCase();
    }
}

