/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.j2ee.jms;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.JMSException;
import net.za.pwnconsulting.javaconfig.j2ee.jms.JMSMessageComms;
import net.za.pwnconsulting.javaconfig.j2ee.jms.JMSProducerException;
import net.za.pwnconsulting.javaconfig.j2ee.jms.vendors.JMSIndependantVendorFactory;
import net.za.pwnconsulting.javaconfig.j2ee.jms.vendors.JMSVendorException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDISupport;

public abstract class AbstractMessageComms
implements JMSMessageComms {
    protected static final int BROKEN_CON_RETRY_COUNT = 3;
    protected static final int BROKEN_CON_RETRY_WAIT = 1000;
    protected String mConnectionFactoryName;
    protected String mProduceDestination;
    protected String mConsumeDestination;
    protected Connection mCon;
    protected JNDISupport mJNDI;
    protected boolean mInitialised = false;
    protected int mBrokenConRetryCount = 3;
    protected int mBrokenConRetryWait = 1000;
    protected String mJMSProvider = "Undefined";

    protected AbstractMessageComms(int pBrokenConRetryCount, int pBrokenConRetryWait) throws JMSProducerException {
        try {
            this.mJNDI = new JNDISupport();
            this.mBrokenConRetryCount = pBrokenConRetryCount;
            this.mBrokenConRetryWait = pBrokenConRetryWait;
            this.mInitialised = false;
        }
        catch (JNDIException e) {
            throw new JMSProducerException("Could not initialize the JNDI subsystem: " + e.getMessage(), e);
        }
    }

    protected AbstractMessageComms(int pBrokenConRetryCount, int pBrokenConRetryWait, Hashtable pEnvironment) throws JMSProducerException {
        try {
            this.mJNDI = new JNDISupport(pEnvironment);
            this.mBrokenConRetryCount = pBrokenConRetryCount;
            this.mBrokenConRetryWait = pBrokenConRetryWait;
            this.mInitialised = false;
        }
        catch (JNDIException e) {
            throw new JMSProducerException("Could not initialize the JNDI subsystem: " + e.getMessage(), e);
        }
    }

    public synchronized void init(String pConnectionFactoryName, String pProduceDestination, String pConsumeDestination) throws JMSProducerException {
        this.mConnectionFactoryName = pConnectionFactoryName;
        this.mProduceDestination = pProduceDestination;
        this.mConsumeDestination = pConsumeDestination;
        try {
            if (this.mInitialised) {
                this.deinit();
            }
            this.mCon = this.getConnection(pConnectionFactoryName);
            if (this.mCon == null) {
                throw new JMSProducerException("Could not retrieve a new connection from Connection Factory [" + pConnectionFactoryName + "]");
            }
            if (this.mCon.getMetaData() == null) {
                throw new JMSException("getMetaData() returned null");
            }
            this.mJMSProvider = this.mCon.getMetaData().getJMSProviderName();
            this.initDestination(pProduceDestination, pConsumeDestination);
            this.mInitialised = true;
        }
        catch (JMSException e) {
            throw new JMSProducerException("Could not determine the name of the JMS provider: " + e.getMessage(), e);
        }
    }

    protected abstract void initDestination(String var1, String var2) throws JMSProducerException;

    protected abstract Connection getConnection(String var1) throws JMSProducerException;

    public synchronized void deinit() throws JMSProducerException {
        try {
            this.mInitialised = false;
            if (this.mCon != null) {
                this.mCon.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized int handlePotentialBrokenCon(int pRetryCount, JMSException pException) throws JMSProducerException {
        try {
            if (!this.isBrokenConnection(pException)) {
                throw new JMSProducerException("Could not [send/receive the message to/from the queue/topic] or [begin/commit/rollback the transaction] because: " + (pException == null ? "<<Unavailable>>" : pException.getMessage()) + " (Linked Exception: " + (pException.getLinkedException() == null ? "<<Unavailable>>" : pException.getLinkedException().getMessage()) + ")", pException);
            }
            while (true) {
                if (pRetryCount >= this.mBrokenConRetryCount) {
                    throw new JMSProducerException("Could not [send/receive the message to/from the queue/topic] or [begin/commit/rollback the transaction] because broken connection retry count was exceeded (" + pRetryCount + "/" + this.mBrokenConRetryCount + "): " + (pException == null ? "<<Unavailable>>" : pException.getMessage()) + " (Linked Exception: " + (pException.getLinkedException() == null ? "<<Unavailable>>" : pException.getLinkedException().getMessage()) + ")", pException);
                }
                ++pRetryCount;
                try {
                    this.deinit();
                }
                catch (JMSProducerException e1) {
                    // empty catch block
                }
                try {
                    this.mCon = this.getConnection(this.mConnectionFactoryName);
                }
                catch (JMSProducerException e2) {
                    if (this.isBrokenConnection((JMSException)e2.getRootCause())) continue;
                    throw e2;
                }
                break;
            }
            return pRetryCount;
        }
        catch (JMSVendorException e) {
            throw new JMSProducerException("Could not determine whether this is a broken connection exception: " + e.getMessage(), e);
        }
    }

    protected boolean isBrokenConnection(JMSException pException) throws JMSVendorException {
        return new JMSIndependantVendorFactory(this.mJMSProvider).getJMSVendor().isBrokenConnection(pException);
    }
}

