/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ExceptionHelper {
    private ExceptionHelper() {
    }

    public static String getFullStackTrace(Throwable pException) {
        if (pException == null) {
            return "No exception object specified to produce a stack trace for";
        }
        try {
            ByteArrayOutputStream vB = new ByteArrayOutputStream();
            PrintStream vPS = new PrintStream(vB);
            pException.printStackTrace(vPS);
            boolean vSupportsRootCause = ExceptionHelper.supportsGetRootCause(pException.getClass());
            boolean vSupportsCause = ExceptionHelper.supportsGetCause(pException.getClass());
            boolean vSupportsGetNextException = ExceptionHelper.supportsGetNextException(pException.getClass());
            boolean vSupportsGetLinkedException = ExceptionHelper.supportsGetLinkedException(pException.getClass());
            if (vSupportsRootCause || vSupportsCause || vSupportsGetNextException || vSupportsGetLinkedException) {
                Throwable vRootCause;
                Throwable throwable = vSupportsGetNextException ? ExceptionHelper.getNextException(pException) : (vSupportsRootCause ? ExceptionHelper.getRootCause(pException) : (vRootCause = vSupportsGetLinkedException ? ExceptionHelper.getLinkedException(pException) : ExceptionHelper.getCause(pException)));
                while (vRootCause != null) {
                    vPS.println((vSupportsGetNextException ? "Next Exception: " : (vSupportsRootCause ? "Root Cause: " : (vSupportsGetLinkedException ? "Linked Exception: " : "Cause: "))) + vRootCause.getMessage());
                    vRootCause.printStackTrace(vPS);
                    vSupportsRootCause = ExceptionHelper.supportsGetRootCause(vRootCause.getClass());
                    vSupportsCause = ExceptionHelper.supportsGetCause(vRootCause.getClass());
                    vSupportsGetNextException = ExceptionHelper.supportsGetNextException(vRootCause.getClass());
                    vSupportsGetLinkedException = ExceptionHelper.supportsGetLinkedException(vRootCause.getClass());
                    if (vSupportsRootCause || vSupportsCause || vSupportsGetNextException || vSupportsGetLinkedException) {
                        vRootCause = vSupportsGetNextException ? ExceptionHelper.getNextException(vRootCause) : (vSupportsRootCause ? ExceptionHelper.getRootCause(vRootCause) : (vSupportsGetLinkedException ? ExceptionHelper.getLinkedException(vRootCause) : ExceptionHelper.getCause(vRootCause)));
                        continue;
                    }
                    vRootCause = null;
                }
            }
            return vB.toString();
        }
        catch (Exception e) {
            return "Problem generating stack trace: " + e.getMessage();
        }
    }

    public static Throwable getParentCause(Throwable pException) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        boolean vSupportsRootCause = ExceptionHelper.supportsGetRootCause(pException.getClass());
        boolean vSupportsCause = ExceptionHelper.supportsGetCause(pException.getClass());
        boolean vSupportsGetNextException = ExceptionHelper.supportsGetNextException(pException.getClass());
        boolean vSupportsGetLinkedException = ExceptionHelper.supportsGetLinkedException(pException.getClass());
        if (vSupportsRootCause || vSupportsCause || vSupportsGetNextException || vSupportsGetLinkedException) {
            return vSupportsGetNextException ? ExceptionHelper.getNextException(pException) : (vSupportsRootCause ? ExceptionHelper.getRootCause(pException) : (vSupportsGetLinkedException ? ExceptionHelper.getLinkedException(pException) : ExceptionHelper.getCause(pException)));
        }
        return null;
    }

    private static Throwable getRootCause(Throwable pException) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method vMethod = pException.getClass().getMethod("getRootCause", null);
        return (Throwable)vMethod.invoke((Object)pException, null);
    }

    private static Throwable getNextException(Throwable pException) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method vMethod = pException.getClass().getMethod("getNextException", null);
        return (Throwable)vMethod.invoke((Object)pException, null);
    }

    private static Throwable getLinkedException(Throwable pException) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method vMethod = pException.getClass().getMethod("getLinkedException", null);
        return (Throwable)vMethod.invoke((Object)pException, null);
    }

    private static Throwable getCause(Throwable pException) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method vMethod = pException.getClass().getMethod("getCause", null);
        return (Throwable)vMethod.invoke((Object)pException, null);
    }

    private static boolean supportsGetRootCause(Class pException) {
        Method[] vMethods = pException.getMethods();
        for (int i = 0; i < vMethods.length; ++i) {
            if (!vMethods[i].getName().equals("getRootCause")) continue;
            return true;
        }
        return false;
    }

    private static boolean supportsGetCause(Class pException) {
        Method[] vMethods = pException.getMethods();
        for (int i = 0; i < vMethods.length; ++i) {
            if (!vMethods[i].getName().equals("getCause")) continue;
            return true;
        }
        return false;
    }

    private static boolean supportsGetNextException(Class pException) {
        Method[] vMethods = pException.getMethods();
        for (int i = 0; i < vMethods.length; ++i) {
            if (!vMethods[i].getName().equals("getNextException")) continue;
            return true;
        }
        return false;
    }

    private static boolean supportsGetLinkedException(Class pException) {
        Method[] vMethods = pException.getMethods();
        for (int i = 0; i < vMethods.length; ++i) {
            if (!vMethods[i].getName().equals("getLinkedException")) continue;
            return true;
        }
        return false;
    }
}

