/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.dao;

import java.util.List;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.DBLayerException;
import net.za.pwnconsulting.dblayer.locking.XLayerProperties;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.dblayer.trans.TransactionResult;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.dao.BasicDAO;
import net.za.pwnconsulting.javaconfig.exceptions.DAOException;
import net.za.pwnconsulting.javaconfig.security.principal.UserACL;
import net.za.pwnconsulting.javaconfig.support.ApplicationContext;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocatorException;
import net.za.pwnconsulting.javaconfig.vo.BasicVO;
import org.apache.log4j.Logger;

public abstract class AbstractBasicDAO
implements BasicDAO {
    protected final String mPoolName;
    protected UserACL mUserACL;
    protected final DBLayer mDBLayer;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());

    protected AbstractBasicDAO(String pPoolName, UserACL pUserACL) throws DAOException {
        try {
            this.mPoolName = pPoolName;
            this.mUserACL = pUserACL;
            ApplicationContextLocator vApplicationContextLocator = new ApplicationContextLocator();
            this.mDBLayer = vApplicationContextLocator.getApplicationContext().getDBLayer(vApplicationContextLocator.getApplicationName());
        }
        catch (ConfigurationException e) {
            throw new DAOException("Configuration problem getting DBLayer: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new DAOException("Could not retrieve the ApplicationContext: " + e.getMessage(), e);
        }
    }

    protected AbstractBasicDAO(String pPoolName) throws DAOException {
        this(pPoolName, null);
    }

    protected TransactionResult save(BasicVO pBasicVO, boolean pCritical) throws DAOException {
        return this.saveExtended(pBasicVO, pCritical, new XLayerProperties());
    }

    protected TransactionResult saveExtended(BasicVO pBasicVO, boolean pCritical, XLayerProperties pXLayerProperties) throws DAOException {
        try {
            SQLBatch vBatch = new SQLBatch(pCritical, this.mPoolName, pXLayerProperties);
            this.saveTransacted(pBasicVO, vBatch);
            return this.mDBLayer.submitTransaction(vBatch);
        }
        catch (DBLayerException e) {
            throw new DAOException("Could not save the entity: " + e.getMessage(), e);
        }
    }

    protected abstract void saveTransacted(BasicVO var1, SQLBatch var2) throws DAOException;

    protected ApplicationContext getApplicationContext() throws DAOException {
        try {
            return new ApplicationContextLocator().getApplicationContext();
        }
        catch (ApplicationContextLocatorException e) {
            throw new DAOException("Could not locate the Application Context: " + e.getMessage(), e);
        }
    }

    protected String buildInsertString(String pTableName, List pFields, List pOutParams) {
        StringBuffer vSQL = new StringBuffer("insert into " + pTableName + " (");
        StringBuffer vSQLValuesClause = new StringBuffer(" values (");
        int vFieldsAddedCount = 0;
        for (int i = 0; i < pFields.size(); ++i) {
            SQLField vSQLField = (SQLField)pFields.get(i);
            if (vSQLField.isProtected()) continue;
            if (vFieldsAddedCount > 0) {
                vSQL.append(",");
                vSQLValuesClause.append(",");
            }
            vSQL.append(vSQLField.getSQLFieldName());
            pOutParams.add(vSQLField.getValue());
            vSQLValuesClause.append("?");
            ++vFieldsAddedCount;
        }
        vSQL.append(")");
        vSQL.append(vSQLValuesClause);
        vSQL.append(")");
        return vSQL.toString();
    }

    protected String buildInsertStringV2(String pTableName, List pFields, List pOutParams) {
        StringBuffer vSQL = new StringBuffer("insert into " + pTableName + " (");
        StringBuffer vSQLValuesClause = new StringBuffer(" values (");
        int vFieldsAddedCount = 0;
        for (int i = 0; i < pFields.size(); ++i) {
            SQLField vSQLField = (SQLField)pFields.get(i);
            if (vFieldsAddedCount > 0) {
                vSQL.append(",");
                vSQLValuesClause.append(",");
            }
            vSQL.append(vSQLField.getSQLFieldName());
            pOutParams.add(vSQLField.getValue());
            vSQLValuesClause.append("?");
            ++vFieldsAddedCount;
        }
        vSQL.append(")");
        vSQL.append(vSQLValuesClause);
        vSQL.append(")");
        return vSQL.toString();
    }

    protected String buildUpdateString(String pTableName, List pFields, List pOutParams, SQLField pPrimaryKeyField) {
        StringBuffer vSQL = new StringBuffer("update " + pTableName + " set ");
        StringBuffer vSQLValuesClause = new StringBuffer(" where " + pPrimaryKeyField.getSQLFieldName() + " = ?");
        int vFieldsAddedCount = 0;
        for (int i = 0; i < pFields.size(); ++i) {
            SQLField vSQLField = (SQLField)pFields.get(i);
            if (vSQLField.isProtected()) continue;
            if (vFieldsAddedCount > 0) {
                vSQL.append(",");
            }
            vSQL.append(vSQLField.getSQLFieldName()).append(" = ?");
            pOutParams.add(vSQLField.getValue());
            ++vFieldsAddedCount;
        }
        vSQL.append(vSQLValuesClause);
        pOutParams.add(pPrimaryKeyField.getValue());
        return vSQL.toString();
    }

    public class SQLField {
        private String mSQLFieldName;
        private Object mValue;
        private boolean mProtected;

        public SQLField(String pSQLFieldName, Object pValue) {
            this(pSQLFieldName, pValue, false);
        }

        public SQLField(String pSQLFieldName, Object pValue, boolean pProtected) {
            this.mSQLFieldName = pSQLFieldName;
            this.mValue = pValue;
            this.mProtected = pProtected;
        }

        public String getSQLFieldName() {
            return this.mSQLFieldName;
        }

        public Object getValue() {
            return this.mValue;
        }

        public boolean isProtected() {
            return this.mProtected;
        }
    }
}

