/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.crypto;

import net.za.pwnconsulting.javaconfig.crypto.LicenseKeyAlg;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeFailureException;

public abstract class LicenseKeyAlgorithm {
    private int mWordCount;
    private byte[] mSeed;
    private byte[] mWF;
    private int mENF;
    private int mNENF;
    private int mPENF;
    private LicenseKeyAlg mLicenseKeyAlg;

    public LicenseKeyAlgorithm(LicenseKeyAlg pLicenseKeyAlg, int pWordCount, byte[] pSeed, byte[] pWF, int pENF, int pNENF, int pPENF) {
        if (pWordCount != 4) {
            throw new RuntimeFailureException("WordCount may only be 4 in this release of JavaConfig");
        }
        if (pSeed == null || pSeed.length != pWordCount * 4) {
            throw new IllegalArgumentException("The Seed array must be specified and must be of length [pWordCount * 4]");
        }
        for (int i = 0; i < pSeed.length; ++i) {
            if (pSeed[i] != 0 && pSeed[i] <= 20) continue;
            throw new IllegalArgumentException("The Seed array cannot contain entries with a value of 0 or larget than 20");
        }
        if (pWF == null || pWF.length != pWordCount) {
            throw new IllegalArgumentException("The WF array must be specified and must be of length [pWordCount]");
        }
        if (pENF <= 0 || pENF > 1000) {
            throw new IllegalArgumentException("The ENF parameter must be in the range [1,1000]");
        }
        if (pNENF <= 0 || pNENF > 1000) {
            throw new IllegalArgumentException("The NENF parameter must be in the range [1,1000]");
        }
        if (pPENF <= 0) {
            throw new IllegalArgumentException("The NENF parameter must be in the range [1,MAX_INT]");
        }
        this.mLicenseKeyAlg = pLicenseKeyAlg;
        this.mWordCount = pWordCount;
        this.mSeed = pSeed;
        this.mWF = pWF;
        this.mENF = pENF;
        this.mNENF = pNENF;
        this.mPENF = pPENF;
    }

    public String[] generateKeys(int pKeyCount) {
        if (pKeyCount < 0) {
            throw new IllegalArgumentException("The key count cannot be zero or a negative number");
        }
        return this.mLicenseKeyAlg.generateKeys(new LicenseAlgParams(this.mWordCount, this.mSeed, this.mWF, this.mENF, this.mNENF, this.mPENF), pKeyCount);
    }

    public boolean verifyKey(String pKey) {
        if (pKey == null) {
            throw new IllegalArgumentException("The key to verify must be specified");
        }
        return this.mLicenseKeyAlg.verifyKey(new LicenseAlgParams(this.mWordCount, this.mSeed, this.mWF, this.mENF, this.mNENF, this.mPENF), pKey);
    }

    class LicenseAlgParams {
        public int mWordCount;
        public byte[] mSeed;
        public byte[] mWF;
        public int mENF;
        public int mNENF;
        public int mPENF;

        public LicenseAlgParams(int pWordCount, byte[] pSeed, byte[] pWF, int pENF, int pNENF, int pPENF) {
            this.mWordCount = pWordCount;
            this.mSeed = pSeed;
            this.mWF = pWF;
            this.mENF = pENF;
            this.mNENF = pNENF;
            this.mPENF = pPENF;
        }
    }
}

