/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.crypto;

import java.math.BigInteger;
import java.util.Date;
import java.util.Random;
import net.za.pwnconsulting.javaconfig.crypto.LicenseKeyAlg;
import net.za.pwnconsulting.javaconfig.crypto.LicenseKeyAlgorithm;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import net.za.pwnconsulting.javaconfig.utils.encryption.SHAHash;

public class BasicLicenseKeyAlgorithm
implements LicenseKeyAlg {
    public int mMisses = 0;
    private Random mRandom;
    private Check[] mChecks;
    private LicenseKeyAlgorithm.LicenseAlgParams mLAP;

    private void init(LicenseKeyAlgorithm.LicenseAlgParams pLAP) {
        long vSeed = Math.abs(new BigInteger(new SHAHash().makeHash(new Long(new Date().getTime() / 12L ^ 0x110F02L).toString()), 16).longValue());
        this.mRandom = new Random(vSeed);
        this.mChecks = new Check[]{new WordCheck1(), new WordCheck2(), new WordCheck3(), new WordCheck4()};
        this.mLAP = pLAP;
    }

    public String[] generateKeys(LicenseKeyAlgorithm.LicenseAlgParams pLAP, int pKeyCount) {
        this.init(pLAP);
        String[] vKeys = new String[pKeyCount];
        for (int i = 0; i < pKeyCount; ++i) {
            String vKey = null;
            vKey = this.buildKey();
            for (int j = 0; j < i; ++j) {
                if (!vKeys[j].equals(vKey)) continue;
            }
            vKeys[i] = vKey;
        }
        return vKeys;
    }

    private String buildKey() {
        while (true) {
            int[] W;
            byte[] vBytes;
            if (new FinalKeyCheck().applyCheck(vBytes = new byte[]{(byte)((W = new int[]{this.buildAndVerifyWord(3), this.buildAndVerifyWord(2), this.buildAndVerifyWord(1), this.buildAndVerifyWord(0)})[0] & 0xF), (byte)(W[0] >> 4 & 0xF), (byte)(W[0] >> 8 & 0xF), (byte)(W[0] >> 12 & 0xF), (byte)(W[1] & 0xF), (byte)(W[1] >> 4 & 0xF), (byte)(W[1] >> 8 & 0xF), (byte)(W[1] >> 12 & 0xF), (byte)(W[2] & 0xF), (byte)(W[2] >> 4 & 0xF), (byte)(W[2] >> 8 & 0xF), (byte)(W[2] >> 12 & 0xF), (byte)(W[3] & 0xF), (byte)(W[3] >> 4 & 0xF), (byte)(W[3] >> 8 & 0xF), (byte)(W[3] >> 12 & 0xF)})) {
                System.out.println("Misses: " + this.mMisses);
                this.mMisses = 0;
                StringBuffer vKey = new StringBuffer("");
                for (int i = vBytes.length - 1; i >= 0; --i) {
                    vKey.append(Integer.toHexString(vBytes[i]).toUpperCase());
                    if (i % 4 != 0 || i <= 0) continue;
                    vKey.append("-");
                }
                return vKey.toString();
            }
            ++this.mMisses;
        }
    }

    public boolean verifyKey(LicenseKeyAlgorithm.LicenseAlgParams pLAP, String pKey) {
        this.init(pLAP);
        if (Utils.isEmptyString(pKey) || pKey.length() != this.mLAP.mWordCount * 4 + (this.mLAP.mWordCount - 1)) {
            return false;
        }
        int vHyphenCount = 0;
        for (int i = 0; i < pKey.length(); ++i) {
            if (pKey.charAt(i) == '-') {
                ++vHyphenCount;
                continue;
            }
            if (Character.digit(pKey.charAt(i), 16) != -1) continue;
            return false;
        }
        if (vHyphenCount != this.mLAP.mWordCount - 1) {
            return false;
        }
        String vModifiedKey = pKey.replaceAll("-", "");
        int vWordToVerify = vModifiedKey.length() / 4 - 1;
        byte[] vBytes = new byte[vModifiedKey.length()];
        for (int i = vModifiedKey.length() - 1; i >= 0; --i) {
            byte[] vWord;
            vBytes[vModifiedKey.length() - 1 - i] = (byte)(Integer.parseInt(new Character(vModifiedKey.charAt(i)).toString(), 16) & 0xF);
            if (i % 4 != 0 || this.verifyWord(vWord = new byte[]{vBytes[vModifiedKey.length() - 1 - i], vBytes[vModifiedKey.length() - 1 - i - 1], vBytes[vModifiedKey.length() - 1 - i - 2], vBytes[vModifiedKey.length() - 1 - i - 3]}, vWordToVerify--)) continue;
            return false;
        }
        return new FinalKeyCheck().applyCheck(vBytes);
    }

    private boolean verifyWord(byte[] pDigits, int pWord) {
        return this.mChecks[pWord].applyCheck(pDigits);
    }

    private int buildAndVerifyWord(int pWord) {
        while (true) {
            int vKey = this.mRandom.nextInt() >> 16 ^ this.mRandom.nextInt() & 0xFFFF;
            byte[] vDigits = new byte[]{(byte)(vKey >> 12 & 0xF), (byte)(vKey >> 8 & 0xF), (byte)(vKey >> 4 & 0xF), (byte)(vKey & 0xF)};
            if (this.verifyWord(vDigits, pWord)) {
                return vKey & 0xFFFF;
            }
            ++this.mMisses;
        }
    }

    class FinalKeyCheck
    implements Check {
        FinalKeyCheck() {
        }

        public boolean applyCheck(byte[] pDigits) {
            int vTotal = 0;
            double vTotalProductWithSeeds = 1.0;
            for (int i = 0; i < pDigits.length; ++i) {
                vTotal += pDigits[i];
                if (i % 2 == 0) {
                    vTotalProductWithSeeds += (double)((long)(pDigits[i] == 0 ? 1 : pDigits[i]) * (long)((BasicLicenseKeyAlgorithm)BasicLicenseKeyAlgorithm.this).mLAP.mSeed[i]);
                    continue;
                }
                vTotalProductWithSeeds *= (double)((long)(pDigits[i] == 0 ? 1 : pDigits[i]) * (long)((BasicLicenseKeyAlgorithm)BasicLicenseKeyAlgorithm.this).mLAP.mSeed[i]);
            }
            long vTPWS = (long)(vTotalProductWithSeeds / -1.0);
            return vTotal % ((BasicLicenseKeyAlgorithm)BasicLicenseKeyAlgorithm.this).mLAP.mENF == 0 && vTotal % ((BasicLicenseKeyAlgorithm)BasicLicenseKeyAlgorithm.this).mLAP.mNENF != 0 && vTPWS % (long)((BasicLicenseKeyAlgorithm)BasicLicenseKeyAlgorithm.this).mLAP.mPENF == 0L;
        }
    }

    class WordCheck4
    implements Check {
        WordCheck4() {
        }

        public boolean applyCheck(byte[] pDigits) {
            int vValue = (pDigits[0] + pDigits[1]) * (pDigits[2] * pDigits[3]);
            return vValue != 0 && vValue % ((BasicLicenseKeyAlgorithm)BasicLicenseKeyAlgorithm.this).mLAP.mWF[3] == 0;
        }
    }

    class WordCheck3
    implements Check {
        WordCheck3() {
        }

        public boolean applyCheck(byte[] pDigits) {
            int vValue = pDigits[3] * pDigits[2] * pDigits[1] * pDigits[0];
            return vValue != 0 && vValue % ((BasicLicenseKeyAlgorithm)BasicLicenseKeyAlgorithm.this).mLAP.mWF[2] == 0;
        }
    }

    class WordCheck2
    implements Check {
        WordCheck2() {
        }

        public boolean applyCheck(byte[] pDigits) {
            int vValue = pDigits[3] * pDigits[2] + pDigits[1] * pDigits[0];
            return vValue != 0 && vValue % ((BasicLicenseKeyAlgorithm)BasicLicenseKeyAlgorithm.this).mLAP.mWF[1] == 0;
        }
    }

    class WordCheck1
    implements Check {
        WordCheck1() {
        }

        public boolean applyCheck(byte[] pDigits) {
            return pDigits[3] + pDigits[1] < pDigits[2] + pDigits[0];
        }
    }

    static interface Check {
        public boolean applyCheck(byte[] var1);
    }
}

