/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.core;

import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.exceptions.ExceptionHelper;
import net.za.pwnconsulting.javaconfig.exceptions.ProgrammerMistakeException;
import net.za.pwnconsulting.logmon.clientapi.LogMonClientAPI;
import net.za.pwnconsulting.logmon.clientapi.LogMonOwner;
import net.za.pwnconsulting.logmon.clientapi.LogMonPerfCounter;
import org.apache.log4j.Logger;

public class BasicLogger {
    private static LMS mLogMonLogger = null;
    private static BasicLogger mBasicLogger = null;

    BasicLogger() {
    }

    public void init(LMS pLogMonLogger) {
        mLogMonLogger = pLogMonLogger;
        mBasicLogger = this;
    }

    public static BasicLogger getBasicLogger() {
        if (mBasicLogger == null) {
            Thread.dumpStack();
            throw new ProgrammerMistakeException("The contract for BasicLogger is that the base framework boot code will instantiate it and only later will it be used.  This contract has now been broken.  A stack trace was dumped to the console.");
        }
        return mBasicLogger;
    }

    public void info(Logger pLogger, LogMonOwner pOwner, String pMessage) {
        if (mLogMonLogger != null) {
            mLogMonLogger.getClientAPI().logInfo(pOwner, pMessage, "");
        } else {
            pLogger.info((Object)pMessage);
        }
    }

    public void warn(Logger pLogger, LogMonOwner pOwner, String pMessage) {
        if (mLogMonLogger != null) {
            mLogMonLogger.getClientAPI().logWarning(pOwner, pMessage, "");
        } else {
            pLogger.warn((Object)pMessage);
        }
    }

    public void error(Logger pLogger, LogMonOwner pOwner, String pMessage) {
        if (mLogMonLogger != null) {
            mLogMonLogger.getClientAPI().logError(pOwner, pMessage, "");
        } else {
            pLogger.error((Object)pMessage);
        }
    }

    public void debug(Logger pLogger, LogMonOwner pOwner, String pMessage) {
        if (mLogMonLogger != null) {
            mLogMonLogger.getClientAPI().logDebug(pOwner, pMessage, "");
        } else {
            pLogger.debug((Object)pMessage);
        }
    }

    public void performance(Logger pLogger, LogMonOwner pOwner, LogMonPerfCounter[] pLogMonPerfCounters) {
        if (mLogMonLogger != null) {
            mLogMonLogger.getClientAPI().logPerformance(pOwner, pLogMonPerfCounters);
        }
    }

    public void error(Logger pLogger, LogMonOwner pOwner, String pMessage, Throwable pThrowable) {
        if (mLogMonLogger != null) {
            mLogMonLogger.getClientAPI().logError(pOwner, pMessage, ExceptionHelper.getFullStackTrace(pThrowable));
        } else {
            pLogger.error((Object)pMessage, pThrowable);
        }
    }

    public boolean isDebugEnabled(Logger pLogger) {
        if (mLogMonLogger != null) {
            return true;
        }
        return pLogger.isDebugEnabled();
    }

    public boolean isUsingLogMon() {
        return mLogMonLogger != null;
    }

    public final String getSystemID() {
        return mLogMonLogger.getSystemID();
    }

    public final String getNodeID() {
        return mLogMonLogger.getNodeID();
    }

    public final LogMonClientAPI getLogMonLogger() {
        return mLogMonLogger.getClientAPI();
    }
}

