/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.core;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.za.pwnconsulting.javaconfig.core.AbstractConfiguration;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.security.Privilege;
import net.za.pwnconsulting.javaconfig.security.Privileges;
import net.za.pwnconsulting.javaconfig.security.Role;
import net.za.pwnconsulting.javaconfig.security.Roles;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.apache.log4j.PropertyConfigurator;
import org.dom4j.Document;

public class BasicConfiguration
extends AbstractConfiguration {
    protected Roles mRoles = new Roles();
    protected Privileges mPrivileges = new Privileges();
    protected String mAppName = "__UNDEFINED__";
    private String mLogMonJNDIName;
    private boolean mFailOnError;
    public static final String XML_DOCUMENT_NAME = "j2ee-app";
    private static final String XML_DOCUMENT_VERSION = "2.0";
    private static final String CURRENT_HOST_NAME = "${CurrentHostName}";
    private static final String CURRENT_IP = "${CurrentIP}";

    protected void initConfig(Document pDocument) throws ConfigurationException {
        try {
            String vVersionS = pDocument.valueOf("/j2ee-app/@version");
            if (vVersionS == null || vVersionS.equals("")) {
                throw new ConfigurationException("The XML configuration document does not contain a valid version for the application");
            }
            float vVersion = Float.parseFloat(vVersionS);
            if (vVersion > Float.parseFloat(XML_DOCUMENT_VERSION)) {
                throw new ConfigurationException("Your j2ee-app.xml file is at a newer version [" + vVersionS + "], it should be at version [" + XML_DOCUMENT_VERSION + "] or lower for this release of JavaConfig");
            }
            if ((int)vVersion < (int)Float.parseFloat(XML_DOCUMENT_VERSION)) {
                throw new ConfigurationException("Your j2ee-app.xml file is at an older major version [" + vVersionS + "], it should be at version [" + XML_DOCUMENT_VERSION + "] or newer for this release of JavaConfig");
            }
            if (pDocument.selectSingleNode("/j2ee-app/global/logger/log4jlogger") != null) {
                String vLogFilePath = pDocument.valueOf("/j2ee-app/global/logger/log4jlogger/@configfile_path");
                if (vLogFilePath == null || vLogFilePath.equals("")) {
                    throw new ConfigurationException("The XML configuration document does not contain a valid path to the log4j logger configuration file");
                }
                URL vURL = this.getClass().getResource(vLogFilePath);
                if (vURL == null) {
                    throw new ConfigurationException("The XML configuration document contains a path to the log4j logger configuration file that does not exist");
                }
                PropertyConfigurator.configure((URL)vURL);
                new BasicLogger().init(null);
            } else if (pDocument.selectSingleNode("/j2ee-app/global/logger/LogMonlogger") != null) {
                this.mLogMonJNDIName = pDocument.valueOf("/j2ee-app/global/logger/LogMonlogger/@jndi_name");
                String vLogMonSystemID = pDocument.valueOf("/j2ee-app/global/logger/LogMonlogger/@systemid");
                String vLogMonNodeID = pDocument.valueOf("/j2ee-app/global/logger/LogMonlogger/@nodeid");
                this.mFailOnError = new Boolean(pDocument.valueOf("/j2ee-app/global/logger/LogMonlogger/@fail_on_error"));
                if (this.mLogMonJNDIName == null || this.mLogMonJNDIName.equals("")) {
                    throw new ConfigurationException("The XML configuration document does not contain a valid JNDI name for the LogMon logger");
                }
                if (vLogMonSystemID == null || vLogMonSystemID.equals("")) {
                    throw new ConfigurationException("The XML configuration document does not contain a valid systemid for the LogMon logger");
                }
                if (vLogMonNodeID == null || vLogMonNodeID.equals("")) {
                    throw new ConfigurationException("The XML configuration document does not contain a valid nodeid for the LogMon logger");
                }
                if (vLogMonNodeID.equals(CURRENT_HOST_NAME)) {
                    try {
                        vLogMonNodeID = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    catch (UnknownHostException e) {
                        throw new ConfigurationException("Could not determine the current machine's host name: " + e.getMessage(), e);
                    }
                }
                if (vLogMonNodeID.equals(CURRENT_IP)) {
                    try {
                        vLogMonNodeID = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        throw new ConfigurationException("Could not determine the current machine's host address: " + e.getMessage(), e);
                    }
                }
                this.mLogMonLogger = new LMS(this.mLogMonJNDIName, this.mFailOnError, vLogMonSystemID, vLogMonNodeID);
                new BasicLogger().init(this.mLogMonLogger);
            } else {
                throw new ConfigurationException("The XML configuration document does not contain a valid logger definition");
            }
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Loading JavaConfig...");
            this.mAppName = pDocument.valueOf("/j2ee-app/@app_name");
            if (this.mAppName == null || this.mAppName.equals("")) {
                throw new ConfigurationException("The XML configuration document does not contain a valid name for the application");
            }
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Reading security node...");
            if (pDocument.selectSingleNode("/j2ee-app/security/privileges") != null) {
                int vCnt = Utils.getInt(pDocument.valueOf("count(/j2ee-app/security/privileges/privilege)"));
                for (int i = 1; i <= vCnt; ++i) {
                    String vPrivilegeName = pDocument.valueOf("/j2ee-app/security/privileges/privilege[" + i + "]/@name");
                    String vPrivilegeValue = pDocument.valueOf("/j2ee-app/security/privileges/privilege[" + i + "]/@value");
                    this.mPrivileges.addPrivilege(new Privilege(vPrivilegeName, Integer.parseInt(vPrivilegeValue)));
                }
            }
            if (pDocument.selectSingleNode("/j2ee-app/security/roles") != null) {
                int vCnt = Utils.getInt(pDocument.valueOf("count(/j2ee-app/security/roles/role)"));
                for (int i = 1; i <= vCnt; ++i) {
                    String vRoleName = pDocument.valueOf("/j2ee-app/security/roles/role[" + i + "]/@name");
                    if (!Utils.isValidInteger(pDocument.valueOf("/j2ee-app/security/roles/role[" + i + "]/@unique-id"))) {
                        throw new ConfigurationException("Invalid role ID for role [" + vRoleName + "] - must be an integer");
                    }
                    int vRoleID = Utils.getInt(pDocument.valueOf("/j2ee-app/security/roles/role[" + i + "]/@unique-id"));
                    boolean vVisible = Utils.getBool(pDocument.valueOf("/j2ee-app/security/roles/role[" + i + "]/@visible"));
                    ArrayList<Privilege> vPrivileges = new ArrayList<Privilege>();
                    int vCnt2 = Utils.getInt(pDocument.valueOf("count(/j2ee-app/security/roles/role[" + i + "]/privilege_name)"));
                    for (int j = 1; j <= vCnt2; ++j) {
                        String vRolePrivilege = pDocument.valueOf("/j2ee-app/security/roles/role[" + i + "]/privilege_name[" + j + "]");
                        vPrivileges.add(this.mPrivileges.getPrivilegeByName(vRolePrivilege));
                    }
                    this.mRoles.addRole(new Role(vRoleName, vRoleID, vVisible, vPrivileges));
                    if (vPrivileges.size() > 0) continue;
                    BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_JAVACONFIG, "No privileges are defined for role [" + vRoleName + "] - this might be an oversight");
                }
            }
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "Asking subclasses to continue parsing config file...");
            this.mBeanFactory.init();
        }
        catch (Exception e) {
            throw new ConfigurationException("Internal Error loading the configuration: " + e.getMessage(), e);
        }
    }

    protected void setDocumentName() {
        this.mDocumentName = XML_DOCUMENT_NAME;
    }

    public Roles getRoles() {
        return this.mRoles;
    }

    public Privileges getPrivileges() {
        return this.mPrivileges;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getLogMonJNDIName() {
        return this.mLogMonJNDIName;
    }

    public boolean isFailOnError() {
        return this.mFailOnError;
    }
}

