/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import net.za.pwnconsulting.javaconfig.beans.BeanFactory;
import net.za.pwnconsulting.javaconfig.core.Configuration;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.core.Parameter;
import net.za.pwnconsulting.javaconfig.core.Settings;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractConfiguration
implements Configuration {
    private String mConfigFilePath;
    protected String mDocumentName;
    protected Document mDocument;
    protected Settings mSettings;
    protected BeanFactory mBeanFactory;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());
    protected LMS mLogMonLogger = null;

    protected AbstractConfiguration() {
        this.mSettings = new Settings();
        this.setDocumentName();
        this.mBeanFactory = new BeanFactory(this);
    }

    public void init(String pConfigFilePath) throws ConfigurationException {
        this.mConfigFilePath = pConfigFilePath;
        if (this.mDocumentName == null || this.mDocumentName.equals("")) {
            throw new ConfigurationException("Document name was not specified in subclass");
        }
        if (this.mConfigFilePath == null || this.mConfigFilePath.equals("")) {
            throw new ConfigurationException("Config file path name was not specified");
        }
        try {
            SAXReader vReader = new SAXReader();
            vReader.setValidation(true);
            URL vInput = this.getClass().getResource(this.mConfigFilePath);
            if (vInput == null) {
                throw new ConfigurationException("Could not locate file [" + pConfigFilePath + "] in classpath - maybe wrong classloader order?");
            }
            vReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String pPublicID, String pSystemID) throws SAXException, IOException {
                    String vPath = Utils.makeProperString(pSystemID).substring(Utils.makeProperString(pSystemID).indexOf(":/") + 1);
                    URL vURL = this.getClass().getResource(vPath);
                    if (vURL == null) {
                        throw new ConfigurationException("Can not locate the DTD at for [" + this.getClass().getName() + "] from [" + vPath + "]");
                    }
                    return new InputSource(vURL.openStream());
                }
            });
            this.mDocument = vReader.read(vInput);
            String vRootElement = this.mDocument.getRootElement().getName();
            if (!vRootElement.trim().equals(this.mDocumentName)) {
                throw new ConfigurationException("The XML configuration document is not a valid [" + this.mDocumentName + "] document [" + this.mConfigFilePath + "]");
            }
            if (this.mDocument.selectSingleNode("/" + this.mDocumentName + "/parameters") != null) {
                int vCnt = Utils.getInt(this.mDocument.valueOf("count(/" + this.mDocumentName + "/parameters/param)"));
                for (int i = 1; i <= vCnt; ++i) {
                    String vParamName = this.mDocument.valueOf("/" + this.mDocumentName + "/parameters/param[" + i + "]/@name");
                    String vParamValue = this.mDocument.valueOf("/" + this.mDocumentName + "/parameters/param[" + i + "]/@value");
                    this.mSettings.addParameter(new Parameter(vParamName, vParamValue));
                }
            }
            if (this.mDocument.selectSingleNode("/" + this.mDocumentName + "/host_specific_parameters") != null) {
                int vHostCnt = Utils.getInt(this.mDocument.valueOf("count(/" + this.mDocumentName + "/host_specific_parameters/host)"));
                String vCurrentHost = null;
                boolean vFound = false;
                if (vHostCnt > 0) {
                    try {
                        vCurrentHost = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        throw new ConfigurationException("Could not determine the current machine's host name: " + e.getMessage(), e);
                    }
                }
                Node vDefaultNode = null;
                for (int i = 1; i <= vHostCnt; ++i) {
                    String vHostName = this.mDocument.valueOf("/" + this.mDocumentName + "/host_specific_parameters/host[" + i + "]/@name");
                    String vDescription = this.mDocument.valueOf("/" + this.mDocumentName + "/host_specific_parameters/host[" + i + "]/@description");
                    if (Utils.isEmptyString(vHostName)) {
                        throw new ConfigurationException("Empty host name attribute found in the host_specific_parameters section for document [" + this.mConfigFilePath + "]");
                    }
                    if (Utils.makeProperString(vHostName).equals("*")) {
                        vDefaultNode = this.mDocument.selectSingleNode("/" + this.mDocumentName + "/host_specific_parameters/host[" + i + "]");
                        continue;
                    }
                    String[] vHosts = vHostName.split(",");
                    for (int j = 0; j < vHosts.length; ++j) {
                        vHosts[j] = Utils.makeProperString(vHosts[j].toUpperCase());
                    }
                    if (!Arrays.asList(vHosts).contains(vCurrentHost.toUpperCase())) continue;
                    int vCnt = Utils.getInt(this.mDocument.valueOf("count(/" + this.mDocumentName + "/host_specific_parameters/host[" + i + "]/param)"));
                    for (int j = 1; j <= vCnt; ++j) {
                        String vParamName = this.mDocument.valueOf("/" + this.mDocumentName + "/host_specific_parameters/host[" + i + "]/param[" + j + "]/@name");
                        String vParamValue = this.mDocument.valueOf("/" + this.mDocumentName + "/host_specific_parameters/host[" + i + "]/param[" + j + "]/@value");
                        this.mSettings.addParameter(new Parameter(vParamName, vParamValue));
                    }
                    vFound = true;
                    break;
                }
                if (vHostCnt > 0 && !vFound) {
                    if (vDefaultNode != null) {
                        int vCnt = Utils.getInt(vDefaultNode.valueOf("count(./param)"));
                        for (int j = 1; j <= vCnt; ++j) {
                            String vParamName = vDefaultNode.valueOf("./param[" + j + "]/@name");
                            String vParamValue = vDefaultNode.valueOf("./param[" + j + "]/@value");
                            this.mSettings.addParameter(new Parameter(vParamName, vParamValue));
                        }
                    } else {
                        throw new ConfigurationException("Could not locate the current host name [" + vCurrentHost + "] in the list of defined host_specific_parameters hosts in document [" + this.mConfigFilePath + "]");
                    }
                }
            }
            this.initConfig(this.mDocument);
            this.mBeanFactory.init();
        }
        catch (DocumentException e) {
            throw new ConfigurationException("Internal Error loading the configuration: " + e.getMessage(), e);
        }
    }

    protected abstract void initConfig(Document var1) throws ConfigurationException;

    protected abstract void setDocumentName();

    public String getSpecificNode(String pXPathNodeName) throws ConfigurationException {
        try {
            String vNodeValue = this.mDocument.valueOf(pXPathNodeName);
            if (vNodeValue == null || vNodeValue.equals("")) {
                throw new ConfigurationException("The XML configuration document does not contain the entry requested [" + pXPathNodeName + "]");
            }
            return vNodeValue;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Internal Error locating the node in the configuration: " + e.getMessage(), e);
        }
    }

    public boolean existsSpecificNode(String pXPathNodeName) throws ConfigurationException {
        try {
            String vNodeValue = this.mDocument.valueOf(pXPathNodeName);
            return vNodeValue != null && !vNodeValue.equals("");
        }
        catch (Exception e) {
            throw new ConfigurationException("Internal Error locating the node in the configuration: " + e.getMessage(), e);
        }
    }

    public BeanFactory getBeanFactory() {
        return this.mBeanFactory;
    }

    public Settings getSettings() {
        return this.mSettings;
    }

    public void shutdown() {
        if (this.mBeanFactory != null) {
            this.mBeanFactory.shutdown();
        }
        this.mBeanFactory = null;
    }
}

