/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.concurrent.locking;

import java.util.List;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.javaconfig.concurrent.locking.Lock;
import net.za.pwnconsulting.javaconfig.concurrent.locking.LockActiveException;
import net.za.pwnconsulting.javaconfig.concurrent.locking.LockException;
import net.za.pwnconsulting.javaconfig.concurrent.locking.LockLocator;
import net.za.pwnconsulting.javaconfig.concurrent.locking.LockLocatorFactory;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;

public class LockManager {
    public synchronized void acquireLock(String pLockOwner, String pLockName, int pLockType, int pLockGranularity, Object pLockedObjectKey) throws LockException, LockActiveException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            if (vLocator.isLockActive(pLockName, pLockedObjectKey)) {
                throw new LockActiveException("Could not acquire lock [" + pLockName + "] as it is already active");
            }
            vLocator.saveLock(new Lock(pLockOwner, pLockName, pLockType, pLockGranularity, pLockedObjectKey));
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not acquire lock because: " + e.getMessage(), e);
        }
    }

    public synchronized void acquireLockTransacted(String pLockOwner, String pLockName, int pLockType, int pLockGranularity, Object pLockedObjectKey, SQLBatch pSQLBatch) throws LockException, LockActiveException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            if (vLocator.isLockActive(pLockName, pLockedObjectKey)) {
                throw new LockActiveException("Could not acquire lock [" + pLockName + "], key [" + pLockedObjectKey + "] as it is already active");
            }
            pSQLBatch.addAllSQLStatements(vLocator.saveLockTransacted(new Lock(pLockOwner, pLockName, pLockType, pLockGranularity, pLockedObjectKey)));
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not acquire lock because: " + e.getMessage(), e);
        }
    }

    public boolean isLockActive(String pLockName, Object pLockedObjectKey) throws LockException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            return vLocator.isLockActive(pLockName, pLockedObjectKey);
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not test lock because: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new LockException("Could not test lock because: " + e.getMessage(), e);
        }
    }

    public void releaseLock(String pLockName, Object pLockedObjectKey) throws LockException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            if (!vLocator.isLockActive(pLockName, pLockedObjectKey)) {
                throw new LockActiveException("Could not release lock [" + pLockName + "], key [" + pLockedObjectKey + "] as it is not active");
            }
            vLocator.removeLock(pLockName, pLockedObjectKey);
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not remove lock because: " + e.getMessage(), e);
        }
    }

    public void releaseAllLocksOwnedBy(String pLockOwner, String pLockName) throws LockException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            vLocator.removeAllLocksOwnedBy(pLockOwner, pLockName);
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not remove locks because: " + e.getMessage(), e);
        }
    }

    public void releaseAllLocksOwnedBy(String pLockOwner) throws LockException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            vLocator.removeAllLocksOwnedBy(pLockOwner);
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not remove locks because: " + e.getMessage(), e);
        }
    }

    public List retrieveAllLocks() throws LockException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            return vLocator.retrieveAllLocks();
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not retrieve locks because: " + e.getMessage(), e);
        }
    }

    public void releaseAllLocks() throws LockException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            vLocator.removeAllLocks();
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not remove locks because: " + e.getMessage(), e);
        }
    }

    public Lock getLock(String pLockName, Object pLockedObjectKey) throws LockException {
        try {
            LockLocator vLocator = LockLocatorFactory.getLockLocator();
            if (!vLocator.isLockActive(pLockName, pLockedObjectKey)) {
                throw new LockActiveException("Could not locate lock [" + pLockName + "] as it is not active");
            }
            return LockLocatorFactory.getLockLocator().getLock(pLockName, pLockedObjectKey);
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not retrieve lock because: " + e.getMessage(), e);
        }
    }
}

