/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.concurrent.locking;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.locking.XLayerProperties;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.javaconfig.concurrent.locking.Lock;
import net.za.pwnconsulting.javaconfig.concurrent.locking.LockException;
import net.za.pwnconsulting.javaconfig.concurrent.locking.LockLocator;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;
import net.za.pwnconsulting.javaconfig.support.ApplicationContext;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocatorException;
import net.za.pwnconsulting.javaconfig.utils.MapUtils;
import org.apache.log4j.Logger;

public class J2EELockLocator
implements LockLocator {
    public static final String APP_CTX_WEBMVC_PATH = "WebMVC";
    public static final String DB_NAME_TABLE = "DBLockTableName";
    public static final String DB_NAME_NAME_FIELD = "DBLockNameFieldName";
    public static final String DB_NAME_OBJECT_KEY_FIELD = "DBLockObjectKeyFieldName";
    public static final String DB_NAME_OWNER_FIELD = "DBLockOwnerFieldName";
    public static final String DB_NAME_LOCK_TYPE_FIELD = "DBLockTypeFieldName";
    public static final String DB_NAME_POOL = "DBLockPool";
    private static String mTableName;
    private static String mNameFieldName;
    private static String mObjectKeyFieldName;
    private static String mOwnerFieldName;
    private static String mLockTypeFieldName;
    private static String mAppName;
    private static String mDBPool;
    private static ApplicationContext mAC;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());

    public void removeLock(String pLockName, Object pLockedObjectKey) throws LockException {
        long vStart = System.currentTimeMillis();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Trying to remove lock [" + pLockName + "], lock object key [" + pLockedObjectKey + "]....");
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        SQLBatch vSQLBatch = new SQLBatch(true, mDBPool);
        vSQLBatch.addSQLStatement(new SQLStatement("delete from " + mTableName + " where " + mNameFieldName + " = ? and " + mObjectKeyFieldName + " = ?", new Object[]{pLockName, pLockedObjectKey.toString()}, false));
        vDBLayer.submitTransaction(vSQLBatch);
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Removed lock [" + pLockName + "], lock object key [" + pLockedObjectKey + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
    }

    public void removeAllLocksOwnedBy(String pLockOwner, String pLockName) throws LockException {
        long vStart = System.currentTimeMillis();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Trying to remove all locks [" + pLockName + "], lock owner [" + pLockOwner + "]....");
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        SQLBatch vSQLBatch = new SQLBatch(true, mDBPool);
        vSQLBatch.addSQLStatement(new SQLStatement("delete from " + mTableName + " where " + mNameFieldName + " = ? and " + mOwnerFieldName + " = ?", new Object[]{pLockName, pLockOwner}, false));
        vDBLayer.submitTransaction(vSQLBatch);
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Removed all locks [" + pLockName + "], lock owner [" + pLockOwner + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
    }

    public void removeAllLocksOwnedBy(String pLockOwner) throws LockException {
        long vStart = System.currentTimeMillis();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Trying to remove all locks owned by [" + pLockOwner + "]....");
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        SQLBatch vSQLBatch = new SQLBatch(true, mDBPool);
        vSQLBatch.addSQLStatement(new SQLStatement("delete from " + mTableName + " where " + mOwnerFieldName + " = ?", new Object[]{pLockOwner}, false));
        vDBLayer.submitTransaction(vSQLBatch);
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Removed all locks owned by [" + pLockOwner + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
    }

    public void removeAllLocks() throws LockException {
        long vStart = System.currentTimeMillis();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Trying to remove all locks ....");
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        SQLBatch vSQLBatch = new SQLBatch(true, mDBPool);
        vSQLBatch.addSQLStatement(new SQLStatement("delete from " + mTableName, new Object[0], false));
        vDBLayer.submitTransaction(vSQLBatch);
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Removed all locks in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
    }

    public List retrieveAllLocks() throws LockException {
        long vStart = System.currentTimeMillis();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Trying to get all locks ....");
        ArrayList<Lock> vResult = new ArrayList<Lock>();
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        List vRes = vDBLayer.queryDatabase("select * from " + mTableName, new Object[0], mDBPool);
        for (int i = 0; i < vRes.size(); ++i) {
            Map vRow = (Map)vRes.get(i);
            String vLockName = MapUtils.getMapValueAsString(vRow, mNameFieldName, true);
            String vLockObjectKey = MapUtils.getMapValueAsString(vRow, mObjectKeyFieldName, true);
            String vLockOwner = MapUtils.getMapValueAsString(vRow, mOwnerFieldName, true);
            int vLockType = MapUtils.getMapValueAsInteger(vRow, mLockTypeFieldName);
            vResult.add(new Lock(vLockOwner, vLockName, vLockType, -1, vLockObjectKey));
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Retrieved all locks in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
        return vResult;
    }

    public void saveLock(Lock pLock) throws LockException {
        long vStart = System.currentTimeMillis();
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        vDBLayer.submitTransaction(this.saveLockTransacted(pLock));
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Saved lock [" + pLock.getLockName() + "], lock owner [" + pLock.getLockOwner() + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
    }

    public SQLBatch saveLockTransacted(Lock pLock) throws LockException {
        long vStart = System.currentTimeMillis();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Trying to save lock [" + pLock.getLockName() + "], lock owner [" + pLock.getLockOwner() + "]....");
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        SQLBatch vSQLBatch = new SQLBatch(true, mDBPool, new XLayerProperties(true, 8));
        vSQLBatch.addSQLStatement(new SQLStatement("delete from " + mTableName + " where " + mNameFieldName + " = ? and " + mObjectKeyFieldName + " = ?", new Object[]{pLock.getLockName(), pLock.getLockedObjectKey().toString()}, false));
        vSQLBatch.addSQLStatement(new SQLStatement("insert into " + mTableName + " (" + mNameFieldName + "," + mObjectKeyFieldName + "," + mOwnerFieldName + "," + mLockTypeFieldName + ") values (?,?,?,?)", new Object[]{pLock.getLockName(), pLock.getLockedObjectKey().toString(), pLock.getLockOwner(), new Integer(pLock.getLockType())}, false));
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Returned batch for saving of lock [" + pLock.getLockName() + "], lock owner [" + pLock.getLockOwner() + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
        return vSQLBatch;
    }

    public Lock getLock(String pLockName, Object pLockedObjectKey) throws LockException {
        long vStart = System.currentTimeMillis();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Trying to get lock [" + pLockName + "], lock object key [" + pLockedObjectKey + "]....");
        DBLayer vDBLayer = mAC.getDBLayer(mAppName);
        List vRes = vDBLayer.queryDatabase("select * from " + mTableName + " where " + mNameFieldName + " = ? and " + mObjectKeyFieldName + " = ?", new Object[]{pLockName, pLockedObjectKey.toString()}, mDBPool);
        if (vRes.size() <= 0) {
            throw new LockException("The lock [" + pLockName + "] for lock object key [" + pLockedObjectKey + "] does not exist in the lock area");
        }
        if (vRes.size() > 1) {
            throw new LockException("The lock [" + pLockName + "] for lock object key [" + pLockedObjectKey + "] was found multiple times in the system. " + "The current version of JavaConfig does not support this. This is a bug");
        }
        Map vRow = (Map)vRes.get(0);
        String vLockName = MapUtils.getMapValueAsString(vRow, mNameFieldName, true);
        String vLockObjectKey = MapUtils.getMapValueAsString(vRow, mObjectKeyFieldName, true);
        String vLockOwner = MapUtils.getMapValueAsString(vRow, mOwnerFieldName, true);
        int vLockType = MapUtils.getMapValueAsInteger(vRow, mLockTypeFieldName);
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Retrieved lock [" + pLockName + "], lock object key [" + pLockedObjectKey + "] in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
        return new Lock(vLockOwner, vLockName, vLockType, -1, vLockObjectKey);
    }

    public boolean isLockActive(String pLockName, Object pLockedObjectKey) throws LockException {
        try {
            long vStart = System.currentTimeMillis();
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Trying to check whether lock is active [" + pLockName + "], lock object key [" + pLockedObjectKey + "]....");
            DBLayer vDBLayer = mAC.getDBLayer(mAppName);
            List vRes = vDBLayer.queryDatabase("select * from " + mTableName + " where " + mNameFieldName + " = ? and " + mObjectKeyFieldName + " = ?", new Object[]{pLockName, pLockedObjectKey.toString()}, mDBPool);
            boolean vActive = vRes.size() > 0;
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Lock [" + pLockName + "], key [" + pLockedObjectKey + "] is active: " + new Boolean(vActive) + " in [" + (System.currentTimeMillis() - vStart) / 1000L + "] seconds");
            return vActive;
        }
        catch (ConfigurationException e) {
            throw new LockException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new LockException("Could not locate bean factory: " + e.getMessage(), e);
        }
        catch (JNDIException e) {
            throw new LockException("JNDI Error: " + e.getMessage(), e);
        }
    }

    static {
        mAC = new ApplicationContextLocator().getApplicationContext();
        mAppName = new ApplicationContextLocator().getApplicationName();
        mTableName = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_TABLE);
        mNameFieldName = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_NAME_FIELD);
        mObjectKeyFieldName = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_OBJECT_KEY_FIELD);
        mOwnerFieldName = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_OWNER_FIELD);
        mLockTypeFieldName = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_LOCK_TYPE_FIELD);
        mDBPool = mAC.getBasicConfiguration(mAppName).getSettings().getParameterByName(DB_NAME_POOL);
    }
}

